/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.smartling.aem.connector.automation.impl.Language;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.PageLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.WcmWorkflows;
import com.smartling.aem.connector.automation.impl.workflow.JobWorkflowParameters;
import com.smartling.aem.connector.automation.impl.workflow.SendForTranslationProcess;
import com.smartling.aem.connector.automation.impl.workflow.WorkflowUtil;
import com.smartling.aem.connector.core.impl.integration.SmartlingPlatformClientFactory;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class SendPageForTranslationProcess
extends SendForTranslationProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendPageForTranslationProcess.class);
    @Reference
    private SmartlingPlatformClientFactory smartlingPlatformClientFactory;
    @Reference
    private PageLanguageCopyManager languageCopyManager;
    @Reference
    private WcmWorkflows wcmWorkflows;

    @Override
    public void updateLanguageCopy(WorkflowSession workflowSession, WcmWorkflows.Parameters parameters) throws WorkflowException {
        this.wcmWorkflows.updateLanguageCopy(workflowSession, parameters);
    }

    @Override
    public SmartlingPlatformClientFactory getSmartlingPlatformClientFactory() {
        return this.smartlingPlatformClientFactory;
    }

    @Override
    protected void putCustomWorkflowParams(WcmWorkflows.Parameters parameters, ResourceResolver resourceResolver, WorkItem workItem) {
        JobWorkflowParameters workflowParameters = new JobWorkflowParameters(workItem);
        String payload = (String)workItem.getWorkflowData().getPayload();
        Language sourceLanguage = this.languageCopyManager.getLanguage(resourceResolver, payload);
        parameters.setSourceLanguage(sourceLanguage.getCode());
        if (!workflowParameters.isDeep() || workflowParameters.getExcludedPathList().isEmpty()) {
            List<LanguageCopyManager.LanguageCopy> languageCopies = this.getLanguageCopiesForLocales(resourceResolver, payload, workflowParameters.getTargetLocaleCodes());
            parameters.setDeep(workflowParameters.isDeep());
            parameters.setLanguageCopies(languageCopies);
        } else {
            TreeSet<String> excludedPaths = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            excludedPaths.addAll(workflowParameters.getExcludedPathList());
            List<String> childrenPaths = this.languageCopyManager.getSubpagesPaths(resourceResolver, payload, excludedPaths);
            List<LanguageCopyManager.LanguageCopy> languageCopies = childrenPaths.stream().flatMap(childPath -> this.getLanguageCopiesForLocales(resourceResolver, (String)childPath, workflowParameters.getTargetLocaleCodes()).stream()).collect(Collectors.toList());
            parameters.setDeep(false);
            parameters.setLanguageCopies(languageCopies);
        }
    }

    private List<LanguageCopyManager.LanguageCopy> getLanguageCopiesForLocales(ResourceResolver resourceResolver, String path, Set<String> locales) {
        List<LanguageCopyManager.LanguageCopy> languageCopies = StreamSupport.stream(this.languageCopyManager.findLanguageCopies(resourceResolver, path).spliterator(), false).filter(arg_0 -> WorkflowUtil.byLocaleCode((Predicate<String>)Predicates.in(locales)).apply(arg_0)).collect(Collectors.toList());
        List nonExisted = languageCopies.stream().filter(languageCopy -> !languageCopy.exists()).map(LanguageCopyManager.LanguageCopy::getPath).collect(Collectors.toList());
        if (nonExisted.isEmpty()) {
            return languageCopies;
        }
        LOGGER.warn("These content=\"{}\" is not existed, so it will not be requested for translation.", (Object)String.join((CharSequence)";", nonExisted));
        return languageCopies.stream().filter(LanguageCopyManager.LanguageCopy::exists).collect(Collectors.toList());
    }

    protected void bindSmartlingPlatformClientFactory(SmartlingPlatformClientFactory smartlingPlatformClientFactory) {
        this.smartlingPlatformClientFactory = smartlingPlatformClientFactory;
    }

    protected void unbindSmartlingPlatformClientFactory(SmartlingPlatformClientFactory smartlingPlatformClientFactory) {
        if (this.smartlingPlatformClientFactory == smartlingPlatformClientFactory) {
            this.smartlingPlatformClientFactory = null;
        }
    }

    protected void bindLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        this.languageCopyManager = pageLanguageCopyManager;
    }

    protected void unbindLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        if (this.languageCopyManager == pageLanguageCopyManager) {
            this.languageCopyManager = null;
        }
    }

    protected void bindWcmWorkflows(WcmWorkflows wcmWorkflows) {
        this.wcmWorkflows = wcmWorkflows;
    }

    protected void unbindWcmWorkflows(WcmWorkflows wcmWorkflows) {
        if (this.wcmWorkflows == wcmWorkflows) {
            this.wcmWorkflows = null;
        }
    }
}

