/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.license.ProductInfoProvider;
import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.smartling.aem.connector.automation.impl.TranslationJob;
import com.smartling.aem.connector.automation.impl.TranslationObject;
import com.smartling.aem.connector.automation.impl.TranslationProject;
import com.smartling.aem.connector.automation.impl.TranslationProjectManager;
import com.smartling.aem.connector.automation.impl.WcmWorkflows;
import com.smartling.aem.connector.automation.impl.wcm.workflow.TranslationWorkflow;
import com.smartling.aem.connector.automation.impl.wcm.workflow.TranslationWorkflowManager;
import com.smartling.aem.connector.automation.impl.workflow.WorkflowUtil;
import com.smartling.aem.connector.automation.impl.workflow.context.ContextAwareWorkflowExternalProcess;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.PseudoContentDownloadManager;
import com.smartling.aem.connector.core.impl.integration.platform.Job;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClientFactory;
import com.smartling.aem.connector.core.impl.integration.sync.SyncTranslationInvoker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class WaitUntilProjectCommittedProcess
extends ContextAwareWorkflowExternalProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaitUntilProjectCommittedProcess.class);
    public static final String SMARTLING_PROJECTS_OWNERS = "smartling-projects-owners";
    @Reference
    private WcmWorkflows wcmWorkflows;
    @Reference
    private ProductInfoProvider productInfoProvider;
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private TranslationProjectManager translationProjectManager;
    @Reference
    private PseudoContentDownloadManager pseudoContentDownloadManager;
    @Reference
    private JobApiClientFactory clientFactory;
    @Reference
    private TranslationWorkflowManager translationWorkflowManager;
    @Reference
    private SyncTranslationInvoker syncTranslationInvoker;
    private ExecutorService threadPool;

    @Activate
    public void activate(Map<String, Object> properties) {
        this.threadPool = Executors.newCachedThreadPool();
    }

    @Deactivate
    public void deactivate() {
        try {
            this.threadPool.shutdown();
            this.threadPool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Failed to shutdown thread pool for pseudo translation delivery actions", (Throwable)e);
        }
    }

    @Override
    public Serializable executeInternal(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        return UUID.randomUUID();
    }

    @Override
    public boolean hasFinishedInternal(Serializable key, WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) {
        LOGGER.trace("Checking if the translation project content has been uploaded");
        if (WorkflowUtil.isWorkflowAborted(workItem)) {
            LOGGER.debug("Stop waiting for project to be committed: the workflow has been aborted");
            return true;
        }
        if (this.getMinutesAfterStartProcess(workItem) > (long)this.translationProjectManager.getPollingUploadComplete()) {
            LOGGER.warn("Polling period is exceeded.");
            return true;
        }
        String projectFolderPath = StringUtils.substringBeforeLast((String)WaitUntilProjectCommittedProcess.getProjectPath(workItem), (String)"/");
        if (this.areAemWorkflowsFailed(projectFolderPath)) {
            return true;
        }
        ResourceResolver resourceResolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
        Resource projectFolderPathResource = resourceResolver.getResource(projectFolderPath);
        if (projectFolderPathResource == null) {
            LOGGER.warn("Couldn't process a translation project because folder=\"{}\" haven't been created yet.", (Object)projectFolderPath);
            return false;
        }
        boolean result = true;
        boolean empty = true;
        for (Resource projectResource : projectFolderPathResource.getChildren()) {
            if (!"cq/gui/components/projects/admin/card/projectcard".equalsIgnoreCase((String)projectResource.getValueMap().get("sling:resourceType", (Object)""))) continue;
            empty = false;
            String projectPath = projectResource.getPath();
            result = this.addUserToGroupAndFinish(projectPath, resourceResolver, workItem, workflowSession) && result;
        }
        if (empty) {
            LOGGER.warn("No translation projects found in folder=\"{}\".", (Object)projectFolderPath);
            return false;
        }
        return result;
    }

    private boolean addUserToGroupAndFinish(String projectPath, ResourceResolver resourceResolver, WorkItem workItem, WorkflowSession workflowSession) {
        LOGGER.trace("Adding requester to Observers and Owners groups for project=\"{}\"", (Object)projectPath);
        if (StringUtils.isEmpty((CharSequence)projectPath)) {
            LOGGER.warn("No project path are found for jobUid=\"{}\", batchUid=\"{}\" and target locales=\"{}\"", new Object[]{WaitUntilProjectCommittedProcess.getJobUid(workItem), WaitUntilProjectCommittedProcess.getBatchUid(workItem), Arrays.toString(WaitUntilProjectCommittedProcess.getTargetLocales(workItem))});
            return false;
        }
        TranslationProject project = this.translationProjectManager.getProject(resourceResolver, projectPath);
        if (project == null) {
            LOGGER.warn("Could not find project path=\"{}\" for jobUid=\"{}\", batchUid=\"{}\" and target locales=\"{}\"", new Object[]{projectPath, WaitUntilProjectCommittedProcess.getJobUid(workItem), WaitUntilProjectCommittedProcess.getBatchUid(workItem), Arrays.toString(WaitUntilProjectCommittedProcess.getTargetLocales(workItem))});
            return false;
        }
        try {
            UserManager userManager = (UserManager)resourceResolver.adaptTo(UserManager.class);
            String loggedUserName = WaitUntilProjectCommittedProcess.getLoggedUserName(workItem);
            String roleObserverGroupName = project.getRoleObserver();
            String roleOwnerGroupName = project.getRoleOwner();
            if (StringUtils.isNotBlank((CharSequence)loggedUserName)) {
                if (userManager.getAuthorizable(loggedUserName) != null) {
                    boolean userIsObserver = this.isUserInGroup(userManager, roleObserverGroupName, loggedUserName);
                    boolean userIsOwner = this.isUserInGroup(userManager, roleOwnerGroupName, loggedUserName);
                    if (!userIsObserver && !userIsOwner) {
                        this.addLoggedUserToProjectRoleGroups(workItem, project);
                    } else {
                        LOGGER.trace("Don't need to add user=\"{}\" to groups \"{}\" and \"{}\" for project=\"{}\", userIsObserver=\"{}\", userIsOwner=\"{}\".", new Object[]{loggedUserName, roleObserverGroupName, roleOwnerGroupName, projectPath, userIsObserver, userIsOwner});
                    }
                } else {
                    LOGGER.warn("Couldn't find user=\"{}\". The user was not added to Owners and Observers for project=\"{}\"", (Object)loggedUserName, (Object)projectPath);
                }
            } else {
                LOGGER.warn("\"loggedUser\" workflow parameter is missed, project=\"{}\"", (Object)projectPath);
            }
        }
        catch (RepositoryException ex) {
            LOGGER.warn("Can't verify users in project role groups path=\"{}\", jobUid=\"{}\", batchUid=\"{}\"", new Object[]{project.getPath(), WaitUntilProjectCommittedProcess.getJobUid(workItem), WaitUntilProjectCommittedProcess.getBatchUid(workItem)});
        }
        return this.projectUploadComplete(project, workflowSession, workItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean areAemWorkflowsFailed(String projectPath) {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resolverFactory.getServiceResourceResolver(Collections.emptyMap());
            List<TranslationWorkflow> workflows = this.translationWorkflowManager.getAEMTranslationWorkflows(projectPath, resourceResolver);
            for (TranslationWorkflow workflow : workflows) {
                if (!StringUtils.isNotBlank((CharSequence)workflow.getFailureMessage())) continue;
                LOGGER.error("AEM workflowPath=\"{}\" has been failed with message=\"{}\" and stacktrace=\"{}\"", new Object[]{workflow.getPath(), workflow.getFailureMessage(), workflow.getFailureStack()});
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to check AEM Workflows for projectPath={}", (Object)projectPath, (Object)e);
        }
        finally {
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
        return false;
    }

    private boolean projectUploadComplete(TranslationProject project, WorkflowSession workflowSession, WorkItem workItem) {
        if (project.getTranslationJobs().isEmpty()) {
            LOGGER.warn("No translation jobs found in the project path=\"{}\", jobUid=\"{}\", batchUid=\"{}\" yet", new Object[]{project.getPath(), WaitUntilProjectCommittedProcess.getJobUid(workItem), WaitUntilProjectCommittedProcess.getBatchUid(workItem)});
            return false;
        }
        int targetLocalesCount = WaitUntilProjectCommittedProcess.getTargetLocales(workItem).length;
        if (project.getTranslationJobs().size() < targetLocalesCount) {
            LOGGER.debug("Translation jobsCount={} doesn't match to targetLocalesCount={}. Project path=\"{}\"", new Object[]{project.getTranslationJobs().size(), targetLocalesCount, project.getPath()});
            return false;
        }
        SmartlingCloudConfig cloudConfig = null;
        try {
            cloudConfig = this.getSmartlingCloudConfig(workItem, workflowSession);
            if (cloudConfig == null) {
                LOGGER.error("Cannot find cloud configuration for project path={}, cq:conf={}, projectUid={}, configSourceLocaleCode={}", new Object[]{project.getPath(), project.getCqConf(), project.getProjectUid(), project.getConfigSourceLocaleCode()});
            }
        }
        catch (WorkflowException ex) {
            LOGGER.error("Cannot find cloud configuration for payload path={}", workItem.getWorkflowData().getPayload());
        }
        ArrayList<CompletableFuture<Void>> completableFutureList = new ArrayList<CompletableFuture<Void>>();
        for (TranslationJob translationJob : project.getTranslationJobs()) {
            Collection<TranslationObject> translationObjects = translationJob.getTranslationObjects();
            if (translationObjects.isEmpty()) {
                LOGGER.debug("No translation objects found in a job of the project path=\"{}\", jobUid=\"{}\", batchUid=\"{}\"", new Object[]{project.getPath(), WaitUntilProjectCommittedProcess.getJobUid(workItem), WaitUntilProjectCommittedProcess.getBatchUid(workItem)});
                return false;
            }
            if (!this.doesAemStartsTranslationByItself() && translationJob.getStatus() == TranslationConstants.TranslationStatus.DRAFT && StringUtils.isEmpty((CharSequence)translationJob.getCurrentPollerAction())) {
                translationJob.setCurrentPollerAction("START_TRANSLATION");
                try {
                    this.wcmWorkflows.syncTranslationJob(workflowSession, translationJob.getResourcePath());
                }
                catch (WorkflowException e) {
                    return false;
                }
            }
            for (TranslationObject translationObject : translationObjects) {
                TranslationConstants.TranslationStatus objectStatus = translationObject.getStatus();
                if (objectStatus == TranslationConstants.TranslationStatus.SUBMITTED || objectStatus == TranslationConstants.TranslationStatus.COMMITTED_FOR_TRANSLATION || objectStatus == TranslationConstants.TranslationStatus.TRANSLATION_IN_PROGRESS || objectStatus == TranslationConstants.TranslationStatus.TRANSLATED || objectStatus == TranslationConstants.TranslationStatus.READY_FOR_REVIEW || objectStatus == TranslationConstants.TranslationStatus.APPROVED) continue;
                LOGGER.debug("Translation object path=\"{}\", jobUid=\"{}\", batchUid=\"{}\" is not committed for translation yet. Current status=\"{}\"", new Object[]{translationObject.getPath(), WaitUntilProjectCommittedProcess.getJobUid(workItem), WaitUntilProjectCommittedProcess.getBatchUid(workItem), translationObject.getStatus().name()});
                return false;
            }
            if (!project.isPseudo()) continue;
            completableFutureList.add(CompletableFuture.runAsync(() -> this.proceedTranslationJob(translationJob.getResourcePath()), this.threadPool));
        }
        if (cloudConfig != null && this.pseudoContentDownloadManager.shouldCancelJobAfterDownload() && !completableFutureList.isEmpty()) {
            try {
                SmartlingCloudConfig finalCloudConfig = cloudConfig;
                ((CompletableFuture)CompletableFuture.allOf(completableFutureList.toArray(new CompletableFuture[0])).thenRunAsync(() -> this.cancelJobIfRequired(finalCloudConfig, project.getJobUid()))).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("Couldn't cancel job jobUid={} asynchronously", (Object)project.getJobUid(), (Object)e);
            }
        }
        return true;
    }

    private void cancelJobIfRequired(SmartlingCloudConfig cloudConfig, String jobUid) {
        try (JobApiClient jobApiClient = this.clientFactory.createClient(cloudConfig);){
            Job jobInfo = jobApiClient.loadJob(jobUid);
            if (jobInfo.getSourceFiles().isEmpty()) {
                jobApiClient.cancelJob(jobUid, "Job is for pseudo translation only");
            }
        }
        catch (SmartlingException e) {
            LOGGER.error("Couldn't cancel job jobUid=\"{}\".", (Object)jobUid, (Object)e);
        }
        catch (Exception e) {
            LOGGER.error("General error on cancelling job by jobUid=\"{}\".", (Object)jobUid, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proceedTranslationJob(String translationJobPath) {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resolverFactory.getServiceResourceResolver(Collections.emptyMap());
            this.syncTranslationInvoker.syncTranslationJobByPath(resourceResolver, translationJobPath);
        }
        catch (LoginException e) {
            LOGGER.error("Failed to login into repository for processing of translation job path={}", (Object)translationJobPath, (Object)e);
        }
        finally {
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
    }

    private boolean doesAemStartsTranslationByItself() {
        Version version = this.productInfoProvider.getProductInfo().getVersion();
        return version.getMajor() != 6 || version.getMinor() != 4 || version.getMicro() >= 8;
    }

    @Override
    public void handleResultInternal(Serializable key, WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        if (WorkflowUtil.isWorkflowAborted(workItem)) {
            LOGGER.info("Workflow has been aborted");
        } else {
            ResourceResolver resourceResolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
            this.processUploadStatistics(workItem, resourceResolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLoggedUserToProjectRoleGroups(WorkItem workItem, TranslationProject project) {
        LOGGER.trace("Adding logged user and \"Smartling Project Owner\" group to \"Observers\" and \"Owners\" translation project=\"{}\"", (Object)project.getPath());
        Session session = null;
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resolverFactory.getServiceResourceResolver(Collections.emptyMap());
            session = (Session)resourceResolver.adaptTo(Session.class);
            UserManager userManager = (UserManager)resourceResolver.adaptTo(UserManager.class);
            this.addUserToGroup(userManager, project.getRoleObserver(), WaitUntilProjectCommittedProcess.getLoggedUserName(workItem));
            session.save();
            this.addUserToGroup(userManager, project.getRoleOwner(), WaitUntilProjectCommittedProcess.getLoggedUserName(workItem));
            session.save();
            this.addUserToGroup(userManager, project.getRoleObserver(), SMARTLING_PROJECTS_OWNERS);
            session.save();
            this.addUserToGroup(userManager, project.getRoleOwner(), SMARTLING_PROJECTS_OWNERS);
            session.save();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't add logged user to owners and observers groups, project=\"{}\", jobUid=\"{}\", batchUid=\"{}\"", new Object[]{project.getPath(), WaitUntilProjectCommittedProcess.getJobUid(workItem), WaitUntilProjectCommittedProcess.getBatchUid(workItem)});
        }
        finally {
            if (session != null && session.isLive()) {
                session.logout();
            }
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
    }

    private static String getProjectPath(WorkItem workItem) {
        return (String)workItem.getWorkflowData().getMetaDataMap().get("project", (Object)"");
    }

    private static String[] getTargetLocales(WorkItem workItem) {
        return (String[])workItem.getWorkflowData().getMetaDataMap().get("targetLocaleCodes", (Object)new String[0]);
    }

    private static String getJobUid(WorkItem workItem) {
        return (String)workItem.getWorkflowData().getMetaDataMap().get("jobUid", (Object)"");
    }

    private static String getBatchUid(WorkItem workItem) {
        return (String)workItem.getWorkflowData().getMetaDataMap().get("batchUid", (Object)"");
    }

    private static String getSourceLocaleCode(WorkItem workItem) {
        return (String)workItem.getWorkflowData().getMetaDataMap().get("configSourceLocaleCode", String.class);
    }

    private static String getLoggedUserName(WorkItem workItem) {
        return (String)workItem.getWorkflowData().getMetaDataMap().get("loggedUser", (Object)"");
    }

    private void addUserToGroup(UserManager userManager, String groupName, String userName) throws RepositoryException {
        LOGGER.trace("Adding user=\"{}\" to \"{}\" user group.", (Object)userName, (Object)groupName);
        Group group = (Group)userManager.getAuthorizable(groupName);
        group.addMember(userManager.getAuthorizable(userName));
    }

    private boolean isUserInGroup(UserManager userManager, String groupName, String userName) throws RepositoryException {
        LOGGER.trace("Checking user=\"{}\" is member of \"{}\" user group.", (Object)userName, (Object)groupName);
        Group group = (Group)userManager.getAuthorizable(groupName);
        return group.isMember(userManager.getAuthorizable(userName));
    }

    private long getMinutesAfterStartProcess(WorkItem workItem) {
        Long startTime = (Long)workItem.getWorkflowData().getMetaDataMap().get("startTime", Long.class);
        if (startTime == null) {
            startTime = this.restoreMinutesAfterStartProcess(workItem);
        }
        return (System.currentTimeMillis() - startTime) / 60000L;
    }

    private long restoreMinutesAfterStartProcess(WorkItem workItem) {
        LOGGER.warn("It seems WaitUntilProjectCommittedProcess was called before SendForTranslationExternalProcess for projectPaths=\"{}\"", (Object)WaitUntilProjectCommittedProcess.getProjectPath(workItem));
        long startTime = System.currentTimeMillis();
        workItem.getWorkflowData().getMetaDataMap().put((Object)"startTime", (Object)startTime);
        return startTime;
    }

    private void processUploadStatistics(WorkItem workItem, ResourceResolver resourceResolver) throws WorkflowException {
        TranslationProject project;
        ArrayList<TranslationObject> committedObjects = new ArrayList<TranslationObject>();
        ArrayList<TranslationObject> uncommittedObjects = new ArrayList<TranslationObject>();
        String projectPath = WaitUntilProjectCommittedProcess.getProjectPath(workItem);
        if (StringUtils.isNotEmpty((CharSequence)projectPath) && (project = this.translationProjectManager.getProject(resourceResolver, projectPath)) != null) {
            for (TranslationJob translationJob : project.getTranslationJobs()) {
                for (TranslationObject translationObject : translationJob.getTranslationObjects()) {
                    if (translationObject.getStatus() == TranslationConstants.TranslationStatus.COMMITTED_FOR_TRANSLATION) {
                        committedObjects.add(translationObject);
                        continue;
                    }
                    uncommittedObjects.add(translationObject);
                }
            }
        }
        workItem.getWorkflowData().getMetaDataMap().put((Object)"uploadedFileCount", (Object)committedObjects.size());
        if (!uncommittedObjects.isEmpty()) {
            LOGGER.info("Only {} of {} translation objects were created for jobUid=\"{}\", batchUid=\"{}\". Stop polling after 20 mins. Objects were not uploaded: {}", new Object[]{committedObjects.size(), committedObjects.size() + uncommittedObjects.size(), WaitUntilProjectCommittedProcess.getJobUid(workItem), WaitUntilProjectCommittedProcess.getBatchUid(workItem), uncommittedObjects.stream().map(o -> o.getSourcePath()).collect(Collectors.joining(", "))});
        } else if (!committedObjects.isEmpty()) {
            LOGGER.debug("All translated jobs are committed for translation.");
        } else {
            LOGGER.warn("Nothing was committed for translation.");
            this.setErrorMessage(workItem, "Nothing was committed for translation.");
        }
    }

    protected void bindWcmWorkflows(WcmWorkflows wcmWorkflows) {
        this.wcmWorkflows = wcmWorkflows;
    }

    protected void unbindWcmWorkflows(WcmWorkflows wcmWorkflows) {
        if (this.wcmWorkflows == wcmWorkflows) {
            this.wcmWorkflows = null;
        }
    }

    protected void bindProductInfoProvider(ProductInfoProvider productInfoProvider) {
        this.productInfoProvider = productInfoProvider;
    }

    protected void unbindProductInfoProvider(ProductInfoProvider productInfoProvider) {
        if (this.productInfoProvider == productInfoProvider) {
            this.productInfoProvider = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindTranslationProjectManager(TranslationProjectManager translationProjectManager) {
        this.translationProjectManager = translationProjectManager;
    }

    protected void unbindTranslationProjectManager(TranslationProjectManager translationProjectManager) {
        if (this.translationProjectManager == translationProjectManager) {
            this.translationProjectManager = null;
        }
    }

    protected void bindPseudoContentDownloadManager(PseudoContentDownloadManager pseudoContentDownloadManager) {
        this.pseudoContentDownloadManager = pseudoContentDownloadManager;
    }

    protected void unbindPseudoContentDownloadManager(PseudoContentDownloadManager pseudoContentDownloadManager) {
        if (this.pseudoContentDownloadManager == pseudoContentDownloadManager) {
            this.pseudoContentDownloadManager = null;
        }
    }

    protected void bindClientFactory(JobApiClientFactory jobApiClientFactory) {
        this.clientFactory = jobApiClientFactory;
    }

    protected void unbindClientFactory(JobApiClientFactory jobApiClientFactory) {
        if (this.clientFactory == jobApiClientFactory) {
            this.clientFactory = null;
        }
    }

    protected void bindTranslationWorkflowManager(TranslationWorkflowManager translationWorkflowManager) {
        this.translationWorkflowManager = translationWorkflowManager;
    }

    protected void unbindTranslationWorkflowManager(TranslationWorkflowManager translationWorkflowManager) {
        if (this.translationWorkflowManager == translationWorkflowManager) {
            this.translationWorkflowManager = null;
        }
    }

    protected void bindSyncTranslationInvoker(SyncTranslationInvoker syncTranslationInvoker) {
        this.syncTranslationInvoker = syncTranslationInvoker;
    }

    protected void unbindSyncTranslationInvoker(SyncTranslationInvoker syncTranslationInvoker) {
        if (this.syncTranslationInvoker == syncTranslationInvoker) {
            this.syncTranslationInvoker = null;
        }
    }
}

