/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import com.adobe.granite.ui.components.ds.ValueMapResource;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.PageLanguageCopyManager;
import com.smartling.aem.connector.automation.ui.LanguageDataSourceProvider;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

@Service
@Component
public class LanguageDataSourceProviderImpl
implements LanguageDataSourceProvider {
    public static final String ASSET_ROOT_FOLDER = "/content/dam";
    @Reference
    private PageLanguageCopyManager pageLanguageCopyManager;
    @Reference
    private AssetLanguageCopyManager assetLanguageCopyManager;

    @Override
    @Nonnull
    public Iterable<Resource> getTargetLanguageResources(@Nonnull ResourceResolver resourceResolver, @Nonnull Iterable<LanguageDataSourceProvider.TargetLanguage> targetLanguages) {
        FluentIterable resources = FluentIterable.from(targetLanguages).transform(LanguageDataSourceProviderImpl.toResource(resourceResolver));
        return resources;
    }

    @Override
    @Nonnull
    public Iterable<LanguageDataSourceProvider.TargetLanguage> getTargetLanguages(@Nonnull ResourceResolver resourceResolver, @Nonnull String sourcePath) {
        LanguageCopyManager languageCopyManager = StringUtils.startsWithIgnoreCase((CharSequence)sourcePath, (CharSequence)ASSET_ROOT_FOLDER) ? this.assetLanguageCopyManager : this.pageLanguageCopyManager;
        Iterable<LanguageCopyManager.LanguageCopy> languageCopies = languageCopyManager.findLanguageCopies(resourceResolver, sourcePath);
        return StreamSupport.stream(languageCopies.spliterator(), false).map(copy -> new LanguageDataSourceProvider.TargetLanguage(copy.getLanguage().getCode(), copy.getLanguage().getDisplayName())).collect(Collectors.toSet());
    }

    private static Function<LanguageDataSourceProvider.TargetLanguage, Resource> toResource(ResourceResolver resolver) {
        return targetLanguage -> {
            ValueMapDecorator vm = new ValueMapDecorator(new HashMap());
            vm.put((Object)"value", (Object)targetLanguage.getCode());
            vm.put((Object)"text", (Object)targetLanguage.getName());
            return new ValueMapResource(resolver, new ResourceMetadata(), "nt:unstructured", (ValueMap)vm);
        };
    }

    protected void bindPageLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        this.pageLanguageCopyManager = pageLanguageCopyManager;
    }

    protected void unbindPageLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        if (this.pageLanguageCopyManager == pageLanguageCopyManager) {
            this.pageLanguageCopyManager = null;
        }
    }

    protected void bindAssetLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        this.assetLanguageCopyManager = assetLanguageCopyManager;
    }

    protected void unbindAssetLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        if (this.assetLanguageCopyManager == assetLanguageCopyManager) {
            this.assetLanguageCopyManager = null;
        }
    }
}

