/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.smartling.aem.connector.automation.ui.LanguageDataSourceProvider;
import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;

@SlingServlet(resourceTypes={"smartling-connector/ui/data-sources/languages"})
public class LanguagesDataSourceServlet
extends SmartlingBaseServlet {
    @Reference
    private LanguageDataSourceProvider languageDataSourceProvider;
    @Reference
    private ServletUtils servletUtils;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String pagePath = this.servletUtils.getPayloadPath(request);
        Iterable<Object> resources = Collections.emptyList();
        String[] selectors = request.getRequestPathInfo().getSelectors();
        String query = request.getParameter("query");
        int offset = 0;
        int limit = 100;
        if (selectors.length > 1) {
            offset = Integer.parseInt(selectors[0]);
            limit = Integer.parseInt(selectors[1]);
        }
        if (StringUtils.isNotBlank((CharSequence)pagePath) && resourceResolver.getResource(pagePath) != null) {
            Iterable<LanguageDataSourceProvider.TargetLanguage> targetLanguages = this.languageDataSourceProvider.getTargetLanguages(resourceResolver, pagePath);
            resources = this.languageDataSourceProvider.getTargetLanguageResources(request.getResourceResolver(), targetLanguages);
        }
        resources = StreamSupport.stream(resources.spliterator(), false).filter(resource -> StringUtils.isBlank((CharSequence)query) || StringUtils.containsIgnoreCase((CharSequence)((CharSequence)resource.getValueMap().get("text", String.class)), (CharSequence)query) || StringUtils.containsIgnoreCase((CharSequence)((CharSequence)resource.getValueMap().get("value", String.class)), (CharSequence)query)).sorted(Comparator.comparing(resource -> (String)resource.getValueMap().get("text", String.class))).skip(offset).limit(limit).collect(Collectors.toList());
        request.setAttribute(DataSource.class.getName(), (Object)new SimpleDataSource(resources.iterator()));
    }

    protected void bindLanguageDataSourceProvider(LanguageDataSourceProvider languageDataSourceProvider) {
        this.languageDataSourceProvider = languageDataSourceProvider;
    }

    protected void unbindLanguageDataSourceProvider(LanguageDataSourceProvider languageDataSourceProvider) {
        if (this.languageDataSourceProvider == languageDataSourceProvider) {
            this.languageDataSourceProvider = null;
        }
    }

    @Override
    protected void bindServletUtils(ServletUtils servletUtils) {
        this.servletUtils = servletUtils;
    }

    @Override
    protected void unbindServletUtils(ServletUtils servletUtils) {
        if (this.servletUtils == servletUtils) {
            this.servletUtils = null;
        }
    }
}

