/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;

@Service(value={SmartlingDialogConfiguration.class})
@Component(label="Smartling - Dialog configuration (Touch)", description="Set of configuration options of Smartling Request Translation dialog.", metatype=true)
public class SmartlingDialogConfiguration {
    public static final boolean RESPECT_CONTENT_OBSERVING_LANGUAGE_ROOTS_DEFAULT = true;
    @Property(label="Include language root pages", description="Forces AEM to search for language roots (cq:isLanguageRoot) with defined Language (jcr:language) of a page", boolValue={true})
    public static final String RESPECT_CONTENT_OBSERVING_LANGUAGE_ROOTS = "respect.content.observing.language.roots";
    public static final boolean LANGUAGE_ROOT_SIBLINGS_ONLY_DEFAULT = false;
    @Property(label="Only sibling language roots", description="This causes the Smartling dialog to not displaying language roots from other levels.", boolValue={false})
    public static final String LANGUAGE_ROOT_SIBLINGS_ONLY = "only.sibling.language.roots";
    private static final boolean ENABLE_LEGACY_CONFIG_VALIDATION_DEFAULT_VALUE = true;
    @Property(label="Enable Legacy Config Validation", description="Enables / Disables validation of legacy AEM Cloud service configuration.", boolValue={true})
    public static final String ENABLE_LEGACY_CONFIG_VALIDATION_PROP = "translation.project.enable.legacy.config.validation";
    private static final boolean ENABLE_TARGET_CONTENT_EXISTENCE_VALIDATION_DEFAULT_VALUE = false;
    @Property(label="Enable Target Content Existence Validation", description="Don't allow translation request if the page doesn't exist in selected language(s).", boolValue={false})
    public static final String ENABLE_TARGET_CONTENT_EXISTENCE_VALIDATION_PROP = "target.content.existence.validation";
    private static final boolean PSEUDO_TRANSLATION_OPTION_DEFAULT_VALUE = false;
    @Property(label="Pseudo Translation Default", description="Provide Smartling Dialog with default value for Pseudo-Translation option.", boolValue={false})
    public static final String PSEUDO_TRANSLATION_OPTION_DEFAULT_PROP = "translation.pseudo.default";
    private static final boolean CHECK_DAM_FOLDER_DESCENDANTS_OPTION_DEFAULT_VALUE = false;
    @Property(label="Check DAM folder descendants", description="Causes Smartling Dialog to check descendants of selected DAM folder instead of checking just children.", boolValue={false})
    public static final String CHECK_DAM_FOLDER_DESCENDANTS_OPTION_PROP = "check.dam.folder.descendants";
    private boolean respectContent = true;
    private boolean languageRootSiblingsOnly = false;
    private boolean legacyConfigValidationEnable = true;
    private boolean targetContentExistenceValidationEnable = false;
    private boolean pseudoTranslationDefault = false;
    private boolean checkDamFolderDescendants = false;

    @Activate
    public void activate(Map<String, Object> properties) {
        this.respectContent = PropertiesUtil.toBoolean((Object)properties.get(RESPECT_CONTENT_OBSERVING_LANGUAGE_ROOTS), (boolean)true);
        this.languageRootSiblingsOnly = PropertiesUtil.toBoolean((Object)properties.get(LANGUAGE_ROOT_SIBLINGS_ONLY), (boolean)false);
        this.legacyConfigValidationEnable = PropertiesUtil.toBoolean((Object)properties.get(ENABLE_LEGACY_CONFIG_VALIDATION_PROP), (boolean)true);
        this.targetContentExistenceValidationEnable = PropertiesUtil.toBoolean((Object)properties.get(ENABLE_TARGET_CONTENT_EXISTENCE_VALIDATION_PROP), (boolean)false);
        this.pseudoTranslationDefault = PropertiesUtil.toBoolean((Object)properties.get(PSEUDO_TRANSLATION_OPTION_DEFAULT_PROP), (boolean)false);
        this.checkDamFolderDescendants = PropertiesUtil.toBoolean((Object)properties.get(CHECK_DAM_FOLDER_DESCENDANTS_OPTION_PROP), (boolean)false);
    }

    public boolean areLanguageRootSiblingsOnly() {
        return this.languageRootSiblingsOnly;
    }

    public boolean respectContent() {
        return this.respectContent;
    }

    public boolean isLegacyConfigValidationEnabled() {
        return this.legacyConfigValidationEnable;
    }

    public boolean isTargetContentExistenceValidationEnabled() {
        return this.targetContentExistenceValidationEnable;
    }

    public boolean isPseudoTranslationEnabledByDefault() {
        return this.pseudoTranslationDefault;
    }

    public boolean isCheckDamFolderDescendantsOption() {
        return this.checkDamFolderDescendants;
    }
}

