/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.google.common.collect.Sets;
import com.smartling.aem.connector.automation.CloudConfigResolver;
import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.automation.ui.SmartlingValidationException;
import com.smartling.aem.connector.automation.ui.validator.config.CloudConfigChildPageValidator;
import com.smartling.aem.connector.automation.ui.validator.features.CloudConfigFeatureValidator;
import com.smartling.aem.connector.automation.ui.validator.locale.TargetLocalesValidator;
import com.smartling.aem.connector.automation.ui.validator.name.UniqueJobNameValidator;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;

@Service(value={SmartlingJobWorkflowServletValidator.class})
@Component
public class SmartlingJobWorkflowServletValidator {
    @Reference
    private CloudConfigFeatureValidator cloudConfigFeatureValidator;
    @Reference
    private UniqueJobNameValidator uniqueJobNameValidator;
    @Reference
    private TargetLocalesValidator targetLocalesValidator;
    @Reference
    private CloudConfigChildPageValidator cloudConfigChildPageValidator;
    @Reference
    private ServletUtils servletUtils;
    @Reference
    private CloudConfigResolver cloudConfigResolver;

    public void validateConfig(SlingHttpServletRequest request, ResourceResolver resourceResolver) throws SmartlingException {
        try {
            String path = this.servletUtils.getPayloadPath(request);
            String projectUid = request.getParameter("projectUid");
            path = StringUtils.substringBefore((String)path, (String)";");
            SmartlingCloudConfig cloudConfig = this.servletUtils.getCloudConfigByPagePath(resourceResolver, path, SmartlingCloudConfig.class);
            if (cloudConfig == null) {
                throw new SmartlingValidationException("There is no Smartling config associated with the resource");
            }
            cloudConfig = this.cloudConfigResolver.getConfigByPath(cloudConfig, resourceResolver, path, projectUid);
            MachineTranslationCloudConfig machineTranslationCloudConfig = this.servletUtils.getCloudConfigByPagePath(resourceResolver, path, MachineTranslationCloudConfig.class);
            if (machineTranslationCloudConfig == null) {
                throw new SmartlingValidationException("There is no translation integration config associated with the resource");
            }
            this.cloudConfigFeatureValidator.validate(machineTranslationCloudConfig);
            String jobName = (String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter("jobName"), null);
            String jobUid = (String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter("jobUid"), null);
            this.uniqueJobNameValidator.validate(jobName, cloudConfig, jobUid);
            Object[] targetLocaleCodes = request.getParameterValues("targetLocaleCodes");
            Set<String> targetLocaleCodesSet = Sets.newHashSet((Object[])targetLocaleCodes).stream().filter(el -> !StringUtils.isEmpty((CharSequence)el)).collect(Collectors.toSet());
            this.targetLocalesValidator.validate(cloudConfig, targetLocaleCodesSet);
        }
        catch (SmartlingException e) {
            throw new SmartlingValidationException("Config validation failed", e);
        }
    }

    public void validateChildResourceConfig(String path, ResourceResolver resourceResolver) throws SmartlingValidationException {
        try {
            this.cloudConfigChildPageValidator.validate(resourceResolver, path);
        }
        catch (SmartlingException e) {
            throw new SmartlingValidationException("Child resource config validation failed", e);
        }
    }

    protected void bindCloudConfigFeatureValidator(CloudConfigFeatureValidator cloudConfigFeatureValidator) {
        this.cloudConfigFeatureValidator = cloudConfigFeatureValidator;
    }

    protected void unbindCloudConfigFeatureValidator(CloudConfigFeatureValidator cloudConfigFeatureValidator) {
        if (this.cloudConfigFeatureValidator == cloudConfigFeatureValidator) {
            this.cloudConfigFeatureValidator = null;
        }
    }

    protected void bindUniqueJobNameValidator(UniqueJobNameValidator uniqueJobNameValidator) {
        this.uniqueJobNameValidator = uniqueJobNameValidator;
    }

    protected void unbindUniqueJobNameValidator(UniqueJobNameValidator uniqueJobNameValidator) {
        if (this.uniqueJobNameValidator == uniqueJobNameValidator) {
            this.uniqueJobNameValidator = null;
        }
    }

    protected void bindTargetLocalesValidator(TargetLocalesValidator targetLocalesValidator) {
        this.targetLocalesValidator = targetLocalesValidator;
    }

    protected void unbindTargetLocalesValidator(TargetLocalesValidator targetLocalesValidator) {
        if (this.targetLocalesValidator == targetLocalesValidator) {
            this.targetLocalesValidator = null;
        }
    }

    protected void bindCloudConfigChildPageValidator(CloudConfigChildPageValidator cloudConfigChildPageValidator) {
        this.cloudConfigChildPageValidator = cloudConfigChildPageValidator;
    }

    protected void unbindCloudConfigChildPageValidator(CloudConfigChildPageValidator cloudConfigChildPageValidator) {
        if (this.cloudConfigChildPageValidator == cloudConfigChildPageValidator) {
            this.cloudConfigChildPageValidator = null;
        }
    }

    protected void bindServletUtils(ServletUtils servletUtils) {
        this.servletUtils = servletUtils;
    }

    protected void unbindServletUtils(ServletUtils servletUtils) {
        if (this.servletUtils == servletUtils) {
            this.servletUtils = null;
        }
    }

    protected void bindCloudConfigResolver(CloudConfigResolver cloudConfigResolver) {
        this.cloudConfigResolver = cloudConfigResolver;
    }

    protected void unbindCloudConfigResolver(CloudConfigResolver cloudConfigResolver) {
        if (this.cloudConfigResolver == cloudConfigResolver) {
            this.cloudConfigResolver = null;
        }
    }
}

