/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.config;

import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.automation.ui.validator.config.CloudConfigChildPageValidator;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import java.util.LinkedList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class CloudConfigChildPageValidatorImpl
implements CloudConfigChildPageValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudConfigChildPageValidatorImpl.class);
    private static final String QUERY_STRING_TEMPLATE = "SELECT * FROM [cq:PageContent] as s WHERE ISDESCENDANTNODE(s,'%s') AND [cq:conf] IS NOT NULL";
    @Reference
    private SlingRepository repository;
    @Reference
    protected ServletUtils servletUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(ResourceResolver resourceResolver, String path) throws SmartlingException {
        try {
            Session session = this.repository.loginService(null, null);
            try {
                String queryString = String.format(QUERY_STRING_TEMPLATE, path);
                Query query = session.getWorkspace().getQueryManager().createQuery(queryString, "JCR-SQL2");
                LinkedList<String> subpagesWithCustomConfig = new LinkedList<String>();
                SmartlingCloudConfig baseCloudConfig = this.servletUtils.getCloudConfigByPagePath(resourceResolver, path, SmartlingCloudConfig.class);
                NodeIterator nodes = query.execute().getNodes();
                while (nodes.hasNext()) {
                    Node node = nodes.nextNode();
                    String childPagePath = StringUtils.removeEnd((String)node.getPath(), (String)"/jcr:content");
                    SmartlingCloudConfig customConfig = this.servletUtils.getCloudConfigByPagePath(resourceResolver, childPagePath, SmartlingCloudConfig.class);
                    if (customConfig == null || StringUtils.equals((CharSequence)baseCloudConfig.getPath(), (CharSequence)customConfig.getPath())) continue;
                    subpagesWithCustomConfig.add(childPagePath);
                }
                if (subpagesWithCustomConfig.size() > 0) {
                    String subpages = String.join((CharSequence)";", subpagesWithCustomConfig);
                    LOGGER.warn(String.format("Sub pages of page %s with overridden Cloud Config: %s", path, subpages));
                    throw new SmartlingException(String.format("Sub-pages \"%s\" in this submission are part of a different cloud configuration than current page. Please review the sub-pages of \"%s\" to make sure they are not part of another cloud configuration as the current page you submitting are from.", subpages, path));
                }
            }
            finally {
                session.logout();
            }
        }
        catch (RepositoryException e) {
            throw new SmartlingException("Failed to resolve page path", e);
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindServletUtils(ServletUtils servletUtils) {
        this.servletUtils = servletUtils;
    }

    protected void unbindServletUtils(ServletUtils servletUtils) {
        if (this.servletUtils == servletUtils) {
            this.servletUtils = null;
        }
    }
}

