/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl;

import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;

@Service(value={PseudoContentDownloadManager.class})
@Component(label="Smartling - Pseudo content download manager (Touch)", description="Allows to download pseudo translation for particular locales instantly", metatype=true)
public class PseudoContentDownloadManager {
    public static final boolean REMOVE_FILE_AFTER_DELIVERY_DEFAULT = true;
    @Property(label="Remove a file after delivery", description="Causes connector to remove a file after pseudo translation was already downloaded for them", boolValue={true})
    public static final String REMOVE_FILE_AFTER_DELIVERY = "pseudo.download.remove.file";
    public static final boolean CANCEL_EMPTY_JOB_AFTER_DELIVERY_DEFAULT = true;
    @Property(label="Cancel job files after delivery", description="Causes connector to cancel an empty job (without source files) after pseudo translation was downloaded", boolValue={true})
    public static final String CANCEL_JOB_AFTER_DELIVERY = "pseudo.download.cancel.job";
    private boolean removeFile;
    private boolean cancelJob;

    @Activate
    public void activate(Map<String, Object> properties) {
        this.removeFile = PropertiesUtil.toBoolean((Object)properties.get(REMOVE_FILE_AFTER_DELIVERY), (boolean)true);
        this.cancelJob = PropertiesUtil.toBoolean((Object)properties.get(CANCEL_JOB_AFTER_DELIVERY), (boolean)true);
    }

    public boolean shouldRemoveFileAfterDownload() {
        return this.removeFile;
    }

    public boolean shouldCancelJobAfterDownload() {
        return this.cancelJob;
    }
}

