/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.integration.platform.ProjectApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.ProjectApiClientFactory;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSmartlingCloudConfig
implements SmartlingCloudConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSmartlingCloudConfig.class);
    private static final String GLOBAL_MAPPING_PATH = "/apps/granite/translation/connector/config/smartling/languageMapping";
    private static final String RENAMED_GLOBAL_MAPPING_PATH = "/apps/granite/translation/connector/configuration/smartling/languageMapping";
    public static final String MOVED_GLOBAL_MAPPING_PATH = "/conf/global/settings/smartling/configuration/languageMapping";
    private final ProjectApiClientFactory projectApiClientFactory;
    protected final ImmutableMap<String, String> languageMapping;
    protected final ImmutableSetMultimap<String, String> inverseLanguageMapping;

    BaseSmartlingCloudConfig(ProjectApiClientFactory projectApiClientFactory, ResourceResolver resourceResolver) {
        this.projectApiClientFactory = projectApiClientFactory;
        Resource mappingRoot = resourceResolver.getResource(MOVED_GLOBAL_MAPPING_PATH);
        if (mappingRoot == null) {
            LOGGER.trace("Couldn't load \"{}\" for locale mappings. Trying to load from \"{}\"", (Object)MOVED_GLOBAL_MAPPING_PATH, (Object)GLOBAL_MAPPING_PATH);
            mappingRoot = resourceResolver.getResource(GLOBAL_MAPPING_PATH);
        }
        if (mappingRoot == null) {
            LOGGER.trace("Couldn't load \"{}\" for locale mappings. Trying to load from \"{}\"", (Object)GLOBAL_MAPPING_PATH, (Object)RENAMED_GLOBAL_MAPPING_PATH);
            mappingRoot = resourceResolver.getResource(RENAMED_GLOBAL_MAPPING_PATH);
        }
        this.languageMapping = BaseSmartlingCloudConfig.loadLanguageMapping(mappingRoot);
        this.inverseLanguageMapping = BaseSmartlingCloudConfig.reverse(this.languageMapping);
    }

    @Override
    public Map<String, String> getLanguageMapping() {
        return this.languageMapping;
    }

    @Override
    public Set<String> mapSmartlingCodeToLocale(String smartlingLocaleCode) {
        return this.inverseLanguageMapping.get((Object)smartlingLocaleCode);
    }

    @Override
    public boolean isDirectionSupported(String sourceLanguage, String targetLanguage) throws SmartlingException {
        return this.isDirectionSupported(this, sourceLanguage, targetLanguage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isDirectionSupported(SmartlingCloudConfig config, String sourceLanguage, String targetLanguage) {
        String sourceSmartlingLocaleCode = this.getLanguageMapping().get(sourceLanguage);
        if (sourceSmartlingLocaleCode == null) {
            LOGGER.warn("Can not resolve Smartling source locale from language mapping. No mapping for {} is present", (Object)sourceLanguage);
            return false;
        }
        String targetSmartlingLocaleCode = this.getLanguageMapping().get(targetLanguage);
        if (targetSmartlingLocaleCode == null) {
            LOGGER.warn("Can not resolve Smartling target locale from language mapping. No mapping for {} is present", (Object)targetLanguage);
            return false;
        }
        try (ProjectApiClient projectApiClient = this.projectApiClientFactory.createClient(config);){
            boolean languageSupported = projectApiClient.isLanguageSupported(targetSmartlingLocaleCode);
            if (!languageSupported) {
                LOGGER.warn("Target locale {} is not supported for project {}", (Object)targetSmartlingLocaleCode, (Object)config.getProjectId());
            }
            boolean bl = languageSupported;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("General error on check if \"{}\" locale is supported by Smartling project", (Object)targetSmartlingLocaleCode, (Object)e);
            return false;
        }
    }

    private static ImmutableMap<String, String> loadLanguageMapping(Resource mappingRoot) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER);
        if (mappingRoot != null) {
            for (Resource entry : mappingRoot.getChildren()) {
                builder = builder.put((Object)entry.getName(), entry.getValueMap().get("languageMapping", (Object)""));
            }
        } else {
            LOGGER.error("Couldn't load locale mappings");
        }
        return builder.build();
    }

    private static ImmutableSetMultimap<String, String> reverse(Map<String, String> mapping) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            builder.put((Object)entry.getValue(), (Object)entry.getKey());
        }
        return builder.build();
    }
}

