/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.config;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;

@Service(value={CallbackUriProviderConfig.class})
@Component(label="Smartling - Callback URL (Touch)", immediate=true, metatype=true, description="A callback URL can be sent to Smartling on file upload. When a file is complete, Smartling will notify the URL. Smartling's Touch Connector do handle callback URL for sync translation from Smartling to AEM.")
public class CallbackUriProviderConfig {
    @Property(label="Callback URL", description="If empty, the callback will be not set for the file. Callback URL must be a valid URL (e.g. https://domain.com/services/smartling/sync-translation) which can be reached from the Internet. If the URL is malformed then file upload will fail.")
    private static final String CALLBACK_URL = "callback.url";
    private String callbackUrl;
    private static final String CALLBACK_HOST_URL = "callback.host.url";
    @Property(label="Callback shared secret", passwordValue={""}, description="If empty, the connector doesn't validate the authenticity of the callback request.")
    private static final String CALLBACK_SHARED_SECRET = "callback.shared.secret";
    private String callbackSharedSecret;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.callbackUrl = (String)StringUtils.defaultIfEmpty((CharSequence)PropertiesUtil.toString((Object)properties.get(CALLBACK_URL), null), null);
        String callbackHostUrl = (String)StringUtils.defaultIfEmpty((CharSequence)PropertiesUtil.toString((Object)properties.get(CALLBACK_HOST_URL), null), null);
        this.callbackSharedSecret = (String)StringUtils.defaultIfEmpty((CharSequence)PropertiesUtil.toString((Object)properties.get(CALLBACK_SHARED_SECRET), null), null);
        if (StringUtils.isNotBlank((CharSequence)this.callbackUrl)) {
            this.callbackUrl = StringUtils.trim((String)this.callbackUrl);
        } else if (StringUtils.isNotBlank((CharSequence)callbackHostUrl)) {
            callbackHostUrl = StringUtils.trim((String)callbackHostUrl);
            callbackHostUrl = StringUtils.removeEnd((String)callbackHostUrl, (String)"/");
            this.callbackUrl = callbackHostUrl + "/services/smartling/sync-translation";
        }
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public String getCallbackSharedSecret() {
        return this.callbackSharedSecret;
    }
}

