/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform;

import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.SmartlingFacade;
import com.smartling.aem.connector.core.impl.integration.BatchIsNotSuitableException;
import com.smartling.aem.connector.core.impl.integration.NoTranslatableContentException;
import com.smartling.aem.connector.core.impl.integration.SmartlingPlatformClient;
import com.smartling.aem.connector.core.impl.integration.platform.FileApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.FileUploadConfigurer;
import com.smartling.aem.connector.core.impl.integration.platform.processor.ProcessorService;
import com.smartling.api.files.v2.pto.FileLocaleStatusResponse;
import com.smartling.api.files.v2.pto.RetrievalType;
import com.smartling.api.jobbatches.exceptions.NoSourceStringsFoundException;
import com.smartling.api.jobbatches.v1.JobBatchesApi;
import com.smartling.api.jobbatches.v1.pto.BatchActionRequestPTO;
import com.smartling.api.jobbatches.v1.pto.CreateBatchRequestPTO;
import com.smartling.api.jobbatches.v1.pto.CreateBatchResponsePTO;
import com.smartling.api.jobbatches.v1.pto.FileUploadPTO;
import com.smartling.api.v2.client.exception.RestApiRuntimeException;
import com.smartling.api.v2.client.exception.client.ValidationErrorException;
import com.smartling.api.v2.response.Error;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ApiV2SmartlingPlatformClient
implements SmartlingPlatformClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiV2SmartlingPlatformClient.class);
    private static final String HTML_SUBCONTENT_CHECK_EXPRESSION = "(/translationObjectFile/translationObjectProperties/property-html/text())[1]";
    private static final String TEXT_SUBCONTENT_CHECK_EXPRESSION = "(/translationObjectFile/translationObjectProperties/property-text/text())[1]";
    private static final String HTML_SUBNODE_CHECK_EXPRESSION = "(/translationObjectFile/translationObjectProperties/property-html/*)[1]";
    private static final String TEXT_SUBNODE_CHECK_EXPRESSION = "(/translationObjectFile/translationObjectProperties/property-text/*)[1]";
    private static final String[] CHECK_EXPRESSIONS = new String[]{"(/translationObjectFile/translationObjectProperties/property-html/text())[1]", "(/translationObjectFile/translationObjectProperties/property-text/text())[1]", "(/translationObjectFile/translationObjectProperties/property-html/*)[1]", "(/translationObjectFile/translationObjectProperties/property-text/*)[1]"};
    private static final String FAILED_TO_UPLOAD_ERROR_MESSAGE = "Failed to upload file fileUri=\"%s\", locale=\"%s\", batchUid=%s";
    private final FileApiClient fileApiClient;
    private final FileUploadConfigurer fileUploadConfigurer;
    private final ProcessorService processorService;
    private final JobBatchesApi jobBatchesApi;

    ApiV2SmartlingPlatformClient(FileApiClient fileApiClient, JobBatchesApi jobBatchesApi, FileUploadConfigurer fileUploadConfigurer, ProcessorService processorService) {
        this.fileApiClient = Objects.requireNonNull(fileApiClient);
        this.fileUploadConfigurer = Objects.requireNonNull(fileUploadConfigurer);
        this.processorService = Objects.requireNonNull(processorService);
        this.jobBatchesApi = Objects.requireNonNull(jobBatchesApi);
    }

    @Override
    public void sendForTranslation(SmartlingFacade.Resource resource, String sourceLanguage, String fileUri, String targetLanguage, String projectId, String batchUid, boolean moveStrings) throws SmartlingException {
        LOGGER.info("File is being uploaded fileUri=\"{}\", locale=\"{}\", batchUid=\"{}\"", new Object[]{fileUri, targetLanguage, batchUid});
        FileUploadPTO fileUploadPTO = this.fileUploadConfigurer.buildUploadParameters(fileUri, resource, sourceLanguage, targetLanguage, moveStrings);
        try {
            if (resource.getType() == SmartlingFacade.Type.XML) {
                this.validateXmlFile(fileUploadPTO.getFile(), fileUri, targetLanguage, batchUid);
            }
            this.jobBatchesApi.addFile(projectId, batchUid, fileUploadPTO);
        }
        catch (NoSourceStringsFoundException e) {
            throw new NoTranslatableContentException(String.format(FAILED_TO_UPLOAD_ERROR_MESSAGE, fileUri, targetLanguage, batchUid), e);
        }
        catch (ValidationErrorException e) {
            if (CollectionUtils.isNotEmpty((Collection)e.getErrors()) && StringUtils.equalsIgnoreCase((CharSequence)((Error)e.getErrors().get(0)).getKey(), (CharSequence)"batch.not.suitable")) {
                throw new BatchIsNotSuitableException(String.format(FAILED_TO_UPLOAD_ERROR_MESSAGE, fileUri, targetLanguage, batchUid), e);
            }
            throw new SmartlingException(String.format(FAILED_TO_UPLOAD_ERROR_MESSAGE, fileUri, targetLanguage, batchUid), e);
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException(String.format(FAILED_TO_UPLOAD_ERROR_MESSAGE, fileUri, targetLanguage, batchUid), e);
        }
        LOGGER.debug("Added to job file with fileUri=\"{}\", locale=\"{}\", batchUid={}", new Object[]{fileUploadPTO.getFileUri(), targetLanguage, batchUid});
    }

    private void validateXmlFile(byte[] xmlFileBytes, String fileUri, String targetLanguage, String batchUid) throws NoTranslatableContentException {
        try {
            if (!this.isFileContainsAtLeastOneNoNEmptyProperty(xmlFileBytes)) {
                throw new NoTranslatableContentException(String.format("File was rejected for uploading due to storing only empty properties fileUri=\"%s\", locale=\"%s\", batchUid=%s", fileUri, targetLanguage, batchUid));
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new NoTranslatableContentException(String.format("Failed to parse file fileUri=\"%s\", locale=\"%s\", batchUid=%s, errorMessage=\"%s\"", fileUri, targetLanguage, batchUid, e.getMessage()), e);
        }
    }

    private boolean isFileContainsAtLeastOneNoNEmptyProperty(byte[] xmlFileBytes) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlFileBytes);
        Document doc = builder.parse(inputStream);
        XPathFactory xpathfactory = XPathFactory.newInstance();
        XPath xpath = xpathfactory.newXPath();
        for (String exprStr : CHECK_EXPRESSIONS) {
            XPathExpression expr = xpath.compile(exprStr);
            Object result = expr.evaluate(doc, XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            int nodesLength = nodes.getLength();
            for (int i = 0; i < nodesLength; ++i) {
                if (!StringUtils.isNotBlank((CharSequence)nodes.item(i).getTextContent())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public SmartlingFacade.Status getStatus(String projectUid, String fileUri, String languageCode) throws SmartlingException {
        FileLocaleStatusResponse fileStatus = this.fileApiClient.getFileStatus(projectUid, fileUri, languageCode);
        int pendingAuthorizationCount = fileStatus.getTotalStringCount() - fileStatus.getExcludedStringCount() - fileStatus.getAuthorizedStringCount() - fileStatus.getCompletedStringCount();
        if (pendingAuthorizationCount > 0) {
            return SmartlingFacade.Status.NA;
        }
        if (fileStatus.getAuthorizedStringCount() > 0) {
            return SmartlingFacade.Status.IN_PROGRESS;
        }
        return SmartlingFacade.Status.COMPLETED;
    }

    @Override
    public SmartlingFacade.Status getJobStatus(String jobId, String languageCode) throws SmartlingException {
        throw new SmartlingException("Can not be effectively implemented at the moment");
    }

    @Override
    public InputStream getTranslated(String projectUid, String fileUri, String languageCode, RetrievalType retrievalType) throws SmartlingException {
        LOGGER.info("Loading translations of fileUri=\"{}\" for locale=\"{}\"", (Object)fileUri, (Object)languageCode);
        InputStream file = this.fileApiClient.getFile(projectUid, fileUri, languageCode, retrievalType);
        try {
            return new ByteArrayInputStream(this.processorService.process(IOUtils.toByteArray((InputStream)file)));
        }
        catch (IOException e) {
            throw new SmartlingException(String.format("Couldn't retrieve translations of fileUri=\"%s\"", fileUri));
        }
    }

    @Override
    public void delete(String projectUid, String fileUri) throws SmartlingException {
        LOGGER.info("Deleting fileUri=\"{}\"", (Object)fileUri);
        this.fileApiClient.deleteFile(projectUid, fileUri);
    }

    @Override
    public String createBatch(String projectId, String jobUid, boolean authorize) {
        CreateBatchRequestPTO createBatchRequestPTO = new CreateBatchRequestPTO(jobUid, Boolean.valueOf(authorize));
        CreateBatchResponsePTO batch = this.jobBatchesApi.createBatch(projectId, createBatchRequestPTO);
        return batch.getBatchUid();
    }

    @Override
    public void executeBatch(String projectId, String batchUid) {
        this.jobBatchesApi.executeBatch(projectId, batchUid, new BatchActionRequestPTO());
    }

    @Override
    public void close() throws Exception {
        try {
            this.jobBatchesApi.close();
        }
        catch (Exception e) {
            LOGGER.error("Couldn't release Job Batches API client resources", (Throwable)e);
        }
        try {
            this.fileApiClient.close();
        }
        catch (Exception e) {
            LOGGER.error("Couldn't release File API client resources", (Throwable)e);
        }
    }
}

