/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform.projects;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.integration.platform.ProjectApiClient;
import com.smartling.api.projects.v2.ProjectsApi;
import com.smartling.api.projects.v2.pto.LocaleDetailsPTO;
import com.smartling.api.projects.v2.pto.ProjectDetailsPTO;
import com.smartling.api.v2.client.exception.RestApiRuntimeException;
import com.smartling.api.v2.response.Error;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class ProjectApiV2Client
implements ProjectApiClient {
    private final ProjectsApi projectsApi;
    private final String projectId;

    ProjectApiV2Client(ProjectsApi projectsApi, String projectId) {
        this.projectsApi = Objects.requireNonNull(projectsApi);
        this.projectId = Objects.requireNonNull(projectId);
    }

    @Override
    public Collection<LocaleDetailsPTO> getProjectLocales() throws SmartlingException {
        try {
            return this.projectsApi.getDetails(this.projectId, false).getTargetLocales();
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException(String.format("Failed to load supported locales for project %s: %s", this.projectId, Joiner.on((String)", ").join(this.mapErrorsToStrings(e.getErrors()))), e);
        }
    }

    @Override
    public ProjectDetailsPTO getProjectDetails() throws SmartlingException {
        try {
            return this.projectsApi.getDetails(this.projectId, false);
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException(String.format("Failed to load project info for %s: %s", this.projectId, Joiner.on((String)", ").join(this.mapErrorsToStrings(e.getErrors()))), e);
        }
    }

    @Override
    public boolean isLanguageSupported(String languageCode) throws SmartlingException {
        return Iterables.tryFind(this.getProjectLocales(), input -> input.getLocaleId().equalsIgnoreCase(languageCode)).isPresent();
    }

    @Override
    public void close() throws Exception {
        this.projectsApi.close();
    }

    private List<String> mapErrorsToStrings(List<Error> errors) {
        return errors.stream().map(input -> input.getKey() + ":" + input.getMessage()).collect(Collectors.toList());
    }
}

