/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.sync;

import com.adobe.granite.translation.api.TranslationConstants;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.smartling.aem.connector.automation.impl.TranslationJob;
import com.smartling.aem.connector.automation.impl.TranslationProjectException;
import com.smartling.aem.connector.automation.impl.TranslationProjectManager;
import com.smartling.aem.connector.core.impl.integration.sync.JobInfo;
import com.smartling.aem.connector.core.impl.integration.sync.SyncTranslationException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;

@Service(value={SyncJobInfoProvider.class})
@Component
public class SyncJobInfoProvider {
    @Reference
    private TranslationProjectManager translationProjectManager;
    private Cache<String, JobInfo> jobCache;

    @Activate
    public void activate(Map<String, Object> properties) {
        this.jobCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    }

    public JobInfo getJobInfo(ResourceResolver resourceResolver, String translationJobId) throws SyncTranslationException {
        JobInfo jobInfo = (JobInfo)this.jobCache.getIfPresent((Object)translationJobId);
        if (jobInfo != null) {
            return jobInfo;
        }
        try {
            TranslationJob job = this.translationProjectManager.getTranslationJobById(resourceResolver, translationJobId);
            jobInfo = new JobInfo(job.getResourcePath(), job.getJobId(), job.getStatus());
            if (jobInfo.status != TranslationConstants.TranslationStatus.COMMITTED_FOR_TRANSLATION && jobInfo.status != TranslationConstants.TranslationStatus.TRANSLATION_IN_PROGRESS && jobInfo.status != TranslationConstants.TranslationStatus.SUBMITTED) {
                this.jobCache.put((Object)job.getJobId(), (Object)jobInfo);
            }
            return jobInfo;
        }
        catch (TranslationProjectException e) {
            throw new SyncTranslationException(String.format("Couldn't find translation job by id=\"%s\"", translationJobId), e);
        }
    }

    protected void bindTranslationProjectManager(TranslationProjectManager translationProjectManager) {
        this.translationProjectManager = translationProjectManager;
    }

    protected void unbindTranslationProjectManager(TranslationProjectManager translationProjectManager) {
        if (this.translationProjectManager == translationProjectManager) {
            this.translationProjectManager = null;
        }
    }
}

