(function(document, XSS, $) {

    "use strict";

    var CONFIG_TEST_CONNECTION_ACTION_CLASS_SELECTOR = '.smartling-touch-coral-config-test-connection'

    $(document).on("foundation-selections-change", ".foundation-collection", function(e) {
        var collection = $(this);
        var columnView = collection[0];
        if (columnView.selectedItems.length == 1) {
            var configPath = $(columnView.selectedItem).attr('foundation-collection-item-id');
            var action = $(CONFIG_TEST_CONNECTION_ACTION_CLASS_SELECTOR);
            $.ajax({
                url: configPath + '/jcr:content/sling:resourceType.infinity.json',
                method: 'GET',
                dataType: 'json',
                cache : false,
                success: function (response) {
                    toggle(action, response['sling:resourceType'] === 'smartling-connector/components/cloud-config');
                },
                error: function () {
                    toggle(action, false);
                }
            });
        }
    });

    function toggle(action, show) {
        if (show) {
            action.removeAttr("hidden");
        } else {
            action.attr("hidden", "");
        }
    }

    $(window).adaptTo("foundation-registry").register("foundation.collection.action.action", {
        name: "smartling.config.testConnection",
        handler: function(name, el, config, collection, selections) {
            var configPath = selections.map(function(item) { return $(item).data("foundationCollectionItemId"); }).join(';');
            testConnection(configPath);
        }
    });

    function testConnection(configPath) {
        var dialog = new Coral.Dialog().set({
            id: "testConnectionDialog",
            header: {
                innerHTML: "Test Connection"
            },
            content: {
                innerHTML: "Checking configuration..."
            },
            footer: {
                innerHTML: "<button is=\"coral-button\" variant=\"primary\" coral-close=\"\" class=\"coral3-Button coral3-Button--primary\" size=\"M\"><coral-button-label>Ok</coral-button-label></button>"
            },
            variant: "info"
        });
        dialog.show();

        var checkConnectionRequest = function(url, configPath, callback) {
            $.ajax({
                url: url,
                method: 'GET',
                data: {
                    configPath: configPath
                },
                cache : false,
                success: function () {
                    callback && callback();
                },
                error: function (response) {
                    var errorText = response.responseText.startsWith('{')
                        ? $.parseJSON(response.responseText).error.details[0]
                        : $(response.responseText).filter('h1').html()
                    callback && callback(errorText);
                }
            });
        }
        var showResult = function(errorText) {
            if (errorText) {
                dialog.content.innerHTML = 'Connection Error: ' + errorText;
                dialog.variant = "error";
            } else {
                dialog.content.innerHTML = 'Connection test was successful';
                dialog.variant = "info";
            }
        }
        var checkContextConnection = function() {
            checkConnectionRequest("/services/smartling/context/connection/check", configPath, showResult);
        }
        var checkCloudConfigConnection = function() {
            checkConnectionRequest("/services/smartling/cloud/config/connection/check", configPath, function(errorText) {
                if (errorText) {
                    showResult(errorText)
                } else {
                    checkContextConnection();
                }
            });
        }
        checkCloudConfigConnection();
    }

})(document, _g.XSS, Granite.$);
