/*
 * Decompiled with CFR 0.152.
 */
package com.smartnews.jpa_entity_generator;

import com.smartnews.jpa_entity_generator.rule.Annotation;
import com.smartnews.jpa_entity_generator.rule.ClassAnnotationRule;
import com.smartnews.jpa_entity_generator.rule.ImportRule;
import com.smartnews.jpa_entity_generator.util.ResourceReader;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CodeRenderer {
    public static String render(String templatePath, RenderingData data) throws IOException, TemplateException {
        String source;
        Object object;
        Configuration config = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        StringTemplateLoader templateLoader = new StringTemplateLoader();
        try (InputStream is = ResourceReader.getResourceAsStream(templatePath);){
            BufferedReader buffer = new BufferedReader(new InputStreamReader(is));
            object = null;
            try {
                source = buffer.lines().collect(Collectors.joining("\n"));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (buffer != null) {
                    if (object != null) {
                        try {
                            buffer.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        buffer.close();
                    }
                }
            }
        }
        templateLoader.putTemplate("template", source);
        config.setTemplateLoader((TemplateLoader)templateLoader);
        config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        config.setObjectWrapper((ObjectWrapper)new BeansWrapper(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS));
        config.setWhitespaceStripping(true);
        var6_5 = null;
        try (StringWriter writer = new StringWriter();){
            Template template = config.getTemplate("template");
            template.process((Object)data, (Writer)writer);
            object = ((Object)writer).toString();
            return object;
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
    }

    public static class RenderingData {
        private String packageName;
        private String tableName;
        private String className;
        private String classComment;
        private boolean jpa1Compatible = false;
        private boolean requireJSR305 = false;
        private List<String> topAdditionalCodeList = new ArrayList<String>();
        private List<String> bottomAdditionalCodeList = new ArrayList<String>();
        private List<ImportRule> importRules = new ArrayList<ImportRule>();
        private List<ClassAnnotationRule> classAnnotationRules = new ArrayList<ClassAnnotationRule>();
        private List<String> interfaceNames = new ArrayList<String>();
        private List<Field> fields = new ArrayList<Field>();
        private List<Field> primaryKeyFields = new ArrayList<Field>();

        public String getPackageName() {
            return this.packageName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getClassComment() {
            return this.classComment;
        }

        public boolean isJpa1Compatible() {
            return this.jpa1Compatible;
        }

        public boolean isRequireJSR305() {
            return this.requireJSR305;
        }

        public List<String> getTopAdditionalCodeList() {
            return this.topAdditionalCodeList;
        }

        public List<String> getBottomAdditionalCodeList() {
            return this.bottomAdditionalCodeList;
        }

        public List<ImportRule> getImportRules() {
            return this.importRules;
        }

        public List<ClassAnnotationRule> getClassAnnotationRules() {
            return this.classAnnotationRules;
        }

        public List<String> getInterfaceNames() {
            return this.interfaceNames;
        }

        public List<Field> getFields() {
            return this.fields;
        }

        public List<Field> getPrimaryKeyFields() {
            return this.primaryKeyFields;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setClassComment(String classComment) {
            this.classComment = classComment;
        }

        public void setJpa1Compatible(boolean jpa1Compatible) {
            this.jpa1Compatible = jpa1Compatible;
        }

        public void setRequireJSR305(boolean requireJSR305) {
            this.requireJSR305 = requireJSR305;
        }

        public void setTopAdditionalCodeList(List<String> topAdditionalCodeList) {
            this.topAdditionalCodeList = topAdditionalCodeList;
        }

        public void setBottomAdditionalCodeList(List<String> bottomAdditionalCodeList) {
            this.bottomAdditionalCodeList = bottomAdditionalCodeList;
        }

        public void setImportRules(List<ImportRule> importRules) {
            this.importRules = importRules;
        }

        public void setClassAnnotationRules(List<ClassAnnotationRule> classAnnotationRules) {
            this.classAnnotationRules = classAnnotationRules;
        }

        public void setInterfaceNames(List<String> interfaceNames) {
            this.interfaceNames = interfaceNames;
        }

        public void setFields(List<Field> fields) {
            this.fields = fields;
        }

        public void setPrimaryKeyFields(List<Field> primaryKeyFields) {
            this.primaryKeyFields = primaryKeyFields;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RenderingData)) {
                return false;
            }
            RenderingData other = (RenderingData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$packageName = this.getPackageName();
            String other$packageName = other.getPackageName();
            if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
                return false;
            }
            String this$tableName = this.getTableName();
            String other$tableName = other.getTableName();
            if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            String this$classComment = this.getClassComment();
            String other$classComment = other.getClassComment();
            if (this$classComment == null ? other$classComment != null : !this$classComment.equals(other$classComment)) {
                return false;
            }
            if (this.isJpa1Compatible() != other.isJpa1Compatible()) {
                return false;
            }
            if (this.isRequireJSR305() != other.isRequireJSR305()) {
                return false;
            }
            List<String> this$topAdditionalCodeList = this.getTopAdditionalCodeList();
            List<String> other$topAdditionalCodeList = other.getTopAdditionalCodeList();
            if (this$topAdditionalCodeList == null ? other$topAdditionalCodeList != null : !((Object)this$topAdditionalCodeList).equals(other$topAdditionalCodeList)) {
                return false;
            }
            List<String> this$bottomAdditionalCodeList = this.getBottomAdditionalCodeList();
            List<String> other$bottomAdditionalCodeList = other.getBottomAdditionalCodeList();
            if (this$bottomAdditionalCodeList == null ? other$bottomAdditionalCodeList != null : !((Object)this$bottomAdditionalCodeList).equals(other$bottomAdditionalCodeList)) {
                return false;
            }
            List<ImportRule> this$importRules = this.getImportRules();
            List<ImportRule> other$importRules = other.getImportRules();
            if (this$importRules == null ? other$importRules != null : !((Object)this$importRules).equals(other$importRules)) {
                return false;
            }
            List<ClassAnnotationRule> this$classAnnotationRules = this.getClassAnnotationRules();
            List<ClassAnnotationRule> other$classAnnotationRules = other.getClassAnnotationRules();
            if (this$classAnnotationRules == null ? other$classAnnotationRules != null : !((Object)this$classAnnotationRules).equals(other$classAnnotationRules)) {
                return false;
            }
            List<String> this$interfaceNames = this.getInterfaceNames();
            List<String> other$interfaceNames = other.getInterfaceNames();
            if (this$interfaceNames == null ? other$interfaceNames != null : !((Object)this$interfaceNames).equals(other$interfaceNames)) {
                return false;
            }
            List<Field> this$fields = this.getFields();
            List<Field> other$fields = other.getFields();
            if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
                return false;
            }
            List<Field> this$primaryKeyFields = this.getPrimaryKeyFields();
            List<Field> other$primaryKeyFields = other.getPrimaryKeyFields();
            return !(this$primaryKeyFields == null ? other$primaryKeyFields != null : !((Object)this$primaryKeyFields).equals(other$primaryKeyFields));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RenderingData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $packageName = this.getPackageName();
            result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
            String $tableName = this.getTableName();
            result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            String $classComment = this.getClassComment();
            result = result * 59 + ($classComment == null ? 43 : $classComment.hashCode());
            result = result * 59 + (this.isJpa1Compatible() ? 79 : 97);
            result = result * 59 + (this.isRequireJSR305() ? 79 : 97);
            List<String> $topAdditionalCodeList = this.getTopAdditionalCodeList();
            result = result * 59 + ($topAdditionalCodeList == null ? 43 : ((Object)$topAdditionalCodeList).hashCode());
            List<String> $bottomAdditionalCodeList = this.getBottomAdditionalCodeList();
            result = result * 59 + ($bottomAdditionalCodeList == null ? 43 : ((Object)$bottomAdditionalCodeList).hashCode());
            List<ImportRule> $importRules = this.getImportRules();
            result = result * 59 + ($importRules == null ? 43 : ((Object)$importRules).hashCode());
            List<ClassAnnotationRule> $classAnnotationRules = this.getClassAnnotationRules();
            result = result * 59 + ($classAnnotationRules == null ? 43 : ((Object)$classAnnotationRules).hashCode());
            List<String> $interfaceNames = this.getInterfaceNames();
            result = result * 59 + ($interfaceNames == null ? 43 : ((Object)$interfaceNames).hashCode());
            List<Field> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            List<Field> $primaryKeyFields = this.getPrimaryKeyFields();
            result = result * 59 + ($primaryKeyFields == null ? 43 : ((Object)$primaryKeyFields).hashCode());
            return result;
        }

        public String toString() {
            return "CodeRenderer.RenderingData(packageName=" + this.getPackageName() + ", tableName=" + this.getTableName() + ", className=" + this.getClassName() + ", classComment=" + this.getClassComment() + ", jpa1Compatible=" + this.isJpa1Compatible() + ", requireJSR305=" + this.isRequireJSR305() + ", topAdditionalCodeList=" + this.getTopAdditionalCodeList() + ", bottomAdditionalCodeList=" + this.getBottomAdditionalCodeList() + ", importRules=" + this.getImportRules() + ", classAnnotationRules=" + this.getClassAnnotationRules() + ", interfaceNames=" + this.getInterfaceNames() + ", fields=" + this.getFields() + ", primaryKeyFields=" + this.getPrimaryKeyFields() + ")";
        }

        public static class Field {
            private String name;
            private String columnName;
            private boolean nullable;
            private String type;
            private String comment;
            private String defaultValue;
            private boolean primaryKey;
            private boolean autoIncrement;
            private boolean primitive;
            private String generatedValueStrategy;
            private List<Annotation> annotations = new ArrayList<Annotation>();

            public String getName() {
                return this.name;
            }

            public String getColumnName() {
                return this.columnName;
            }

            public boolean isNullable() {
                return this.nullable;
            }

            public String getType() {
                return this.type;
            }

            public String getComment() {
                return this.comment;
            }

            public String getDefaultValue() {
                return this.defaultValue;
            }

            public boolean isPrimaryKey() {
                return this.primaryKey;
            }

            public boolean isAutoIncrement() {
                return this.autoIncrement;
            }

            public boolean isPrimitive() {
                return this.primitive;
            }

            public String getGeneratedValueStrategy() {
                return this.generatedValueStrategy;
            }

            public List<Annotation> getAnnotations() {
                return this.annotations;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setColumnName(String columnName) {
                this.columnName = columnName;
            }

            public void setNullable(boolean nullable) {
                this.nullable = nullable;
            }

            public void setType(String type) {
                this.type = type;
            }

            public void setComment(String comment) {
                this.comment = comment;
            }

            public void setDefaultValue(String defaultValue) {
                this.defaultValue = defaultValue;
            }

            public void setPrimaryKey(boolean primaryKey) {
                this.primaryKey = primaryKey;
            }

            public void setAutoIncrement(boolean autoIncrement) {
                this.autoIncrement = autoIncrement;
            }

            public void setPrimitive(boolean primitive) {
                this.primitive = primitive;
            }

            public void setGeneratedValueStrategy(String generatedValueStrategy) {
                this.generatedValueStrategy = generatedValueStrategy;
            }

            public void setAnnotations(List<Annotation> annotations) {
                this.annotations = annotations;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Field)) {
                    return false;
                }
                Field other = (Field)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$columnName = this.getColumnName();
                String other$columnName = other.getColumnName();
                if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
                    return false;
                }
                if (this.isNullable() != other.isNullable()) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$comment = this.getComment();
                String other$comment = other.getComment();
                if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
                    return false;
                }
                String this$defaultValue = this.getDefaultValue();
                String other$defaultValue = other.getDefaultValue();
                if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
                    return false;
                }
                if (this.isPrimaryKey() != other.isPrimaryKey()) {
                    return false;
                }
                if (this.isAutoIncrement() != other.isAutoIncrement()) {
                    return false;
                }
                if (this.isPrimitive() != other.isPrimitive()) {
                    return false;
                }
                String this$generatedValueStrategy = this.getGeneratedValueStrategy();
                String other$generatedValueStrategy = other.getGeneratedValueStrategy();
                if (this$generatedValueStrategy == null ? other$generatedValueStrategy != null : !this$generatedValueStrategy.equals(other$generatedValueStrategy)) {
                    return false;
                }
                List<Annotation> this$annotations = this.getAnnotations();
                List<Annotation> other$annotations = other.getAnnotations();
                return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Field;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $columnName = this.getColumnName();
                result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
                result = result * 59 + (this.isNullable() ? 79 : 97);
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $comment = this.getComment();
                result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
                String $defaultValue = this.getDefaultValue();
                result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
                result = result * 59 + (this.isPrimaryKey() ? 79 : 97);
                result = result * 59 + (this.isAutoIncrement() ? 79 : 97);
                result = result * 59 + (this.isPrimitive() ? 79 : 97);
                String $generatedValueStrategy = this.getGeneratedValueStrategy();
                result = result * 59 + ($generatedValueStrategy == null ? 43 : $generatedValueStrategy.hashCode());
                List<Annotation> $annotations = this.getAnnotations();
                result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
                return result;
            }

            public String toString() {
                return "CodeRenderer.RenderingData.Field(name=" + this.getName() + ", columnName=" + this.getColumnName() + ", nullable=" + this.isNullable() + ", type=" + this.getType() + ", comment=" + this.getComment() + ", defaultValue=" + this.getDefaultValue() + ", primaryKey=" + this.isPrimaryKey() + ", autoIncrement=" + this.isAutoIncrement() + ", primitive=" + this.isPrimitive() + ", generatedValueStrategy=" + this.getGeneratedValueStrategy() + ", annotations=" + this.getAnnotations() + ")";
            }
        }
    }
}

