/*
 * Decompiled with CFR 0.152.
 */
package com.smartnews.jpa_entity_generator.config;

import com.smartnews.jpa_entity_generator.config.JDBCSettings;
import com.smartnews.jpa_entity_generator.rule.AdditionalCodeRule;
import com.smartnews.jpa_entity_generator.rule.Annotation;
import com.smartnews.jpa_entity_generator.rule.ClassAdditionalCommentRule;
import com.smartnews.jpa_entity_generator.rule.ClassAnnotationRule;
import com.smartnews.jpa_entity_generator.rule.ClassNameRule;
import com.smartnews.jpa_entity_generator.rule.FieldAdditionalCommentRule;
import com.smartnews.jpa_entity_generator.rule.FieldAnnotationRule;
import com.smartnews.jpa_entity_generator.rule.FieldDefaultValueRule;
import com.smartnews.jpa_entity_generator.rule.FieldTypeRule;
import com.smartnews.jpa_entity_generator.rule.ImportRule;
import com.smartnews.jpa_entity_generator.rule.InterfaceRule;
import com.smartnews.jpa_entity_generator.rule.TableExclusionRule;
import com.smartnews.jpa_entity_generator.rule.TableScanRule;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.Yaml;

public class CodeGeneratorConfig
implements Serializable {
    public static final List<ClassAnnotationRule> CLASS_ANNOTATIONS_NECESSARY_FOR_LOMBOK_BUILDER = Arrays.asList(ClassAnnotationRule.createGlobal(Annotation.fromClassName("lombok.NoArgsConstructor")), ClassAnnotationRule.createGlobal(Annotation.fromClassName("lombok.AllArgsConstructor")));
    public static final List<ImportRule> IMPORTS_NECESSARY_FOR_LOMBOK_BUILDER = Arrays.asList(ImportRule.createGlobal("lombok.NoArgsConstructor"), ImportRule.createGlobal("lombok.AllArgsConstructor"));
    private static final List<ClassAnnotationRule> PRESET_CLASS_ANNOTATIONS = Arrays.asList(ClassAnnotationRule.createGlobal(Annotation.fromClassName("lombok.Data")));
    private static final List<ImportRule> PRESET_IMPORTS = Arrays.asList(ImportRule.createGlobal("java.sql.*"), ImportRule.createGlobal("javax.persistence.*"), ImportRule.createGlobal("lombok.Data"));
    private static final List<ImportRule> JSR_305_PRESET_IMPORTS = Arrays.asList(ImportRule.createGlobal("javax.annotation.Nonnull"), ImportRule.createGlobal("javax.annotation.Nullable"));
    private static final Pattern REPLACE_ENV_VARIABLES_PATTERN = Pattern.compile("(\\$\\{[^}]+\\})");
    private JDBCSettings jdbcSettings;
    private List<String> tableNames = new ArrayList<String>();
    private String tableScanMode = "All";
    private List<TableScanRule> tableScanRules = new ArrayList<TableScanRule>();
    private List<TableExclusionRule> tableExclusionRules = new ArrayList<TableExclusionRule>();
    private String generatedValueStrategy = "IDENTITY";
    private String outputDirectory = "src/main/java";
    private String packageName = "com.smartnews.db";
    private String packageNameForJpa1 = "com.smartnews.db.jpa1";
    private boolean jpa1SupportRequired;
    private boolean jsr305AnnotationsRequired;
    private boolean usePrimitiveForNonNullField;
    private boolean autoPreparationForLombokBuilderEnabled;
    private List<ImportRule> importRules = new ArrayList<ImportRule>();
    private List<ClassNameRule> classNameRules = new ArrayList<ClassNameRule>();
    private List<ClassAnnotationRule> classAnnotationRules = new ArrayList<ClassAnnotationRule>();
    private List<InterfaceRule> interfaceRules = new ArrayList<InterfaceRule>();
    private List<ClassAdditionalCommentRule> classAdditionalCommentRules = new ArrayList<ClassAdditionalCommentRule>();
    private List<FieldTypeRule> fieldTypeRules = new ArrayList<FieldTypeRule>();
    private List<FieldAnnotationRule> fieldAnnotationRules = new ArrayList<FieldAnnotationRule>();
    private List<FieldDefaultValueRule> fieldDefaultValueRules = new ArrayList<FieldDefaultValueRule>();
    private List<FieldAdditionalCommentRule> fieldAdditionalCommentRules = new ArrayList<FieldAdditionalCommentRule>();
    private List<AdditionalCodeRule> additionalCodeRules = new ArrayList<AdditionalCodeRule>();
    private static final Yaml YAML = new Yaml();

    public void loadEnvVariables() {
        JDBCSettings settings = this.getJdbcSettings();
        if (CodeGeneratorConfig.hasEnvVariables(settings.getUrl())) {
            settings.setUrl(CodeGeneratorConfig.replaceEnvVariables(settings.getUrl()));
        }
        if (CodeGeneratorConfig.hasEnvVariables(settings.getUsername())) {
            settings.setUsername(CodeGeneratorConfig.replaceEnvVariables(settings.getUsername()));
        }
        if (CodeGeneratorConfig.hasEnvVariables(settings.getPassword())) {
            settings.setPassword(CodeGeneratorConfig.replaceEnvVariables(settings.getPassword()));
        }
        if (CodeGeneratorConfig.hasEnvVariables(settings.getDriverClassName())) {
            settings.setDriverClassName(CodeGeneratorConfig.replaceEnvVariables(settings.getDriverClassName()));
        }
    }

    static boolean hasEnvVariables(String value) {
        return value != null && value.contains("${");
    }

    static String replaceEnvVariables(String value) {
        Matcher matcher = REPLACE_ENV_VARIABLES_PATTERN.matcher(value);
        if (matcher.find()) {
            String replacedValue = value;
            Map<String, String> envVariables = System.getenv();
            for (int i = 0; i < matcher.groupCount(); ++i) {
                String grouped = matcher.group(i + 1);
                String envKey = grouped.replaceAll("[\\$\\{\\}]", "");
                String envValue = envVariables.get(envKey);
                if (envValue == null) {
                    throw new IllegalStateException("Env variable: " + envKey + " was not found!");
                }
                replacedValue = replacedValue.replace(grouped, envValue);
            }
            return replacedValue;
        }
        return value;
    }

    public void setUpPresetRules() {
        this.getClassAnnotationRules().addAll(0, PRESET_CLASS_ANNOTATIONS);
        this.getImportRules().addAll(0, PRESET_IMPORTS);
        if (this.autoPreparationForLombokBuilderEnabled) {
            this.getClassAnnotationRules().addAll(CLASS_ANNOTATIONS_NECESSARY_FOR_LOMBOK_BUILDER);
            this.getImportRules().addAll(IMPORTS_NECESSARY_FOR_LOMBOK_BUILDER);
        }
        if (this.jsr305AnnotationsRequired) {
            this.getImportRules().addAll(JSR_305_PRESET_IMPORTS);
        }
    }

    /*
     * Exception decompiling
     */
    public static CodeGeneratorConfig load(String path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public JDBCSettings getJdbcSettings() {
        return this.jdbcSettings;
    }

    public List<String> getTableNames() {
        return this.tableNames;
    }

    public String getTableScanMode() {
        return this.tableScanMode;
    }

    public List<TableScanRule> getTableScanRules() {
        return this.tableScanRules;
    }

    public List<TableExclusionRule> getTableExclusionRules() {
        return this.tableExclusionRules;
    }

    public String getGeneratedValueStrategy() {
        return this.generatedValueStrategy;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPackageNameForJpa1() {
        return this.packageNameForJpa1;
    }

    public boolean isJpa1SupportRequired() {
        return this.jpa1SupportRequired;
    }

    public boolean isJsr305AnnotationsRequired() {
        return this.jsr305AnnotationsRequired;
    }

    public boolean isUsePrimitiveForNonNullField() {
        return this.usePrimitiveForNonNullField;
    }

    public boolean isAutoPreparationForLombokBuilderEnabled() {
        return this.autoPreparationForLombokBuilderEnabled;
    }

    public List<ImportRule> getImportRules() {
        return this.importRules;
    }

    public List<ClassNameRule> getClassNameRules() {
        return this.classNameRules;
    }

    public List<ClassAnnotationRule> getClassAnnotationRules() {
        return this.classAnnotationRules;
    }

    public List<InterfaceRule> getInterfaceRules() {
        return this.interfaceRules;
    }

    public List<ClassAdditionalCommentRule> getClassAdditionalCommentRules() {
        return this.classAdditionalCommentRules;
    }

    public List<FieldTypeRule> getFieldTypeRules() {
        return this.fieldTypeRules;
    }

    public List<FieldAnnotationRule> getFieldAnnotationRules() {
        return this.fieldAnnotationRules;
    }

    public List<FieldDefaultValueRule> getFieldDefaultValueRules() {
        return this.fieldDefaultValueRules;
    }

    public List<FieldAdditionalCommentRule> getFieldAdditionalCommentRules() {
        return this.fieldAdditionalCommentRules;
    }

    public List<AdditionalCodeRule> getAdditionalCodeRules() {
        return this.additionalCodeRules;
    }

    public void setJdbcSettings(JDBCSettings jdbcSettings) {
        this.jdbcSettings = jdbcSettings;
    }

    public void setTableNames(List<String> tableNames) {
        this.tableNames = tableNames;
    }

    public void setTableScanMode(String tableScanMode) {
        this.tableScanMode = tableScanMode;
    }

    public void setTableScanRules(List<TableScanRule> tableScanRules) {
        this.tableScanRules = tableScanRules;
    }

    public void setTableExclusionRules(List<TableExclusionRule> tableExclusionRules) {
        this.tableExclusionRules = tableExclusionRules;
    }

    public void setGeneratedValueStrategy(String generatedValueStrategy) {
        this.generatedValueStrategy = generatedValueStrategy;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageNameForJpa1(String packageNameForJpa1) {
        this.packageNameForJpa1 = packageNameForJpa1;
    }

    public void setJpa1SupportRequired(boolean jpa1SupportRequired) {
        this.jpa1SupportRequired = jpa1SupportRequired;
    }

    public void setJsr305AnnotationsRequired(boolean jsr305AnnotationsRequired) {
        this.jsr305AnnotationsRequired = jsr305AnnotationsRequired;
    }

    public void setUsePrimitiveForNonNullField(boolean usePrimitiveForNonNullField) {
        this.usePrimitiveForNonNullField = usePrimitiveForNonNullField;
    }

    public void setAutoPreparationForLombokBuilderEnabled(boolean autoPreparationForLombokBuilderEnabled) {
        this.autoPreparationForLombokBuilderEnabled = autoPreparationForLombokBuilderEnabled;
    }

    public void setImportRules(List<ImportRule> importRules) {
        this.importRules = importRules;
    }

    public void setClassNameRules(List<ClassNameRule> classNameRules) {
        this.classNameRules = classNameRules;
    }

    public void setClassAnnotationRules(List<ClassAnnotationRule> classAnnotationRules) {
        this.classAnnotationRules = classAnnotationRules;
    }

    public void setInterfaceRules(List<InterfaceRule> interfaceRules) {
        this.interfaceRules = interfaceRules;
    }

    public void setClassAdditionalCommentRules(List<ClassAdditionalCommentRule> classAdditionalCommentRules) {
        this.classAdditionalCommentRules = classAdditionalCommentRules;
    }

    public void setFieldTypeRules(List<FieldTypeRule> fieldTypeRules) {
        this.fieldTypeRules = fieldTypeRules;
    }

    public void setFieldAnnotationRules(List<FieldAnnotationRule> fieldAnnotationRules) {
        this.fieldAnnotationRules = fieldAnnotationRules;
    }

    public void setFieldDefaultValueRules(List<FieldDefaultValueRule> fieldDefaultValueRules) {
        this.fieldDefaultValueRules = fieldDefaultValueRules;
    }

    public void setFieldAdditionalCommentRules(List<FieldAdditionalCommentRule> fieldAdditionalCommentRules) {
        this.fieldAdditionalCommentRules = fieldAdditionalCommentRules;
    }

    public void setAdditionalCodeRules(List<AdditionalCodeRule> additionalCodeRules) {
        this.additionalCodeRules = additionalCodeRules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodeGeneratorConfig)) {
            return false;
        }
        CodeGeneratorConfig other = (CodeGeneratorConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JDBCSettings this$jdbcSettings = this.getJdbcSettings();
        JDBCSettings other$jdbcSettings = other.getJdbcSettings();
        if (this$jdbcSettings == null ? other$jdbcSettings != null : !((Object)this$jdbcSettings).equals(other$jdbcSettings)) {
            return false;
        }
        List<String> this$tableNames = this.getTableNames();
        List<String> other$tableNames = other.getTableNames();
        if (this$tableNames == null ? other$tableNames != null : !((Object)this$tableNames).equals(other$tableNames)) {
            return false;
        }
        String this$tableScanMode = this.getTableScanMode();
        String other$tableScanMode = other.getTableScanMode();
        if (this$tableScanMode == null ? other$tableScanMode != null : !this$tableScanMode.equals(other$tableScanMode)) {
            return false;
        }
        List<TableScanRule> this$tableScanRules = this.getTableScanRules();
        List<TableScanRule> other$tableScanRules = other.getTableScanRules();
        if (this$tableScanRules == null ? other$tableScanRules != null : !((Object)this$tableScanRules).equals(other$tableScanRules)) {
            return false;
        }
        List<TableExclusionRule> this$tableExclusionRules = this.getTableExclusionRules();
        List<TableExclusionRule> other$tableExclusionRules = other.getTableExclusionRules();
        if (this$tableExclusionRules == null ? other$tableExclusionRules != null : !((Object)this$tableExclusionRules).equals(other$tableExclusionRules)) {
            return false;
        }
        String this$generatedValueStrategy = this.getGeneratedValueStrategy();
        String other$generatedValueStrategy = other.getGeneratedValueStrategy();
        if (this$generatedValueStrategy == null ? other$generatedValueStrategy != null : !this$generatedValueStrategy.equals(other$generatedValueStrategy)) {
            return false;
        }
        String this$outputDirectory = this.getOutputDirectory();
        String other$outputDirectory = other.getOutputDirectory();
        if (this$outputDirectory == null ? other$outputDirectory != null : !this$outputDirectory.equals(other$outputDirectory)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        String this$packageNameForJpa1 = this.getPackageNameForJpa1();
        String other$packageNameForJpa1 = other.getPackageNameForJpa1();
        if (this$packageNameForJpa1 == null ? other$packageNameForJpa1 != null : !this$packageNameForJpa1.equals(other$packageNameForJpa1)) {
            return false;
        }
        if (this.isJpa1SupportRequired() != other.isJpa1SupportRequired()) {
            return false;
        }
        if (this.isJsr305AnnotationsRequired() != other.isJsr305AnnotationsRequired()) {
            return false;
        }
        if (this.isUsePrimitiveForNonNullField() != other.isUsePrimitiveForNonNullField()) {
            return false;
        }
        if (this.isAutoPreparationForLombokBuilderEnabled() != other.isAutoPreparationForLombokBuilderEnabled()) {
            return false;
        }
        List<ImportRule> this$importRules = this.getImportRules();
        List<ImportRule> other$importRules = other.getImportRules();
        if (this$importRules == null ? other$importRules != null : !((Object)this$importRules).equals(other$importRules)) {
            return false;
        }
        List<ClassNameRule> this$classNameRules = this.getClassNameRules();
        List<ClassNameRule> other$classNameRules = other.getClassNameRules();
        if (this$classNameRules == null ? other$classNameRules != null : !((Object)this$classNameRules).equals(other$classNameRules)) {
            return false;
        }
        List<ClassAnnotationRule> this$classAnnotationRules = this.getClassAnnotationRules();
        List<ClassAnnotationRule> other$classAnnotationRules = other.getClassAnnotationRules();
        if (this$classAnnotationRules == null ? other$classAnnotationRules != null : !((Object)this$classAnnotationRules).equals(other$classAnnotationRules)) {
            return false;
        }
        List<InterfaceRule> this$interfaceRules = this.getInterfaceRules();
        List<InterfaceRule> other$interfaceRules = other.getInterfaceRules();
        if (this$interfaceRules == null ? other$interfaceRules != null : !((Object)this$interfaceRules).equals(other$interfaceRules)) {
            return false;
        }
        List<ClassAdditionalCommentRule> this$classAdditionalCommentRules = this.getClassAdditionalCommentRules();
        List<ClassAdditionalCommentRule> other$classAdditionalCommentRules = other.getClassAdditionalCommentRules();
        if (this$classAdditionalCommentRules == null ? other$classAdditionalCommentRules != null : !((Object)this$classAdditionalCommentRules).equals(other$classAdditionalCommentRules)) {
            return false;
        }
        List<FieldTypeRule> this$fieldTypeRules = this.getFieldTypeRules();
        List<FieldTypeRule> other$fieldTypeRules = other.getFieldTypeRules();
        if (this$fieldTypeRules == null ? other$fieldTypeRules != null : !((Object)this$fieldTypeRules).equals(other$fieldTypeRules)) {
            return false;
        }
        List<FieldAnnotationRule> this$fieldAnnotationRules = this.getFieldAnnotationRules();
        List<FieldAnnotationRule> other$fieldAnnotationRules = other.getFieldAnnotationRules();
        if (this$fieldAnnotationRules == null ? other$fieldAnnotationRules != null : !((Object)this$fieldAnnotationRules).equals(other$fieldAnnotationRules)) {
            return false;
        }
        List<FieldDefaultValueRule> this$fieldDefaultValueRules = this.getFieldDefaultValueRules();
        List<FieldDefaultValueRule> other$fieldDefaultValueRules = other.getFieldDefaultValueRules();
        if (this$fieldDefaultValueRules == null ? other$fieldDefaultValueRules != null : !((Object)this$fieldDefaultValueRules).equals(other$fieldDefaultValueRules)) {
            return false;
        }
        List<FieldAdditionalCommentRule> this$fieldAdditionalCommentRules = this.getFieldAdditionalCommentRules();
        List<FieldAdditionalCommentRule> other$fieldAdditionalCommentRules = other.getFieldAdditionalCommentRules();
        if (this$fieldAdditionalCommentRules == null ? other$fieldAdditionalCommentRules != null : !((Object)this$fieldAdditionalCommentRules).equals(other$fieldAdditionalCommentRules)) {
            return false;
        }
        List<AdditionalCodeRule> this$additionalCodeRules = this.getAdditionalCodeRules();
        List<AdditionalCodeRule> other$additionalCodeRules = other.getAdditionalCodeRules();
        return !(this$additionalCodeRules == null ? other$additionalCodeRules != null : !((Object)this$additionalCodeRules).equals(other$additionalCodeRules));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CodeGeneratorConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JDBCSettings $jdbcSettings = this.getJdbcSettings();
        result = result * 59 + ($jdbcSettings == null ? 43 : ((Object)$jdbcSettings).hashCode());
        List<String> $tableNames = this.getTableNames();
        result = result * 59 + ($tableNames == null ? 43 : ((Object)$tableNames).hashCode());
        String $tableScanMode = this.getTableScanMode();
        result = result * 59 + ($tableScanMode == null ? 43 : $tableScanMode.hashCode());
        List<TableScanRule> $tableScanRules = this.getTableScanRules();
        result = result * 59 + ($tableScanRules == null ? 43 : ((Object)$tableScanRules).hashCode());
        List<TableExclusionRule> $tableExclusionRules = this.getTableExclusionRules();
        result = result * 59 + ($tableExclusionRules == null ? 43 : ((Object)$tableExclusionRules).hashCode());
        String $generatedValueStrategy = this.getGeneratedValueStrategy();
        result = result * 59 + ($generatedValueStrategy == null ? 43 : $generatedValueStrategy.hashCode());
        String $outputDirectory = this.getOutputDirectory();
        result = result * 59 + ($outputDirectory == null ? 43 : $outputDirectory.hashCode());
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        String $packageNameForJpa1 = this.getPackageNameForJpa1();
        result = result * 59 + ($packageNameForJpa1 == null ? 43 : $packageNameForJpa1.hashCode());
        result = result * 59 + (this.isJpa1SupportRequired() ? 79 : 97);
        result = result * 59 + (this.isJsr305AnnotationsRequired() ? 79 : 97);
        result = result * 59 + (this.isUsePrimitiveForNonNullField() ? 79 : 97);
        result = result * 59 + (this.isAutoPreparationForLombokBuilderEnabled() ? 79 : 97);
        List<ImportRule> $importRules = this.getImportRules();
        result = result * 59 + ($importRules == null ? 43 : ((Object)$importRules).hashCode());
        List<ClassNameRule> $classNameRules = this.getClassNameRules();
        result = result * 59 + ($classNameRules == null ? 43 : ((Object)$classNameRules).hashCode());
        List<ClassAnnotationRule> $classAnnotationRules = this.getClassAnnotationRules();
        result = result * 59 + ($classAnnotationRules == null ? 43 : ((Object)$classAnnotationRules).hashCode());
        List<InterfaceRule> $interfaceRules = this.getInterfaceRules();
        result = result * 59 + ($interfaceRules == null ? 43 : ((Object)$interfaceRules).hashCode());
        List<ClassAdditionalCommentRule> $classAdditionalCommentRules = this.getClassAdditionalCommentRules();
        result = result * 59 + ($classAdditionalCommentRules == null ? 43 : ((Object)$classAdditionalCommentRules).hashCode());
        List<FieldTypeRule> $fieldTypeRules = this.getFieldTypeRules();
        result = result * 59 + ($fieldTypeRules == null ? 43 : ((Object)$fieldTypeRules).hashCode());
        List<FieldAnnotationRule> $fieldAnnotationRules = this.getFieldAnnotationRules();
        result = result * 59 + ($fieldAnnotationRules == null ? 43 : ((Object)$fieldAnnotationRules).hashCode());
        List<FieldDefaultValueRule> $fieldDefaultValueRules = this.getFieldDefaultValueRules();
        result = result * 59 + ($fieldDefaultValueRules == null ? 43 : ((Object)$fieldDefaultValueRules).hashCode());
        List<FieldAdditionalCommentRule> $fieldAdditionalCommentRules = this.getFieldAdditionalCommentRules();
        result = result * 59 + ($fieldAdditionalCommentRules == null ? 43 : ((Object)$fieldAdditionalCommentRules).hashCode());
        List<AdditionalCodeRule> $additionalCodeRules = this.getAdditionalCodeRules();
        result = result * 59 + ($additionalCodeRules == null ? 43 : ((Object)$additionalCodeRules).hashCode());
        return result;
    }

    public String toString() {
        return "CodeGeneratorConfig(jdbcSettings=" + this.getJdbcSettings() + ", tableNames=" + this.getTableNames() + ", tableScanMode=" + this.getTableScanMode() + ", tableScanRules=" + this.getTableScanRules() + ", tableExclusionRules=" + this.getTableExclusionRules() + ", generatedValueStrategy=" + this.getGeneratedValueStrategy() + ", outputDirectory=" + this.getOutputDirectory() + ", packageName=" + this.getPackageName() + ", packageNameForJpa1=" + this.getPackageNameForJpa1() + ", jpa1SupportRequired=" + this.isJpa1SupportRequired() + ", jsr305AnnotationsRequired=" + this.isJsr305AnnotationsRequired() + ", usePrimitiveForNonNullField=" + this.isUsePrimitiveForNonNullField() + ", autoPreparationForLombokBuilderEnabled=" + this.isAutoPreparationForLombokBuilderEnabled() + ", importRules=" + this.getImportRules() + ", classNameRules=" + this.getClassNameRules() + ", classAnnotationRules=" + this.getClassAnnotationRules() + ", interfaceRules=" + this.getInterfaceRules() + ", classAdditionalCommentRules=" + this.getClassAdditionalCommentRules() + ", fieldTypeRules=" + this.getFieldTypeRules() + ", fieldAnnotationRules=" + this.getFieldAnnotationRules() + ", fieldDefaultValueRules=" + this.getFieldDefaultValueRules() + ", fieldAdditionalCommentRules=" + this.getFieldAdditionalCommentRules() + ", additionalCodeRules=" + this.getAdditionalCodeRules() + ")";
    }
}

