/*
 * Decompiled with CFR 0.152.
 */
package com.smartnews.jpa_entity_generator.metadata;

import com.smartnews.jpa_entity_generator.config.JDBCSettings;
import com.smartnews.jpa_entity_generator.metadata.Column;
import com.smartnews.jpa_entity_generator.metadata.Table;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMetadataFetcher {
    private static final Logger log = LoggerFactory.getLogger(TableMetadataFetcher.class);
    private static final String[] TABLE_TYPES = new String[]{"TABLE", "VIEW"};

    private DatabaseMetaData getMetadata(JDBCSettings settings) throws SQLException {
        try {
            Class.forName(settings.getDriverClassName());
        }
        catch (ClassNotFoundException e) {
            log.error("Failed to load JDBC driver (driver: {}, error: {})", new Object[]{settings.getDriverClassName(), e.getMessage(), e});
            throw new SQLException(e);
        }
        Connection connection = DriverManager.getConnection(settings.getUrl(), settings.getUsername(), settings.getPassword());
        return connection.getMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTableNames(JDBCSettings jdbcSettings) throws SQLException {
        DatabaseMetaData databaseMeta = this.getMetadata(jdbcSettings);
        try {
            ArrayList<String> tableNames = new ArrayList<String>();
            try (ResultSet rs = databaseMeta.getTables(null, jdbcSettings.getSchemaPattern(), "%", TABLE_TYPES);){
                while (rs.next()) {
                    tableNames.add(rs.getString("TABLE_NAME"));
                }
            }
            ArrayList<String> arrayList = tableNames;
            return arrayList;
        }
        finally {
            databaseMeta.getConnection().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getTable(JDBCSettings jdbcSettings, String schemaAndTable) throws SQLException {
        Table tableInfo = new Table();
        String schema = TableMetadataFetcher.extractSchema(schemaAndTable);
        String table = TableMetadataFetcher.extractTabeName(schemaAndTable);
        tableInfo.setName(table);
        tableInfo.setSchema(Optional.ofNullable(schema));
        DatabaseMetaData databaseMeta = this.getMetadata(jdbcSettings);
        try {
            Object object;
            try {
                ResultSet rs = databaseMeta.getTables(null, schema, table, TABLE_TYPES);
                object = null;
                try {
                    if (rs.next()) {
                        tableInfo.setDescription(Optional.ofNullable(rs.getString("REMARKS")));
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (rs != null) {
                        if (object != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                log.debug("Failed to fetch table comment", (Throwable)e);
            }
            ArrayList<String> primaryKeyNames = new ArrayList<String>();
            try (ResultSet rs = databaseMeta.getPrimaryKeys(null, schema, table);){
                while (rs.next()) {
                    primaryKeyNames.add(rs.getString("COLUMN_NAME"));
                }
            }
            rs = databaseMeta.getColumns(null, schema, table, "%");
            var9_12 = null;
            try {
                while (rs.next()) {
                    Column column = new Column();
                    column.setName(rs.getString("COLUMN_NAME"));
                    column.setTypeCode(rs.getInt("DATA_TYPE"));
                    column.setTypeName(rs.getString("TYPE_NAME"));
                    boolean autoIncrement = false;
                    try {
                        String autoIncrementMetadata = rs.getString("IS_AUTOINCREMENT");
                        autoIncrement = autoIncrementMetadata != null && autoIncrementMetadata.equals("YES");
                    }
                    catch (Exception e) {
                        log.debug("Failed to fetch auto_increment flag for {}.{}", new Object[]{table, column.getName(), e});
                    }
                    column.setAutoIncrement(autoIncrement);
                    try {
                        column.setDescription(Optional.ofNullable(rs.getString("REMARKS")));
                    }
                    catch (Exception e) {
                        log.debug("Failed to fetch comment flag for {}.{}", new Object[]{table, column.getName(), e});
                    }
                    boolean nullable = true;
                    try {
                        String isNullableMetadata = rs.getString("IS_NULLABLE");
                        nullable = isNullableMetadata == null || isNullableMetadata.equals("YES");
                    }
                    catch (Exception e) {
                        log.debug("Failed to fetch nullable flag for {}.{}", new Object[]{table, column.getName(), e});
                    }
                    column.setNullable(nullable);
                    boolean primaryKey = false;
                    try {
                        primaryKey = primaryKeyNames.stream().filter(pk -> pk.equals(TableMetadataFetcher.columnName(rs))).count() > 0L;
                    }
                    catch (Exception e) {
                        log.debug("Failed to fetch primary key or not for {}.{}", new Object[]{table, column.getName(), e});
                    }
                    column.setPrimaryKey(primaryKey);
                    tableInfo.getColumns().add(column);
                }
            }
            catch (Throwable throwable) {
                var9_12 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var9_12 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var9_12.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            object = tableInfo;
            return object;
        }
        finally {
            databaseMeta.getConnection().close();
        }
    }

    private static final String columnName(ResultSet rs) {
        try {
            return rs.getString("COLUMN_NAME");
        }
        catch (SQLException e) {
            return null;
        }
    }

    private static String extractSchema(String schemaAndTable) {
        if (schemaAndTable.contains(".")) {
            return schemaAndTable.split(".")[0];
        }
        return null;
    }

    private static String extractTabeName(String schemaAndTable) {
        if (schemaAndTable.contains(".")) {
            return schemaAndTable.split(".")[1];
        }
        return schemaAndTable;
    }
}

