/*
 * Decompiled with CFR 0.152.
 */
package com.smartnews.jpa_entity_generator.rule;

import com.smartnews.jpa_entity_generator.rule.AnnotationAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Annotation
implements Serializable {
    private String className;
    private String code;
    private List<AnnotationAttribute> attributes = new ArrayList<AnnotationAttribute>();

    public String toString() {
        if (StringUtils.isEmpty((CharSequence)this.getCode())) {
            if (this.attributes != null && this.attributes.size() > 0) {
                String attributesPart = this.attributes.stream().map(a -> {
                    if (StringUtils.isEmpty((CharSequence)a.getCode())) {
                        return a.getName() + " = " + a.getValue();
                    }
                    return a.getCode();
                }).collect(Collectors.joining(", ", "(", ")"));
                return "@" + this.className + attributesPart;
            }
            return "@" + this.className;
        }
        return this.getCode();
    }

    public static Annotation fromCode(String code) {
        Annotation annotation = new Annotation();
        annotation.setCode(code);
        return annotation;
    }

    public static Annotation fromClassName(String className) {
        Annotation annotation = new Annotation();
        annotation.setClassName(className);
        return annotation;
    }

    public String getClassName() {
        return this.className;
    }

    public String getCode() {
        return this.code;
    }

    public List<AnnotationAttribute> getAttributes() {
        return this.attributes;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setAttributes(List<AnnotationAttribute> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Annotation)) {
            return false;
        }
        Annotation other = (Annotation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        List<AnnotationAttribute> this$attributes = this.getAttributes();
        List<AnnotationAttribute> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Annotation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        List<AnnotationAttribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }
}

