/*
 * Decompiled with CFR 0.152.
 */
package com.smartnews.jpa_entity_generator.rule;

import com.smartnews.jpa_entity_generator.rule.ClassMatcher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ImportRule
implements Serializable,
ClassMatcher {
    private String className;
    private List<String> classNames = new ArrayList<String>();
    private String importValue;

    public boolean importValueContains(String className) {
        if (this.importValue.startsWith("static")) {
            return false;
        }
        if (this.importValue.endsWith(".*")) {
            return className.replaceFirst("\\.[^\\.]+$", ".*").equals(this.importValue);
        }
        return className.equals(this.importValue);
    }

    public static ImportRule createGlobal(String importValue) {
        ImportRule rule = new ImportRule();
        rule.setImportValue(importValue);
        return rule;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public List<String> getClassNames() {
        return this.classNames;
    }

    public String getImportValue() {
        return this.importValue;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setClassNames(List<String> classNames) {
        this.classNames = classNames;
    }

    public void setImportValue(String importValue) {
        this.importValue = importValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImportRule)) {
            return false;
        }
        ImportRule other = (ImportRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        List<String> this$classNames = this.getClassNames();
        List<String> other$classNames = other.getClassNames();
        if (this$classNames == null ? other$classNames != null : !((Object)this$classNames).equals(other$classNames)) {
            return false;
        }
        String this$importValue = this.getImportValue();
        String other$importValue = other.getImportValue();
        return !(this$importValue == null ? other$importValue != null : !this$importValue.equals(other$importValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImportRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        List<String> $classNames = this.getClassNames();
        result = result * 59 + ($classNames == null ? 43 : ((Object)$classNames).hashCode());
        String $importValue = this.getImportValue();
        result = result * 59 + ($importValue == null ? 43 : $importValue.hashCode());
        return result;
    }

    public String toString() {
        return "ImportRule(className=" + this.getClassName() + ", classNames=" + this.getClassNames() + ", importValue=" + this.getImportValue() + ")";
    }
}

