package com.smartsheet.api.internal.json;
/*
 * #[license]
 * Smartsheet SDK for Java
 * %%
 * Copyright (C) 2016 Smartsheet
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * %[license]
 */

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.smartsheet.api.models.Cell;
import com.smartsheet.api.models.CellLink;

/**
 * If the class being serialized is a cell, pass along the default serializer along to the CellSerializer object.
 * We'll special case the linkInFromCell case but pass the rest along to the default serializer.
 */
public class CellSerializerModifier extends BeanSerializerModifier {
    @Override
    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        if (beanDesc.getBeanClass() == Cell.class) {
            return new CellSerializer((JsonSerializer<Object>) serializer);
        }
        else if (beanDesc.getBeanClass() == CellLink.class) {
            return new CellLinkSerializer((JsonSerializer<Object>) serializer);
        }
        return serializer;
    }
}
