/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.GroupMemberResources;
import com.smartsheet.api.GroupResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.GroupMemberResourcesImpl;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.Group;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;

public class GroupResourcesImpl
extends AbstractResources
implements GroupResources {
    private GroupMemberResources groupMemberResources;

    public GroupResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
        this.groupMemberResources = new GroupMemberResourcesImpl(smartsheet, "group");
    }

    @Override
    public PagedResult<Group> listGroups(PaginationParameters paging) throws SmartsheetException {
        String path = "groups";
        if (paging != null) {
            path = path + paging.toQueryString();
        }
        return this.listResourcesWithWrapper(path, Group.class);
    }

    @Override
    public Group getGroup(long groupId) throws SmartsheetException {
        return this.getResource("groups/" + groupId, Group.class);
    }

    @Override
    public Group createGroup(Group group) throws SmartsheetException {
        Util.throwIfNull(group);
        return this.createResource("groups", Group.class, group);
    }

    @Override
    public Group updateGroup(Group group) throws SmartsheetException {
        Util.throwIfNull(group);
        return this.updateResource("groups/" + group.getId(), Group.class, group);
    }

    @Override
    public void deleteGroup(long groupId) throws SmartsheetException {
        this.deleteResource("groups/" + groupId, Group.class);
    }

    @Override
    public GroupMemberResources memberResources() throws SmartsheetException {
        return this.groupMemberResources;
    }
}

