/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LengthEnforcingInputStream
extends FilterInputStream {
    private long expectedLength;
    private long totalBytesRead = 0L;

    public LengthEnforcingInputStream(InputStream inputStream, long expectedLength) {
        super(inputStream);
        this.expectedLength = expectedLength;
    }

    @Override
    public synchronized int read() throws IOException {
        int bytesRead = this.in.read();
        if (bytesRead == -1) {
            this.checkLength();
        } else {
            this.totalBytesRead += (long)bytesRead;
            this.checkForTooManyBytes();
        }
        return bytesRead;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.in.read(b, off, len);
        if (bytesRead == -1) {
            this.checkLength();
        } else {
            this.totalBytesRead += (long)bytesRead;
            this.checkForTooManyBytes();
        }
        return bytesRead;
    }

    private void checkForTooManyBytes() throws EOFException {
        if (this.totalBytesRead > this.expectedLength) {
            throw new EOFException("Incorrect stream length, expected: " + this.expectedLength + ", actual: " + this.totalBytesRead);
        }
    }

    private void checkLength() throws EOFException {
        if (this.totalBytesRead != this.expectedLength) {
            throw new EOFException("Incorrect stream length, expected: " + this.expectedLength + ", actual: " + this.totalBytesRead);
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.totalBytesRead = 0L;
        super.reset();
    }
}

