/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal.http;

import com.smartsheet.api.internal.http.HttpClient;
import com.smartsheet.api.internal.http.HttpClientException;
import com.smartsheet.api.internal.http.HttpEntity;
import com.smartsheet.api.internal.http.HttpRequest;
import com.smartsheet.api.internal.http.HttpResponse;
import com.smartsheet.api.internal.json.JacksonJsonSerializer;
import com.smartsheet.api.internal.json.JsonSerializer;
import com.smartsheet.api.internal.util.StreamUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.Error;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidHttpClient
implements HttpClient {
    protected static final Logger logger = LoggerFactory.getLogger(AndroidHttpClient.class);
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json");
    private final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
    private Response currentResponse;
    protected JsonSerializer jsonSerializer = new JacksonJsonSerializer();
    protected long maxRetryTimeMillis = 15000L;

    public void logRequest(Request request, Response response, long durationMillis) {
        logger.info("{} {}, Response Code:{}, Request completed in {} ms", new Object[]{request.method(), request.url(), response.code(), durationMillis});
        if (response.code() != 200) {
            try {
                logger.warn(this.currentResponse.peekBody(4096L).string());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse request(HttpRequest smartsheetRequest) throws HttpClientException {
        HttpResponse smartsheetResponse;
        boolean canRetryRequest;
        Util.throwIfNull(smartsheetRequest);
        if (smartsheetRequest.getUri() == null) {
            throw new IllegalArgumentException("A Request URI is required.");
        }
        int attempt = 0;
        long start = System.currentTimeMillis();
        InputStream bodyStream = null;
        if (smartsheetRequest.getEntity() != null && smartsheetRequest.getEntity().getContent() != null) {
            bodyStream = smartsheetRequest.getEntity().getContent();
        }
        boolean bl = canRetryRequest = bodyStream == null || bodyStream.markSupported();
        if (!canRetryRequest) {
            try {
                bodyStream = new ByteArrayInputStream(StreamUtil.readBytesFromStream(bodyStream));
                smartsheetRequest.getEntity().getContent().close();
                smartsheetRequest.getEntity().setContent(bodyStream);
                canRetryRequest = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        while (true) {
            Request.Builder builder = new Request.Builder();
            try {
                builder.url(smartsheetRequest.getUri().toURL());
            }
            catch (MalformedURLException e) {
                throw new HttpClientException("Error occurred.", e);
            }
            for (Map.Entry<String, String> entry : smartsheetRequest.getHeaders().entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
            try {
                switch (smartsheetRequest.getMethod()) {
                    case GET: {
                        builder.get();
                        break;
                    }
                    case POST: {
                        builder.post(this.getRequestBody(smartsheetRequest));
                        break;
                    }
                    case PUT: {
                        builder.put(this.getRequestBody(smartsheetRequest));
                        break;
                    }
                    case DELETE: {
                        builder.delete();
                    }
                }
            }
            catch (IOException e) {
                throw new HttpClientException("Error occurred.", e);
            }
            if (canRetryRequest && bodyStream != null) {
                bodyStream.mark((int)smartsheetRequest.getEntity().getContentLength());
            }
            try {
                Request request = builder.build();
                long startTime = System.currentTimeMillis();
                this.currentResponse = this.client.newCall(request).execute();
                long endTime = System.currentTimeMillis();
                smartsheetResponse = new HttpResponse();
                smartsheetResponse.setStatusCode(this.currentResponse.code());
                if (this.currentResponse.body().contentLength() != 0L) {
                    HttpEntity entity = new HttpEntity();
                    entity.setContentType(this.currentResponse.body().contentType().toString());
                    entity.setContentLength(this.currentResponse.body().contentLength());
                    entity.setContent(this.currentResponse.body().byteStream());
                    smartsheetResponse.setEntity(entity);
                }
                long responseTime = endTime - startTime;
                this.logRequest(request, this.currentResponse, responseTime);
                if (smartsheetResponse.getStatusCode() == 200) break;
                InputStream contentStream = smartsheetResponse.getEntity().getContent();
                if (!contentStream.markSupported()) {
                    contentStream = new ByteArrayInputStream(StreamUtil.readBytesFromStream(contentStream));
                    smartsheetResponse.getEntity().getContent().close();
                    smartsheetResponse.getEntity().setContent(contentStream);
                }
                try {
                    contentStream.mark((int)smartsheetResponse.getEntity().getContentLength());
                    long timeSpent = System.currentTimeMillis() - start;
                    if (!this.shouldRetry(++attempt, timeSpent, smartsheetResponse)) {
                        break;
                    }
                }
                finally {
                    if (bodyStream != null) {
                        bodyStream.reset();
                    }
                    contentStream.reset();
                }
                this.releaseConnection();
            }
            catch (IOException ex) {
                throw new HttpClientException("Error occurred.", ex);
            }
        }
        return smartsheetResponse;
    }

    private RequestBody getRequestBody(HttpRequest apiRequest) throws IOException {
        int sizRead;
        byte[] buffer = new byte[16384];
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        while ((sizRead = apiRequest.getEntity().getContent().read(buffer, 0, buffer.length)) != -1) {
            bao.write(buffer, 0, sizRead);
        }
        return RequestBody.create((MediaType)MEDIA_TYPE_JSON, (byte[])bao.toByteArray());
    }

    public void setMaxRetryTimeMillis(long maxRetryTimeMillis) {
        this.maxRetryTimeMillis = maxRetryTimeMillis;
    }

    public long calcBackoff(int previousAttempts, long totalElapsedTimeMillis, Error error) {
        long backoffMillis = (long)(Math.pow(2.0, previousAttempts) * 1000.0) + (long)new Random().nextInt(1000);
        if (totalElapsedTimeMillis + backoffMillis > this.maxRetryTimeMillis) {
            logger.info("Elapsed time " + totalElapsedTimeMillis + " + backoff time " + backoffMillis + " exceeds max retry time " + this.maxRetryTimeMillis + ", exiting retry loop");
            return -1L;
        }
        return backoffMillis;
    }

    public boolean shouldRetry(int previousAttempts, long totalElapsedTimeMillis, HttpResponse response) {
        Error error;
        String contentType = response.getEntity().getContentType();
        if (contentType != null && !contentType.startsWith("application/json")) {
            return false;
        }
        try {
            error = this.jsonSerializer.deserialize(Error.class, response.getEntity().getContent());
        }
        catch (IOException e) {
            return false;
        }
        switch (error.getErrorCode()) {
            case 4001: 
            case 4002: 
            case 4003: 
            case 4004: {
                break;
            }
            default: {
                return false;
            }
        }
        long backoffMillis = this.calcBackoff(previousAttempts, totalElapsedTimeMillis, error);
        if (backoffMillis < 0L) {
            return false;
        }
        logger.info("HttpError StatusCode=" + response.getStatusCode() + ": Retrying in " + backoffMillis + " milliseconds");
        try {
            Thread.sleep(backoffMillis);
        }
        catch (InterruptedException e) {
            logger.warn("sleep interrupted", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        this.client.connectionPool().evictAll();
    }

    @Override
    public void releaseConnection() {
        this.closeCurrentResponse();
    }

    private void closeCurrentResponse() {
        Response response = this.currentResponse;
        if (response != null) {
            if (response.body() != null) {
                response.body().close();
            }
            this.currentResponse = null;
        }
    }
}

