/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.models;

import com.smartsheet.api.internal.util.QueryUtil;
import java.util.HashMap;

public class PaginationParameters {
    private boolean includeAll;
    private Integer pageSize;
    private Integer page;

    public PaginationParameters() {
    }

    public PaginationParameters(boolean includeAll, Integer pageSize, Integer page) {
        this.includeAll = includeAll;
        this.pageSize = pageSize;
        this.page = page;
    }

    public boolean isIncludeAll() {
        return this.includeAll;
    }

    public PaginationParameters setIncludeAll(boolean includeAll) {
        this.includeAll = includeAll;
        return this;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public PaginationParameters setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Integer getPage() {
        return this.page;
    }

    public PaginationParameters setPage(Integer page) {
        this.page = page;
        return this;
    }

    public String toQueryString() {
        HashMap<String, Object> parameters = this.toHashMap();
        return QueryUtil.generateUrl(null, parameters);
    }

    public HashMap<String, Object> toHashMap() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("includeAll", Boolean.toString(this.includeAll));
        if (this.includeAll) {
            return parameters;
        }
        parameters.put("pageSize", this.pageSize);
        parameters.put("page", this.page);
        return parameters;
    }

    public static class PaginationParametersBuilder {
        private boolean includeAll;
        private Integer pageSize;
        private Integer page;

        public boolean isIncludeAll() {
            return this.includeAll;
        }

        public PaginationParametersBuilder setIncludeAll(boolean includeAll) {
            this.includeAll = includeAll;
            return this;
        }

        public Integer getPage() {
            return this.page;
        }

        public PaginationParametersBuilder setPage(Integer page) {
            this.page = page;
            return this;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public PaginationParametersBuilder setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public PaginationParameters build() {
            PaginationParameters pagination = new PaginationParameters();
            pagination.setIncludeAll(this.includeAll);
            pagination.setPageSize(this.pageSize);
            pagination.setPage(this.page);
            return pagination;
        }
    }
}

