/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.FavoriteResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.models.Favorite;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.enums.FavoriteType;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class FavoriteResourcesImpl
extends AbstractResources
implements FavoriteResources {
    public FavoriteResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public List<Favorite> addFavorites(List<Favorite> favorites) throws SmartsheetException {
        return this.postAndReceiveList("favorites/", favorites, Favorite.class);
    }

    @Override
    public PagedResult<Favorite> listFavorites(PaginationParameters parameters) throws SmartsheetException {
        String path = "favorites";
        if (parameters != null) {
            path = path + parameters.toQueryString();
        }
        return this.listResourcesWithWrapper(path, Favorite.class);
    }

    @Override
    public void removeFavorites(FavoriteType favoriteType, Set<Long> objectIds) throws SmartsheetException {
        String path = "favorites/" + favoriteType.toString();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (objectIds != null) {
            parameters.put("objectIds", QueryUtil.generateCommaSeparatedList(objectIds));
        }
        path = path + QueryUtil.generateUrl(null, parameters);
        this.deleteResource(path, Favorite.class);
    }
}

