/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.PassthroughResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.http.HttpEntity;
import com.smartsheet.api.internal.http.HttpMethod;
import com.smartsheet.api.internal.http.HttpRequest;
import com.smartsheet.api.internal.http.HttpResponse;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.internal.util.Util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;

public class PassthroughResourcesImpl
extends AbstractResources
implements PassthroughResources {
    public PassthroughResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public String getRequest(String endpoint, HashMap<String, Object> parameters) throws SmartsheetException {
        return this.passthroughRequest(HttpMethod.GET, endpoint, null, parameters);
    }

    @Override
    public String postRequest(String endpoint, String payload, HashMap<String, Object> parameters) throws SmartsheetException {
        Util.throwIfNull(payload);
        return this.passthroughRequest(HttpMethod.POST, endpoint, payload, parameters);
    }

    @Override
    public String putRequest(String endpoint, String payload, HashMap<String, Object> parameters) throws SmartsheetException {
        Util.throwIfNull(payload);
        return this.passthroughRequest(HttpMethod.PUT, endpoint, payload, parameters);
    }

    @Override
    public String deleteRequest(String endpoint) throws SmartsheetException {
        return this.passthroughRequest(HttpMethod.DELETE, endpoint, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String passthroughRequest(HttpMethod method, String endpoint, String payload, HashMap<String, Object> parameters) throws SmartsheetException {
        Util.throwIfNull(endpoint);
        Util.throwIfEmpty(endpoint);
        if (parameters != null) {
            endpoint = endpoint + QueryUtil.generateUrl(null, parameters);
        }
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve(endpoint), method);
        if (payload != null) {
            HttpEntity entity = new HttpEntity();
            entity.setContentType("application/json");
            entity.setContent(new ByteArrayInputStream(payload.getBytes()));
            entity.setContentLength(payload.getBytes().length);
            request.setEntity(entity);
        }
        String res = null;
        try {
            HttpResponse response = this.smartsheet.getHttpClient().request(request);
            switch (response.getStatusCode()) {
                case 200: {
                    try {
                        String readLine;
                        StringBuilder sb = new StringBuilder();
                        BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                        while ((readLine = br.readLine()) != null) {
                            sb.append(readLine);
                        }
                        br.close();
                        res = sb.toString();
                        return res;
                    }
                    catch (IOException e) {
                        res = null;
                        return res;
                    }
                }
                default: {
                    this.handleError(response);
                    return res;
                }
            }
        }
        finally {
            this.smartsheet.getHttpClient().releaseConnection();
        }
    }
}

