/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.SheetUpdateRequestResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.SentUpdateRequest;
import com.smartsheet.api.models.UpdateRequest;
import java.util.HashMap;

public class SheetUpdateRequestResourcesImpl
extends AbstractResources
implements SheetUpdateRequestResources {
    public SheetUpdateRequestResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public PagedResult<UpdateRequest> listUpdateRequests(long sheetId, PaginationParameters paging) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/updaterequests";
        HashMap<String, Object> parameters = new HashMap();
        if (paging != null) {
            parameters = paging.toHashMap();
        }
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper(path, UpdateRequest.class);
    }

    @Override
    public UpdateRequest getUpdateRequest(long sheetId, long updateRequestId) throws SmartsheetException {
        return this.getResource("sheets/" + sheetId + "/updaterequests/" + updateRequestId, UpdateRequest.class);
    }

    @Override
    public UpdateRequest createUpdateRequest(long sheetId, UpdateRequest updateRequest) throws SmartsheetException {
        return this.createResource("sheets/" + sheetId + "/updaterequests", UpdateRequest.class, updateRequest);
    }

    @Override
    public void deleteUpdateRequest(long sheetId, long updateRequestId) throws SmartsheetException {
        this.deleteResource("sheets/" + sheetId + "/updaterequests/" + updateRequestId, UpdateRequest.class);
    }

    @Override
    public UpdateRequest updateUpdateRequest(long sheetId, UpdateRequest updateRequest) throws SmartsheetException {
        return this.updateResource("sheets/" + sheetId + "/updaterequests/" + updateRequest.getId(), UpdateRequest.class, updateRequest);
    }

    @Override
    public PagedResult<SentUpdateRequest> listSentUpdateRequests(long sheetId, PaginationParameters paging) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/sentupdaterequests";
        HashMap<String, Object> parameters = new HashMap();
        if (paging != null) {
            parameters = paging.toHashMap();
        }
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper(path, SentUpdateRequest.class);
    }

    @Override
    public SentUpdateRequest getSentUpdateRequest(long sheetId, long sentUpdateRequestId) throws SmartsheetException {
        return this.getResource("sheets/" + sheetId + "/sentupdaterequests/" + sentUpdateRequestId, SentUpdateRequest.class);
    }

    @Override
    public void deleteSentUpdateRequest(long sheetId, long sentUpdateRequestId) throws SmartsheetException {
        this.deleteResource("sheets/" + sheetId + "/sentupdaterequests/" + sentUpdateRequestId, SentUpdateRequest.class);
    }
}

