/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.WebhookResources;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.http.HttpMethod;
import com.smartsheet.api.internal.http.HttpRequest;
import com.smartsheet.api.internal.http.HttpResponse;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.Webhook;
import com.smartsheet.api.models.WebhookSharedSecret;
import java.io.IOException;
import java.util.HashMap;

public class WebhookResourcesImpl
extends AbstractResources
implements WebhookResources {
    public WebhookResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public PagedResult<Webhook> listWebhooks(PaginationParameters paging) throws SmartsheetException {
        String path = "webhooks";
        HashMap<String, Object> parameters = new HashMap();
        if (paging != null) {
            parameters = paging.toHashMap();
        }
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper(path, Webhook.class);
    }

    @Override
    public Webhook getWebhook(long webhookId) throws SmartsheetException {
        return this.getResource("webhooks/" + webhookId, Webhook.class);
    }

    @Override
    public Webhook createWebhook(Webhook webhook) throws SmartsheetException {
        return this.createResource("webhooks", Webhook.class, webhook);
    }

    @Override
    public Webhook updateWebhook(Webhook webhook) throws SmartsheetException {
        return this.updateResource("webhooks/" + webhook.getId(), Webhook.class, webhook);
    }

    @Override
    public void deleteWebhook(long webhookId) throws SmartsheetException {
        this.deleteResource("webhooks/" + webhookId, Webhook.class);
    }

    @Override
    public WebhookSharedSecret resetSharedSecret(long webhookId) throws SmartsheetException {
        HttpRequest request = this.createHttpRequest(this.getSmartsheet().getBaseURI().resolve("webhooks/" + webhookId + "/resetsharedsecret"), HttpMethod.POST);
        HttpResponse response = this.getSmartsheet().getHttpClient().request(request);
        WebhookSharedSecret secret = null;
        switch (response.getStatusCode()) {
            case 200: {
                try {
                    secret = this.smartsheet.getJsonSerializer().deserialize(WebhookSharedSecret.class, response.getEntity().getContent());
                    break;
                }
                catch (JsonParseException e) {
                    throw new SmartsheetException((Exception)((Object)e));
                }
                catch (JsonMappingException e) {
                    throw new SmartsheetException((Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new SmartsheetException(e);
                }
            }
            default: {
                this.handleError(response);
            }
        }
        this.getSmartsheet().getHttpClient().releaseConnection();
        return secret;
    }
}

