/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.smartsheet.api.models.Error;
import com.smartsheet.api.models.ErrorDetail;
import java.io.IOException;
import java.util.List;

public class ErrorDeserializer
extends JsonDeserializer<Error> {
    public Error deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Error error = new Error();
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            JsonNode detail;
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            if (node.get("errorCode") != null) {
                error.setErrorCode(node.get("errorCode").asInt());
            }
            if (node.get("message") != null) {
                error.setMessage(node.get("message").asText());
            }
            if (node.get("refId") != null) {
                error.setRefId(node.get("refId").asText());
            }
            if ((detail = node.get("detail")) != null) {
                if (detail.isArray()) {
                    String _as_text = detail.toString();
                    List details = (List)mapper.readValue(_as_text, (TypeReference)new TypeReference<List<ErrorDetail>>(){});
                    error.setDetail(details);
                } else {
                    error.setDetail(mapper.treeToValue((TreeNode)detail, ErrorDetail.class));
                }
            }
            return error;
        }
        return null;
    }
}

