/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.models;

import com.smartsheet.api.models.CellLink;
import com.smartsheet.api.models.Hyperlink;
import com.smartsheet.api.models.Image;
import com.smartsheet.api.models.ObjectValue;
import com.smartsheet.api.models.enums.ColumnType;
import com.smartsheet.api.models.format.Format;
import java.util.ArrayList;
import java.util.List;

public class Cell {
    private ColumnType columnType;
    private ColumnType type;
    private Object value;
    private ObjectValue objectValue;
    private String displayValue;
    private Long columnId;
    private Long rowId;
    private Hyperlink hyperlink;
    private CellLink linkInFromCell;
    private List<CellLink> linksOutToCells;
    private String conditionalFormat;
    private Image image;
    private String formula;
    private Boolean strict;
    private Format format;
    private Boolean overrideValidation;

    public Cell() {
    }

    public Cell(Long id) {
        this.columnId = id;
    }

    public ColumnType getColumnType() {
        return this.type;
    }

    public Cell setColumnType(ColumnType columnType) {
        this.type = columnType;
        return this;
    }

    public ColumnType getType() {
        return this.type;
    }

    public Cell setType(ColumnType type) {
        this.type = type;
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    public Cell setValue(Object value) {
        this.value = value;
        return this;
    }

    public ObjectValue getObjectValue() {
        return this.objectValue;
    }

    public Cell setObjectValue(ObjectValue objectValue) {
        this.objectValue = objectValue;
        return this;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public Cell setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
        return this;
    }

    public Long getColumnId() {
        return this.columnId;
    }

    public Cell setColumnId(Long columnId) {
        this.columnId = columnId;
        return this;
    }

    public Long getRowId() {
        return this.rowId;
    }

    public Cell setRowId(Long rowId) {
        this.rowId = rowId;
        return this;
    }

    public String getFormula() {
        return this.formula;
    }

    public Cell setFormula(String formula) {
        this.formula = formula;
        return this;
    }

    public Boolean getStrict() {
        return this.strict;
    }

    public Cell setStrict(Boolean strict) {
        this.strict = strict;
        return this;
    }

    public Format getFormat() {
        return this.format;
    }

    public Cell setFormat(Format format) {
        this.format = format;
        return this;
    }

    public Hyperlink getHyperlink() {
        return this.hyperlink;
    }

    public Cell setHyperlink(Hyperlink hyperlink) {
        this.hyperlink = hyperlink;
        return this;
    }

    public CellLink getLinkInFromCell() {
        return this.linkInFromCell;
    }

    public Cell setLinkInFromCell(CellLink linkInFromCell) {
        this.linkInFromCell = linkInFromCell;
        return this;
    }

    public List<CellLink> getLinksOutToCells() {
        return this.linksOutToCells;
    }

    public Cell setLinksOutToCells(List<CellLink> linksOutToCells) {
        this.linksOutToCells = linksOutToCells;
        return this;
    }

    public String getConditionalFormat() {
        return this.conditionalFormat;
    }

    public Cell setConditionalFormat(String conditionalFormat) {
        this.conditionalFormat = conditionalFormat;
        return this;
    }

    public Image getImage() {
        return this.image;
    }

    public Cell setImage(Image image) {
        this.image = image;
        return this;
    }

    public Boolean getOverrideValidation() {
        return this.overrideValidation;
    }

    public Cell setOverrideValidation(Boolean overrideValidation) {
        this.overrideValidation = overrideValidation;
        return this;
    }

    public static class UpdateRowCellsBuilder {
        List<Cell> cells = new ArrayList<Cell>();

        public UpdateRowCellsBuilder addCell(Long columnId, Object value, Boolean strict, Hyperlink hyperlink, CellLink linkInFromCell) {
            Cell cell = new Cell().setColumnId(columnId).setValue(value).setStrict(strict).setHyperlink(hyperlink).setLinkInFromCell(linkInFromCell);
            this.cells.add(cell);
            return this;
        }

        public UpdateRowCellsBuilder addCell(Long columnId, Object value, Boolean strict, Hyperlink hyperlink, CellLink linkInFromCell, Boolean overrideValidation) {
            Cell cell = new Cell().setColumnId(columnId).setValue(value).setStrict(strict).setHyperlink(hyperlink).setLinkInFromCell(linkInFromCell).setOverrideValidation(overrideValidation);
            this.cells.add(cell);
            return this;
        }

        public List<Cell> getCells() {
            return this.cells;
        }

        public UpdateRowCellsBuilder addCell(Long columnId, Object value) {
            this.addCell(columnId, value, true, null, null);
            return this;
        }

        public List<Cell> build() {
            return this.cells;
        }
    }

    public static class AddRowCellsBuilder {
        List<Cell> cells = new ArrayList<Cell>();

        public AddRowCellsBuilder addCell(Long columnId, Object value, Boolean strict, Hyperlink hyperlink, CellLink linkInFromCell) {
            Cell cell = new Cell().setColumnId(columnId).setValue(value).setStrict(strict).setHyperlink(hyperlink).setLinkInFromCell(linkInFromCell);
            this.cells.add(cell);
            return this;
        }

        public AddRowCellsBuilder addCell(Long columnId, Object value, Boolean strict, Hyperlink hyperlink, CellLink linkInFromCell, Boolean overrideValidation) {
            Cell cell = new Cell().setColumnId(columnId).setValue(value).setStrict(strict).setHyperlink(hyperlink).setLinkInFromCell(linkInFromCell).setOverrideValidation(overrideValidation);
            this.cells.add(cell);
            return this;
        }

        public List<Cell> getCells() {
            return this.cells;
        }

        public AddRowCellsBuilder addCell(Long columnId, Object value) {
            this.addCell(columnId, value, true, null, null);
            return this;
        }

        public List<Cell> build() {
            return this.cells;
        }
    }
}

