/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api;

import com.smartsheet.api.Smartsheet;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.http.DefaultCalcBackoff;
import com.smartsheet.api.internal.http.HttpClient;
import com.smartsheet.api.internal.json.JsonSerializer;
import com.smartsheet.api.retry.CalcBackoff;

public class SmartsheetBuilder {
    private HttpClient httpClient;
    private JsonSerializer jsonSerializer;
    private String baseURI;
    private String accessToken;
    private String assumedUser;
    private CalcBackoff calcBackoff = null;
    private String changeAgent;
    public static final String DEFAULT_BASE_URI = "https://api.smartsheet.com/2.0/";

    public SmartsheetBuilder setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public SmartsheetBuilder setJsonSerializer(JsonSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
        return this;
    }

    public SmartsheetBuilder setBaseURI(String baseURI) {
        this.baseURI = baseURI;
        return this;
    }

    public SmartsheetBuilder setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public SmartsheetBuilder setAssumedUser(String assumedUser) {
        this.assumedUser = assumedUser;
        return this;
    }

    public SmartsheetBuilder setMaxRetryTimeMillis(long maxRetryTimeMillis) {
        this.calcBackoff = new DefaultCalcBackoff(maxRetryTimeMillis);
        return this;
    }

    public SmartsheetBuilder setUserCalcBackoff(CalcBackoff calcBackoff) {
        this.calcBackoff = calcBackoff;
        return this;
    }

    public SmartsheetBuilder setChangeAgent(String changeAgent) {
        this.changeAgent = changeAgent;
        return this;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public JsonSerializer getJsonSerializer() {
        return this.jsonSerializer;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getAssumedUser() {
        return this.assumedUser;
    }

    public static String getDefaultBaseUri() {
        return DEFAULT_BASE_URI;
    }

    public String getChangeAgent() {
        return this.changeAgent;
    }

    public Smartsheet build() {
        if (this.baseURI == null) {
            this.baseURI = DEFAULT_BASE_URI;
        }
        if (this.accessToken == null) {
            this.accessToken = System.getenv("SMARTSHEET_ACCESS_TOKEN");
        }
        SmartsheetImpl smartsheet = new SmartsheetImpl(this.baseURI, this.accessToken, this.httpClient, this.jsonSerializer, this.changeAgent);
        if (this.calcBackoff != null) {
            smartsheet.setCalcBackoff(this.calcBackoff);
        }
        if (this.assumedUser != null) {
            smartsheet.setAssumedUser(this.assumedUser);
        }
        return smartsheet;
    }
}

