/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.CommentAttachmentResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.Attachment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class CommentAttachmentResourcesImpl
extends AbstractResources
implements CommentAttachmentResources {
    public CommentAttachmentResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public Attachment attachUrl(long sheetId, long commentId, Attachment attachment) throws SmartsheetException {
        return this.createResource("sheets/" + sheetId + "/comments/" + commentId + "/attachments", Attachment.class, attachment);
    }

    @Override
    public Attachment attachFile(long sheetId, long commentId, File file, String contentType) throws FileNotFoundException, SmartsheetException {
        Util.throwIfNull(sheetId, commentId, file, contentType);
        Util.throwIfEmpty(contentType);
        return this.attachFileWithSimpleUpload(sheetId, commentId, new FileInputStream(file), contentType, file.length(), file.getName());
    }

    private Attachment attachFileWithSimpleUpload(long sheetId, long commentId, InputStream inputStream, String contentType, long contentLength, String attachmentName) throws SmartsheetException {
        Util.throwIfNull((Object)inputStream, (Object)contentType);
        return super.attachFile("sheets/" + sheetId + "/comments/" + commentId + "/attachments", inputStream, contentType, contentLength, attachmentName);
    }
}

