/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.SearchResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.SearchResult;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class SearchResourcesImpl
extends AbstractResources
implements SearchResources {
    public SearchResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public SearchResult search(String query) throws SmartsheetException {
        Util.throwIfNull(query);
        Util.throwIfEmpty(query);
        try {
            return this.getResource("search?query=" + URLEncoder.encode(query, "utf-8"), SearchResult.class);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SearchResult searchSheet(long sheetId, String query) throws SmartsheetException {
        Util.throwIfNull(query);
        Util.throwIfEmpty(query);
        try {
            return this.getResource("search/sheets/" + sheetId + "?query=" + URLEncoder.encode(query, "utf-8"), SearchResult.class);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

