/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.ShareResources;
import com.smartsheet.api.SheetAttachmentResources;
import com.smartsheet.api.SheetColumnResources;
import com.smartsheet.api.SheetCommentResources;
import com.smartsheet.api.SheetDiscussionResources;
import com.smartsheet.api.SheetResources;
import com.smartsheet.api.SheetRowResources;
import com.smartsheet.api.SheetUpdateRequestResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.ShareResourcesImpl;
import com.smartsheet.api.internal.SheetAttachmentResourcesImpl;
import com.smartsheet.api.internal.SheetColumnResourcesImpl;
import com.smartsheet.api.internal.SheetCommentResourcesImpl;
import com.smartsheet.api.internal.SheetDiscussionResourcesImpl;
import com.smartsheet.api.internal.SheetRowResourcesImpl;
import com.smartsheet.api.internal.SheetUpdateRequestResourcesImpl;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.http.HttpMethod;
import com.smartsheet.api.internal.http.HttpRequest;
import com.smartsheet.api.internal.http.HttpResponse;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.ContainerDestination;
import com.smartsheet.api.models.MultiRowEmail;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.Sheet;
import com.smartsheet.api.models.SheetEmail;
import com.smartsheet.api.models.SheetPublish;
import com.smartsheet.api.models.UpdateRequest;
import com.smartsheet.api.models.enums.ObjectExclusion;
import com.smartsheet.api.models.enums.PaperSize;
import com.smartsheet.api.models.enums.SheetCopyInclusion;
import com.smartsheet.api.models.enums.SheetInclusion;
import com.smartsheet.api.models.enums.SheetTemplateInclusion;
import com.smartsheet.api.models.enums.SourceInclusion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;

public class SheetResourcesImpl
extends AbstractResources
implements SheetResources {
    private static final int BUFFER_SIZE = 4098;
    private ShareResources shares;
    private SheetRowResources rows;
    private SheetColumnResources columns;
    private SheetAttachmentResources attachments;
    private SheetDiscussionResources discussions;
    private SheetCommentResources comments;
    private SheetUpdateRequestResources updateRequests;

    public SheetResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
        this.shares = new ShareResourcesImpl(smartsheet, "sheets");
        this.rows = new SheetRowResourcesImpl(smartsheet);
        this.columns = new SheetColumnResourcesImpl(smartsheet);
        this.attachments = new SheetAttachmentResourcesImpl(smartsheet);
        this.discussions = new SheetDiscussionResourcesImpl(smartsheet);
        this.comments = new SheetCommentResourcesImpl(smartsheet);
        this.updateRequests = new SheetUpdateRequestResourcesImpl(smartsheet);
    }

    @Override
    public PagedResult<Sheet> listSheets(EnumSet<SourceInclusion> includes, PaginationParameters pagination) throws SmartsheetException {
        return this.listSheets(includes, pagination, null);
    }

    @Override
    public PagedResult<Sheet> listSheets(EnumSet<SourceInclusion> includes, PaginationParameters pagination, Date modifiedSince) throws SmartsheetException {
        String path = "sheets";
        HashMap<Object, Object> parameters = new HashMap();
        if (pagination != null) {
            parameters = pagination.toHashMap();
        }
        if (modifiedSince != null) {
            String isoDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(modifiedSince);
            parameters.put("modifiedSince", isoDate);
        }
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper(path, Sheet.class);
    }

    @Override
    @Deprecated
    public PagedResult<Sheet> listOrganizationSheets(PaginationParameters parameters) throws SmartsheetException {
        String path = "users/sheets";
        if (parameters != null) {
            path = path + parameters.toQueryString();
        }
        return this.listResourcesWithWrapper(path, Sheet.class);
    }

    @Override
    public Sheet getSheet(long id, EnumSet<SheetInclusion> includes, EnumSet<ObjectExclusion> excludes, Set<Long> rowIds, Set<Integer> rowNumbers, Set<Long> columnIds, Integer pageSize, Integer page) throws SmartsheetException {
        String path = "sheets/" + id;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        parameters.put("exclude", QueryUtil.generateCommaSeparatedList(excludes));
        parameters.put("rowIds", QueryUtil.generateCommaSeparatedList(rowIds));
        parameters.put("rowNumbers", QueryUtil.generateCommaSeparatedList(rowNumbers));
        parameters.put("columnIds", QueryUtil.generateCommaSeparatedList(columnIds));
        parameters.put("pageSize", pageSize);
        parameters.put("page", page);
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.getResource(path, Sheet.class);
    }

    @Override
    public void getSheetAsExcel(long id, OutputStream outputStream) throws SmartsheetException {
        this.getSheetAsFile(id, null, outputStream, "application/vnd.ms-excel");
    }

    @Override
    public void getSheetAsPDF(long id, OutputStream outputStream, PaperSize paperSize) throws SmartsheetException {
        this.getSheetAsFile(id, paperSize, outputStream, "application/pdf");
    }

    @Override
    public Sheet createSheet(Sheet sheet) throws SmartsheetException {
        return this.createResource("sheets", Sheet.class, sheet);
    }

    @Override
    public Sheet createSheetFromTemplate(Sheet sheet, EnumSet<SheetTemplateInclusion> includes) throws SmartsheetException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        String path = QueryUtil.generateUrl("sheets", parameters);
        return this.createResource(path, Sheet.class, sheet);
    }

    @Override
    public Sheet createSheetInFolder(long folderId, Sheet sheet) throws SmartsheetException {
        return this.createResource("folders/" + folderId + "/sheets", Sheet.class, sheet);
    }

    @Override
    public Sheet createSheetInFolderFromTemplate(long folderId, Sheet sheet, EnumSet<SheetTemplateInclusion> includes) throws SmartsheetException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        String path = QueryUtil.generateUrl("folders/" + folderId + "/sheets", parameters);
        return this.createResource(path, Sheet.class, sheet);
    }

    @Override
    public Sheet createSheetInWorkspace(long workspaceId, Sheet sheet) throws SmartsheetException {
        return this.createResource("workspaces/" + workspaceId + "/sheets", Sheet.class, sheet);
    }

    @Override
    public Sheet createSheetInWorkspaceFromTemplate(long workspaceId, Sheet sheet, EnumSet<SheetTemplateInclusion> includes) throws SmartsheetException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        String path = QueryUtil.generateUrl("workspaces/" + workspaceId + "/sheets", parameters);
        return this.createResource(path, Sheet.class, sheet);
    }

    @Override
    public void deleteSheet(long id) throws SmartsheetException {
        this.deleteResource("sheets/" + id, Sheet.class);
    }

    @Override
    public Sheet updateSheet(Sheet sheet) throws SmartsheetException {
        return this.updateResource("sheets/" + sheet.getId(), Sheet.class, sheet);
    }

    @Override
    public int getSheetVersion(long id) throws SmartsheetException {
        return this.getResource("sheets/" + id + "/version", Sheet.class).getVersion();
    }

    @Override
    public void sendSheet(long id, SheetEmail email) throws SmartsheetException {
        this.createResource("sheets/" + id + "/emails", SheetEmail.class, email);
    }

    @Override
    public void getSheetAsCSV(long id, OutputStream outputStream) throws SmartsheetException {
        this.getSheetAsFile(id, null, outputStream, "text/csv");
    }

    @Override
    public ShareResources shareResources() {
        return this.shares;
    }

    @Override
    public SheetRowResources rowResources() {
        return this.rows;
    }

    @Override
    public SheetColumnResources columnResources() {
        return this.columns;
    }

    @Override
    public SheetAttachmentResources attachmentResources() {
        return this.attachments;
    }

    @Override
    public SheetDiscussionResources discussionResources() {
        return this.discussions;
    }

    @Override
    public SheetCommentResources commentResources() {
        return this.comments;
    }

    @Override
    public SheetUpdateRequestResources updateRequestResources() {
        return this.updateRequests;
    }

    @Override
    public SheetPublish getPublishStatus(long id) throws SmartsheetException {
        return this.getResource("sheets/" + id + "/publish", SheetPublish.class);
    }

    @Override
    public SheetPublish updatePublishStatus(long id, SheetPublish publish) throws SmartsheetException {
        return this.updateResource("sheets/" + id + "/publish", SheetPublish.class, publish);
    }

    private void getSheetAsFile(long id, PaperSize paperSize, OutputStream outputStream, String contentType) throws SmartsheetException {
        Util.throwIfNull((Object)outputStream, (Object)contentType);
        String path = "sheets/" + id;
        if (paperSize != null) {
            path = path + "?paperSize=" + (Object)((Object)paperSize);
        }
        HttpRequest request = this.createHttpRequest(this.getSmartsheet().getBaseURI().resolve(path), HttpMethod.GET);
        request.getHeaders().put("Accept", contentType);
        HttpResponse response = this.getSmartsheet().getHttpClient().request(request);
        switch (response.getStatusCode()) {
            case 200: {
                try {
                    SheetResourcesImpl.copyStream(response.getEntity().getContent(), outputStream);
                    break;
                }
                catch (IOException e) {
                    throw new SmartsheetException(e);
                }
            }
            default: {
                this.handleError(response);
            }
        }
        this.getSmartsheet().getHttpClient().releaseConnection();
    }

    @Override
    public Sheet copySheet(long sheetId, ContainerDestination containerDestination, EnumSet<SheetCopyInclusion> includes) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/copy";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.createResource(path, Sheet.class, containerDestination);
    }

    @Override
    public Sheet moveSheet(long sheetId, ContainerDestination containerDestination) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/move";
        return this.createResource(path, Sheet.class, containerDestination);
    }

    @Override
    public UpdateRequest createUpdateRequest(long sheetId, MultiRowEmail email) throws SmartsheetException {
        return this.createResource("sheets/" + sheetId + "/updaterequests", UpdateRequest.class, email);
    }

    public static void copyStream(InputStream input, OutputStream output) throws IOException {
        int len;
        byte[] buffer = new byte[4098];
        while ((len = input.read(buffer)) != -1) {
            output.write(buffer, 0, len);
        }
    }
}

