/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.AttachmentResources;
import com.smartsheet.api.ColumnResources;
import com.smartsheet.api.CommentResources;
import com.smartsheet.api.ContactResources;
import com.smartsheet.api.FavoriteResources;
import com.smartsheet.api.FolderResources;
import com.smartsheet.api.GroupResources;
import com.smartsheet.api.HomeResources;
import com.smartsheet.api.ImageUrlResources;
import com.smartsheet.api.ReportResources;
import com.smartsheet.api.SearchResources;
import com.smartsheet.api.ServerInfoResources;
import com.smartsheet.api.SheetResources;
import com.smartsheet.api.SightResources;
import com.smartsheet.api.Smartsheet;
import com.smartsheet.api.TemplateResources;
import com.smartsheet.api.TokenResources;
import com.smartsheet.api.Trace;
import com.smartsheet.api.UserResources;
import com.smartsheet.api.WebhookResources;
import com.smartsheet.api.WorkspaceResources;
import com.smartsheet.api.internal.ContactResourcesImpl;
import com.smartsheet.api.internal.FavoriteResourcesImpl;
import com.smartsheet.api.internal.FolderResourcesImpl;
import com.smartsheet.api.internal.GroupResourcesImpl;
import com.smartsheet.api.internal.HomeResourcesImpl;
import com.smartsheet.api.internal.ImageUrlResourcesImpl;
import com.smartsheet.api.internal.ReportResourcesImpl;
import com.smartsheet.api.internal.SearchResourcesImpl;
import com.smartsheet.api.internal.ServerInfoResourcesImpl;
import com.smartsheet.api.internal.SheetResourcesImpl;
import com.smartsheet.api.internal.SightResourcesImpl;
import com.smartsheet.api.internal.TemplateResourcesImpl;
import com.smartsheet.api.internal.TokenResourcesImpl;
import com.smartsheet.api.internal.UserResourcesImpl;
import com.smartsheet.api.internal.WebhookResourcesImpl;
import com.smartsheet.api.internal.WorkspaceResourcesImpl;
import com.smartsheet.api.internal.http.DefaultHttpClient;
import com.smartsheet.api.internal.http.DefaultShouldRetry;
import com.smartsheet.api.internal.http.HttpClient;
import com.smartsheet.api.internal.json.JacksonJsonSerializer;
import com.smartsheet.api.internal.json.JsonSerializer;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.retry.CalcBackoff;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.impl.client.HttpClients;

public class SmartsheetImpl
implements Smartsheet {
    private final HttpClient httpClient;
    private JsonSerializer jsonSerializer;
    private URI baseURI;
    private DefaultShouldRetry defaultShouldRetry = null;
    private AtomicReference<HomeResources> home;
    private AtomicReference<WorkspaceResources> workspaces;
    private AtomicReference<FolderResources> folders;
    private AtomicReference<TemplateResources> templates;
    private AtomicReference<SheetResources> sheets;
    private AtomicReference<SightResources> sights;
    private AtomicReference<UserResources> users;
    private AtomicReference<GroupResources> groups;
    private AtomicReference<SearchResources> search;
    private AtomicReference<ReportResources> reports;
    private final AtomicReference<String> assumedUser;
    private final AtomicReference<String> accessToken;
    private final AtomicReference<String> changeAgent;
    private final AtomicReference<ServerInfoResources> serverInfo;
    private final AtomicReference<FavoriteResources> favorites;
    private final AtomicReference<TokenResources> tokens;
    private final AtomicReference<ContactResources> contacts;
    private final AtomicReference<ImageUrlResources> imageUrls;
    private final AtomicReference<WebhookResources> webhooks;

    public SmartsheetImpl(String baseURI, String accessToken, HttpClient httpClient, JsonSerializer jsonSerializer) {
        this(baseURI, accessToken, httpClient, jsonSerializer, null);
    }

    public SmartsheetImpl(String baseURI, String accessToken, HttpClient httpClient, JsonSerializer jsonSerializer, String changeAgent) {
        Util.throwIfNull(baseURI);
        Util.throwIfEmpty(baseURI);
        this.baseURI = URI.create(baseURI);
        if (httpClient == null) {
            this.defaultShouldRetry = new DefaultShouldRetry(jsonSerializer);
            this.httpClient = new DefaultHttpClient(HttpClients.createDefault(), this.defaultShouldRetry);
        } else {
            this.httpClient = httpClient;
        }
        this.jsonSerializer = jsonSerializer == null ? new JacksonJsonSerializer() : jsonSerializer;
        this.home = new AtomicReference();
        this.workspaces = new AtomicReference();
        this.folders = new AtomicReference();
        this.templates = new AtomicReference();
        this.sheets = new AtomicReference();
        this.sights = new AtomicReference();
        this.favorites = new AtomicReference();
        this.users = new AtomicReference();
        this.groups = new AtomicReference();
        this.search = new AtomicReference();
        this.assumedUser = new AtomicReference();
        this.accessToken = new AtomicReference<String>(accessToken);
        this.changeAgent = new AtomicReference<String>(changeAgent);
        this.reports = new AtomicReference();
        this.serverInfo = new AtomicReference();
        this.tokens = new AtomicReference();
        this.contacts = new AtomicReference();
        this.imageUrls = new AtomicReference();
        this.webhooks = new AtomicReference();
    }

    protected void finalize() throws IOException {
        this.httpClient.close();
    }

    HttpClient getHttpClient() {
        return this.httpClient;
    }

    JsonSerializer getJsonSerializer() {
        return this.jsonSerializer;
    }

    URI getBaseURI() {
        return this.baseURI;
    }

    String getAssumedUser() {
        return this.assumedUser.get();
    }

    String getAccessToken() {
        return this.accessToken.get();
    }

    String getChangeAgent() {
        return this.changeAgent.get();
    }

    @Override
    public HomeResources homeResources() {
        if (this.home.get() == null) {
            this.home.compareAndSet(null, new HomeResourcesImpl(this));
        }
        return this.home.get();
    }

    @Override
    public WorkspaceResources workspaceResources() {
        if (this.workspaces.get() == null) {
            this.workspaces.compareAndSet(null, new WorkspaceResourcesImpl(this));
        }
        return this.workspaces.get();
    }

    @Override
    public FolderResources folderResources() {
        if (this.folders.get() == null) {
            this.folders.compareAndSet(null, new FolderResourcesImpl(this));
        }
        return this.folders.get();
    }

    @Override
    public TemplateResources templateResources() {
        if (this.templates.get() == null) {
            this.templates.compareAndSet(null, new TemplateResourcesImpl(this));
        }
        return this.templates.get();
    }

    @Override
    public SheetResources sheetResources() {
        if (this.sheets.get() == null) {
            this.sheets.compareAndSet(null, new SheetResourcesImpl(this));
        }
        return this.sheets.get();
    }

    @Override
    public SightResources sightResources() {
        if (this.sights.get() == null) {
            this.sights.compareAndSet(null, new SightResourcesImpl(this));
        }
        return this.sights.get();
    }

    @Override
    public FavoriteResources favoriteResources() {
        if (this.favorites.get() == null) {
            this.favorites.compareAndSet(null, new FavoriteResourcesImpl(this));
        }
        return this.favorites.get();
    }

    @Override
    public UserResources userResources() {
        if (this.users.get() == null) {
            this.users.compareAndSet(null, new UserResourcesImpl(this));
        }
        return this.users.get();
    }

    @Override
    public GroupResources groupResources() {
        if (this.groups.get() == null) {
            this.groups.compareAndSet(null, new GroupResourcesImpl(this));
        }
        return this.groups.get();
    }

    @Override
    public SearchResources searchResources() {
        if (this.search.get() == null) {
            this.search.compareAndSet(null, new SearchResourcesImpl(this));
        }
        return this.search.get();
    }

    @Override
    public ReportResources reportResources() {
        if (this.reports.get() == null) {
            this.reports.compareAndSet(null, new ReportResourcesImpl(this));
        }
        return this.reports.get();
    }

    @Override
    public ServerInfoResources serverInfoResources() {
        if (this.serverInfo.get() == null) {
            this.serverInfo.compareAndSet(null, new ServerInfoResourcesImpl(this));
        }
        return this.serverInfo.get();
    }

    @Override
    public TokenResources tokenResources() {
        if (this.tokens.get() == null) {
            this.tokens.compareAndSet(null, new TokenResourcesImpl(this));
        }
        return this.tokens.get();
    }

    @Override
    public ContactResources contactResources() {
        if (this.contacts.get() == null) {
            this.contacts.compareAndSet(null, new ContactResourcesImpl(this));
        }
        return this.contacts.get();
    }

    @Override
    public ImageUrlResources imageUrlResources() {
        if (this.imageUrls.get() == null) {
            this.imageUrls.compareAndSet(null, new ImageUrlResourcesImpl(this));
        }
        return this.imageUrls.get();
    }

    @Override
    public WebhookResources webhookResources() {
        if (this.webhooks.get() == null) {
            this.webhooks.compareAndSet(null, new WebhookResourcesImpl(this));
        }
        return this.webhooks.get();
    }

    @Override
    public void setAssumedUser(String assumedUser) {
        this.assumedUser.set(assumedUser);
    }

    @Override
    public void setAccessToken(String accessToken) {
        this.accessToken.set(accessToken);
    }

    public void setCalcBackoff(CalcBackoff calcBackoff) {
        if (this.defaultShouldRetry != null) {
            this.defaultShouldRetry.setCalcBackoff(calcBackoff);
        }
    }

    @Override
    public void setTraces(Trace ... traces) {
        this.getHttpClient().setTraces(traces);
    }

    @Override
    public void setTracePrettyPrint(boolean pretty) {
        this.getHttpClient().setTracePrettyPrint(pretty);
    }

    @Override
    @Deprecated
    public ColumnResources columns() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void rows() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public AttachmentResources attachments() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void discussions() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public CommentResources comments() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void users() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void groups() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void search() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void home() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void workspaces() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void folders() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void templates() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void sheets() {
        throw new UnsupportedOperationException();
    }
}

