/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal.http;

import com.smartsheet.api.models.Error;
import com.smartsheet.api.retry.CalcBackoff;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCalcBackoff
implements CalcBackoff {
    private long maxRetryTimeMillis;
    private static final Logger logger = LoggerFactory.getLogger(DefaultCalcBackoff.class);

    public DefaultCalcBackoff(long maxRetryTimeMillis) {
        this.maxRetryTimeMillis = maxRetryTimeMillis;
    }

    @Override
    public long calcBackoff(int previousAttempts, long totalElapsedTimeMillis, Error error) {
        long backoffMillis = (long)(Math.pow(2.0, previousAttempts) * 1000.0) + (long)new Random().nextInt(1000);
        if (totalElapsedTimeMillis + backoffMillis > this.maxRetryTimeMillis) {
            logger.info("Elapsed time " + totalElapsedTimeMillis + " + backoff time " + backoffMillis + " exceeds max retry time " + this.maxRetryTimeMillis + ", exiting retry loop");
            return -1L;
        }
        return backoffMillis;
    }
}

