/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal.http;

import com.smartsheet.api.Trace;
import com.smartsheet.api.internal.http.DefaultShouldRetry;
import com.smartsheet.api.internal.http.HttpClient;
import com.smartsheet.api.internal.http.HttpClientException;
import com.smartsheet.api.internal.http.HttpRequest;
import com.smartsheet.api.internal.http.HttpResponse;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.retry.ShouldRetry;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClient
implements HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHttpClient.class);
    private static final Set<Trace> REQUEST_RESPONSE_SUMMARY = Collections.unmodifiableSet(new HashSet<Trace>(Arrays.asList(Trace.RequestHeaders, Trace.RequestBodySummary, Trace.ResponseHeaders, Trace.ResponseBodySummary)));
    private static final boolean TRACE_PRETTY_PRINT_DEFAULT = Boolean.parseBoolean(System.getProperty("Smartsheet.trace.pretty", "true"));
    private static final Set<Trace> TRACE_DEFAULT_TRACE_SET = Trace.parse(System.getProperty("Smartsheet.trace.parts"));
    private static PrintWriter TRACE_WRITER;
    private final CloseableHttpClient httpClient;
    private HttpRequestBase apacheHttpRequest;
    private CloseableHttpResponse apacheHttpResponse;
    private final String userAgent;
    private final Set<Trace> traces = new HashSet<Trace>(TRACE_DEFAULT_TRACE_SET);
    private boolean tracePrettyPrint = TRACE_PRETTY_PRINT_DEFAULT;
    @Deprecated
    public static final String USER_AGENT = "Mozilla/5.0 Firefox/26.0";
    private ShouldRetry shouldRetry;

    public DefaultHttpClient() {
        this(HttpClients.createDefault(), new DefaultShouldRetry(null));
    }

    public DefaultHttpClient(CloseableHttpClient httpClient, ShouldRetry shouldRetry) {
        this.httpClient = Util.throwIfNull(httpClient);
        this.userAgent = DefaultHttpClient.generateUserAgent(this.getClass());
        this.shouldRetry = shouldRetry;
    }

    /*
     * Exception decompiling
     */
    @Override
    public HttpResponse request(HttpRequest smartsheetRequest) throws HttpClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[DOLOOP]], but top level block is 25[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    @Override
    public void releaseConnection() {
        if (this.apacheHttpResponse != null) {
            try {
                this.apacheHttpResponse.close();
                this.apacheHttpResponse = null;
            }
            catch (IOException e) {
                logger.error("error closing Apache HttpResponse - {}", (Throwable)e);
            }
        }
    }

    @Override
    public void setTraces(Trace ... traces) {
        this.traces.clear();
        for (Trace trace : traces) {
            if (trace.addReplacements(this.traces)) continue;
            this.traces.add(trace);
        }
    }

    @Override
    public void setTracePrettyPrint(boolean pretty) {
        this.tracePrettyPrint = pretty;
    }

    public static void setTraceStream(OutputStream traceStream) {
        TRACE_WRITER = new PrintWriter(traceStream, true);
    }

    static String generateUserAgent(Class<?> clazz) {
        String thisVersion = "";
        String title = "";
        Package thisPackage = clazz.getPackage();
        if (thisPackage != null) {
            thisVersion = thisPackage.getImplementationVersion();
            title = thisPackage.getImplementationTitle();
        }
        return title + "/" + thisVersion + " " + System.getProperty("os.name") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.version");
    }

    static {
        DefaultHttpClient.setTraceStream(System.out);
        if (TRACE_DEFAULT_TRACE_SET.size() > 0) {
            TRACE_WRITER.println("default trace logging - pretty:" + TRACE_PRETTY_PRINT_DEFAULT + " parts:" + TRACE_DEFAULT_TRACE_SET);
        }
    }
}

