/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal.http;

import com.smartsheet.api.internal.http.DefaultCalcBackoff;
import com.smartsheet.api.internal.http.HttpResponse;
import com.smartsheet.api.internal.json.JacksonJsonSerializer;
import com.smartsheet.api.internal.json.JsonSerializer;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.Error;
import com.smartsheet.api.retry.CalcBackoff;
import com.smartsheet.api.retry.ShouldRetry;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultShouldRetry
implements ShouldRetry {
    private JsonSerializer jsonSerializer;
    private CalcBackoff calcBackoff = new DefaultCalcBackoff(15000L);
    private static final Logger logger = LoggerFactory.getLogger(DefaultShouldRetry.class);

    public DefaultShouldRetry(JsonSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer == null ? new JacksonJsonSerializer() : jsonSerializer;
    }

    public void setCalcBackoff(CalcBackoff calcBackoff) {
        this.calcBackoff = calcBackoff;
    }

    @Override
    public boolean shouldRetry(int previousAttempts, long totalElapsedTimeMillis, HttpResponse response) {
        Error error;
        Util.throwIfNull(this.calcBackoff);
        try {
            error = this.jsonSerializer.deserialize(Error.class, response.getEntity().getContent());
        }
        catch (IOException e) {
            return false;
        }
        switch (error.getErrorCode()) {
            case 4001: 
            case 4002: 
            case 4003: 
            case 4004: {
                break;
            }
            default: {
                return false;
            }
        }
        long backoffMillis = this.calcBackoff.calcBackoff(previousAttempts, totalElapsedTimeMillis, error);
        if (backoffMillis < 0L) {
            return false;
        }
        logger.info("HttpError StatusCode=" + response.getStatusCode() + ": Retrying in " + backoffMillis + " milliseconds");
        try {
            Thread.sleep(backoffMillis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

