/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal.http;

import com.smartsheet.api.Trace;
import com.smartsheet.api.internal.http.HttpEntity;
import com.smartsheet.api.internal.http.HttpResponse;
import com.smartsheet.api.internal.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpRequestBase;

public class RequestAndResponseData {
    private static int TRUNCATE_LENGTH = Integer.getInteger("Smartsheet.trace.truncateLen", 1024);
    public final RequestData request;
    public final ResponseData response;

    private RequestAndResponseData(RequestData requestData, ResponseData responseData) {
        this.request = requestData;
        this.response = responseData;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean pretty) {
        String EOL = pretty ? "\n" : "";
        String INDENT = pretty ? "  " : "";
        String INDENT2 = INDENT + INDENT;
        String INDENT3 = INDENT2 + INDENT;
        StringBuilder buf = new StringBuilder();
        buf.append("{").append(EOL);
        buf.append(INDENT).append("request:");
        if (this.request == null) {
            buf.append("null,").append(EOL);
        } else {
            buf.append("{").append(EOL);
            buf.append(INDENT2).append("command:'").append(this.request.getCommand()).append("',").append(EOL);
            if (this.request.hasHeaders()) {
                buf.append(INDENT2).append("headers:");
                if (this.request.getHeaders() == null) {
                    buf.append("null");
                } else {
                    buf.append("{").append(EOL);
                    for (Map.Entry header : this.request.headers.entrySet()) {
                        buf.append(INDENT3).append("'").append((String)header.getKey()).append("':'").append((String)header.getValue()).append("',").append(EOL);
                    }
                    buf.append(INDENT2).append("},").append(EOL);
                }
            }
            if (this.request.hasBody()) {
                buf.append(INDENT2).append("body:");
                if (this.request.body == null) {
                    buf.append("null");
                } else {
                    buf.append("'").append(this.request.body).append("'");
                }
                buf.append(EOL);
            }
            buf.append(INDENT).append("},").append(EOL);
        }
        buf.append(INDENT).append("response:");
        if (this.response == null) {
            buf.append("null").append(EOL);
        } else {
            buf.append("{").append(EOL);
            buf.append(INDENT2).append("status:'").append(this.response.getStatus()).append("',").append(EOL);
            if (this.response.hasHeaders()) {
                buf.append(INDENT2).append("headers:");
                if (this.response.getHeaders() == null) {
                    buf.append("null");
                } else {
                    buf.append("{").append(EOL);
                    for (Map.Entry header : this.response.headers.entrySet()) {
                        buf.append(INDENT3).append("'").append((String)header.getKey()).append("':'").append((String)header.getValue()).append("',").append(EOL);
                    }
                    buf.append(INDENT2).append("},").append(EOL);
                }
            }
            if (this.response.hasBody()) {
                buf.append(INDENT2).append("body:");
                if (this.response.body == null) {
                    buf.append("null");
                } else {
                    buf.append("'").append(this.response.body).append("'");
                }
                buf.append(EOL);
            }
            buf.append(INDENT).append("}").append(EOL);
        }
        buf.append("}");
        return buf.toString();
    }

    public static RequestAndResponseData of(HttpRequestBase request, HttpEntity requestEntity, HttpResponse response, HttpEntity responseEntity, Set<Trace> traces) throws IOException {
        boolean binaryBody;
        RequestData.Builder requestBuilder = new RequestData.Builder();
        ResponseData.Builder responseBuilder = new ResponseData.Builder();
        if (request != null) {
            requestBuilder.withCommand(request.getMethod() + " " + request.getURI());
            binaryBody = false;
            if (traces.contains((Object)Trace.RequestHeaders) && request.getAllHeaders() != null) {
                requestBuilder.withHeaders();
                for (Header header : request.getAllHeaders()) {
                    String headerName = header.getName();
                    String headerValue = header.getValue();
                    if ("Authorization".equals(headerName) && headerValue.length() > 0) {
                        headerValue = "Bearer ****" + headerValue.substring(Math.max(0, headerValue.length() - 4));
                    } else if ("Content-Disposition".equals(headerName)) {
                        binaryBody = true;
                    }
                    requestBuilder.addHeader(headerName, headerValue);
                }
            }
            if (requestEntity != null) {
                if (traces.contains((Object)Trace.RequestBody)) {
                    requestBuilder.setBody(binaryBody ? RequestAndResponseData.binaryBody(requestEntity) : RequestAndResponseData.getContentAsText(requestEntity));
                } else if (traces.contains((Object)Trace.RequestBodySummary)) {
                    requestBuilder.setBody(binaryBody ? RequestAndResponseData.binaryBody(requestEntity) : RequestAndResponseData.truncateAsNeeded(RequestAndResponseData.getContentAsText(requestEntity), TRUNCATE_LENGTH));
                }
            }
        }
        if (response != null) {
            binaryBody = false;
            responseBuilder.withStatus(response.getStatusText());
            if (traces.contains((Object)Trace.ResponseHeaders) && response.getHeaders() != null) {
                responseBuilder.withHeaders();
                for (Map.Entry<String, String> header : response.getHeaders().entrySet()) {
                    String headerName = header.getKey();
                    String headerValue = header.getValue();
                    if ("Content-Disposition".equals(headerName)) {
                        binaryBody = true;
                    }
                    responseBuilder.addHeader(headerName, headerValue);
                }
            }
            if (responseEntity != null) {
                if (traces.contains((Object)Trace.ResponseBody)) {
                    responseBuilder.setBody(binaryBody ? RequestAndResponseData.binaryBody(responseEntity) : RequestAndResponseData.getContentAsText(responseEntity));
                } else if (traces.contains((Object)Trace.ResponseBodySummary)) {
                    responseBuilder.setBody(binaryBody ? RequestAndResponseData.binaryBody(responseEntity) : RequestAndResponseData.truncateAsNeeded(RequestAndResponseData.getContentAsText(responseEntity), TRUNCATE_LENGTH));
                }
            }
        }
        return new RequestAndResponseData(requestBuilder.build(), responseBuilder.build());
    }

    static String binaryBody(HttpEntity entity) {
        return "**possibly-binary(type:" + entity.getContentType() + ", len:" + entity.getContentLength() + ")**";
    }

    public static String getContentAsText(HttpEntity entity) throws IOException {
        String contentAsText;
        if (entity == null) {
            return "";
        }
        InputStream inputStream = entity.getContent();
        if (inputStream == null) {
            return "";
        }
        boolean markSupported = inputStream.markSupported();
        if (markSupported) {
            inputStream.mark(0xA00000);
        }
        byte[] contentBytes = StreamUtil.readBytesFromStream(inputStream);
        try {
            contentAsText = new String(contentBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException badEncodingOrNotText) {
            contentAsText = new String(Hex.encodeHex((byte[])contentBytes));
        }
        if (markSupported) {
            inputStream.reset();
        } else {
            entity.setContent(new ByteArrayInputStream(contentBytes));
        }
        return contentAsText;
    }

    public static String truncateAsNeeded(String string, int truncateLen) {
        if (truncateLen == -1) {
            return string;
        }
        truncateLen = Math.min(string.length(), truncateLen);
        String suffix = truncateLen < string.length() ? "..." : "";
        return string.substring(0, truncateLen) + suffix;
    }

    public static class ResponseData
    extends HttpPayloadData {
        private String status;

        public String getStatus() {
            return this.status;
        }

        public static class Builder
        extends HttpPayloadData.Builder<ResponseData> {
            private ResponseData dataObject;

            @Override
            public void reset() {
                this.dataObject = null;
            }

            @Override
            protected ResponseData getDataObject() {
                if (this.dataObject == null) {
                    this.dataObject = new ResponseData();
                }
                return this.dataObject;
            }

            public HttpPayloadData.Builder withStatus(String status) {
                this.getDataObject().status = status;
                return this;
            }

            @Override
            public ResponseData build() {
                try {
                    ResponseData responseData = this.dataObject;
                    return responseData;
                }
                finally {
                    this.reset();
                }
            }
        }
    }

    public static class RequestData
    extends HttpPayloadData {
        private String command;

        public String getCommand() {
            return this.command;
        }

        public static class Builder
        extends HttpPayloadData.Builder<RequestData> {
            private RequestData dataObject;

            @Override
            public void reset() {
                this.dataObject = null;
            }

            @Override
            protected RequestData getDataObject() {
                if (this.dataObject == null) {
                    this.dataObject = new RequestData();
                }
                return this.dataObject;
            }

            public HttpPayloadData.Builder withCommand(String command) {
                this.getDataObject().command = command;
                return this;
            }

            @Override
            public RequestData build() {
                try {
                    RequestData requestData = this.dataObject;
                    return requestData;
                }
                finally {
                    this.reset();
                }
            }
        }
    }

    public static abstract class HttpPayloadData {
        Map<String, String> headers;
        String body;

        public String getBody() {
            return this.body;
        }

        public boolean hasBody() {
            return this.body != null;
        }

        public boolean hasHeaders() {
            return this.headers != null;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        static abstract class Builder<Type extends HttpPayloadData> {
            Builder() {
            }

            public void withHeaders() {
                if (((HttpPayloadData)this.getDataObject()).headers == null) {
                    ((HttpPayloadData)this.getDataObject()).headers = new TreeMap<String, String>();
                }
            }

            public Builder addHeader(String key, String val) {
                this.withHeaders();
                ((HttpPayloadData)this.getDataObject()).headers.put(key, val);
                return this;
            }

            public Builder setBody(String body) {
                ((HttpPayloadData)this.getDataObject()).body = body;
                return this;
            }

            public abstract Type build();

            public abstract void reset();

            protected abstract Type getDataObject();
        }
    }
}

