/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Hex;

public class StreamUtil {
    public static byte[] readBytesFromStream(InputStream source) throws IOException {
        return StreamUtil.readBytesFromStream(source, 0x100000);
    }

    public static byte[] readBytesFromStream(InputStream source, int bufferSize) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        StreamUtil.copyContentIntoOutputStream(source, buffer, bufferSize);
        return buffer.toByteArray();
    }

    public static long copyContentIntoOutputStream(InputStream source, OutputStream content, int bufferSize) throws IOException {
        int bytesRead;
        byte[] tempBuf = new byte[Math.max(1024, bufferSize)];
        long bytesWritten = 0L;
        while ((bytesRead = source.read(tempBuf)) >= 0) {
            content.write(tempBuf, 0, bytesRead);
            bytesWritten += (long)bytesRead;
        }
        return bytesWritten;
    }

    public static InputStream cloneContent(InputStream source, ByteArrayOutputStream target) throws IOException {
        if (source == null) {
            return null;
        }
        boolean markSupported = source.markSupported();
        int maxReadBack = 0x100000;
        if (markSupported) {
            source.mark(0x100000);
        }
        long bytesCopied = StreamUtil.copyContentIntoOutputStream(source, target, 0x100000);
        if (markSupported && bytesCopied < 0x100000L) {
            source.reset();
            return source;
        }
        return new ByteArrayInputStream(target.toByteArray());
    }

    public static String toUtf8StringOrHex(ByteArrayOutputStream byteStream, int maxLen) {
        String result;
        if (maxLen == -1) {
            maxLen = Integer.MAX_VALUE;
        }
        try {
            result = byteStream.toString("UTF-8");
        }
        catch (Exception notUtf8) {
            result = Hex.encodeHexString((byte[])byteStream.toByteArray());
        }
        int resultLen = result != null ? result.length() : 0;
        String suffix = resultLen > maxLen ? "..." : "";
        return resultLen == 0 ? "" : result.substring(0, Math.min(resultLen, maxLen)) + suffix;
    }
}

