/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.models;

import com.smartsheet.api.models.AbstractRow;
import com.smartsheet.api.models.Attachment;
import com.smartsheet.api.models.Cell;
import com.smartsheet.api.models.Column;
import com.smartsheet.api.models.Discussion;
import com.smartsheet.api.models.NamedModel;
import com.smartsheet.api.models.ProjectSettings;
import com.smartsheet.api.models.SheetUserSettings;
import com.smartsheet.api.models.Source;
import com.smartsheet.api.models.enums.AccessLevel;
import com.smartsheet.api.models.enums.AttachmentType;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;

public class AbstractSheet<TRow extends AbstractRow<TColumn, TCell>, TColumn extends Column, TCell extends Cell>
extends NamedModel<Long> {
    private List<TColumn> columns;
    private List<TRow> rows;
    private AccessLevel accessLevel;
    private List<Discussion> discussions;
    private List<Attachment> attachments;
    private Boolean readOnly;
    private Date createdAt;
    private Date modifiedAt;
    private String permalink;
    private Boolean ganttEnabled;
    private Boolean dependenciesEnabled;
    private Boolean resourceManagementEnabled;
    private Integer version;
    private Long fromId;
    private Integer totalRowCount;
    private EnumSet<AttachmentType> effectiveAttachmentOptions;
    private Boolean favorite;
    private Boolean showParentRowsForFilters;
    private SheetUserSettings userSettings;
    private Source source;
    private String owner;
    private Long ownerId;
    private ProjectSettings projectSettings;

    public String getOwner() {
        return this.owner;
    }

    public AbstractSheet<TRow, TColumn, TCell> setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public AbstractSheet<TRow, TColumn, TCell> setOwnerId(long ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public Boolean getDependenciesEnabled() {
        return this.dependenciesEnabled;
    }

    public AbstractSheet<TRow, TColumn, TCell> setDependenciesEnabled(Boolean dependenciesEnabled) {
        this.dependenciesEnabled = dependenciesEnabled;
        return this;
    }

    public TColumn getColumnByIndex(int index) {
        if (this.columns == null) {
            return null;
        }
        Column result = null;
        for (Column column : this.columns) {
            if (column.getIndex() != index) continue;
            result = column;
            break;
        }
        return (TColumn)result;
    }

    public TColumn getColumnById(long columnId) {
        if (this.columns == null) {
            return null;
        }
        Column result = null;
        for (Column column : this.columns) {
            if ((Long)column.getId() != columnId) continue;
            result = column;
            break;
        }
        return (TColumn)result;
    }

    public TRow getRowByRowNumber(int rowNumber) {
        if (this.rows == null) {
            return null;
        }
        AbstractRow result = null;
        for (AbstractRow row : this.rows) {
            if (row.getRowNumber() != rowNumber) continue;
            result = row;
            break;
        }
        return (TRow)result;
    }

    public List<TColumn> getColumns() {
        return this.columns;
    }

    public AbstractSheet<TRow, TColumn, TCell> setColumns(List<TColumn> columns) {
        this.columns = columns;
        return this;
    }

    public List<TRow> getRows() {
        return this.rows;
    }

    public AbstractSheet<TRow, TColumn, TCell> setRows(List<TRow> rows) {
        this.rows = rows;
        return this;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public AbstractSheet<TRow, TColumn, TCell> setAccessLevel(AccessLevel accessLevel) {
        this.accessLevel = accessLevel;
        return this;
    }

    public List<Discussion> getDiscussions() {
        return this.discussions;
    }

    public AbstractSheet<TRow, TColumn, TCell> setDiscussions(List<Discussion> discussions) {
        this.discussions = discussions;
        return this;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public AbstractSheet<TRow, TColumn, TCell> setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public AbstractSheet<TRow, TColumn, TCell> setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public AbstractSheet<TRow, TColumn, TCell> setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public AbstractSheet<TRow, TColumn, TCell> setModifiedAt(Date modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    public String getPermalink() {
        return this.permalink;
    }

    public AbstractSheet<TRow, TColumn, TCell> setPermalink(String permalink) {
        this.permalink = permalink;
        return this;
    }

    public Boolean getGanttEnabled() {
        return this.ganttEnabled;
    }

    public AbstractSheet<TRow, TColumn, TCell> setGanttEnabled(Boolean ganttEnabled) {
        this.ganttEnabled = ganttEnabled;
        return this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public AbstractSheet<TRow, TColumn, TCell> setVersion(Integer version) {
        this.version = version;
        return this;
    }

    public Long getFromId() {
        return this.fromId;
    }

    public AbstractSheet<TRow, TColumn, TCell> setFromId(Long fromId) {
        this.fromId = fromId;
        return this;
    }

    public Boolean getResourceManagementEnabled() {
        return this.resourceManagementEnabled;
    }

    public AbstractSheet<TRow, TColumn, TCell> setResourceManagementEnabled(Boolean resourceManagementEnabled) {
        this.resourceManagementEnabled = resourceManagementEnabled;
        return this;
    }

    public Integer getTotalRowCount() {
        return this.totalRowCount;
    }

    public AbstractSheet<TRow, TColumn, TCell> setTotalRowCount(Integer totalRowCount) {
        this.totalRowCount = totalRowCount;
        return this;
    }

    public EnumSet<AttachmentType> getEffectiveAttachmentOptions() {
        return this.effectiveAttachmentOptions;
    }

    public AbstractSheet<TRow, TColumn, TCell> setEffectiveAttachmentOptions(EnumSet<AttachmentType> effectiveAttachmentOptions) {
        this.effectiveAttachmentOptions = effectiveAttachmentOptions;
        return this;
    }

    public Boolean isFavorite() {
        return this.favorite;
    }

    public AbstractSheet<TRow, TColumn, TCell> setFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    public Boolean getShowParentRowsForFilters() {
        return this.showParentRowsForFilters;
    }

    public AbstractSheet<TRow, TColumn, TCell> setShowParentRowsForFilters(Boolean showParentRowsForFilters) {
        this.showParentRowsForFilters = showParentRowsForFilters;
        return this;
    }

    public SheetUserSettings getUserSettings() {
        return this.userSettings;
    }

    public AbstractSheet<TRow, TColumn, TCell> setUserSettings(SheetUserSettings userSettings) {
        this.userSettings = userSettings;
        return this;
    }

    public Source getSource() {
        return this.source;
    }

    public AbstractSheet<TRow, TColumn, TCell> setSource(Source source) {
        this.source = source;
        return this;
    }

    public ProjectSettings getProjectSettings() {
        return this.projectSettings;
    }

    public AbstractSheet<TRow, TColumn, TCell> setProjectSettings(ProjectSettings projectSettings) {
        this.projectSettings = projectSettings;
        return this;
    }
}

