/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.models;

import com.smartsheet.api.models.NamedModel;
import com.smartsheet.api.models.enums.AccessLevel;
import com.smartsheet.api.models.enums.ShareScope;
import com.smartsheet.api.models.enums.ShareType;
import java.util.Date;

public class Share
extends NamedModel<String> {
    private AccessLevel accessLevel;
    private String email;
    private Long userId;
    private Long groupId;
    private ShareType type;
    private ShareScope scope;
    private Date createdAt;
    private Date modifiedAt;
    private String subject;
    private String message;
    private Boolean ccMe;

    public String getSubject() {
        return this.subject;
    }

    public Share setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public Share setMessage(String message) {
        this.message = message;
        return this;
    }

    public Boolean isCcMe() {
        return this.ccMe;
    }

    public Share setCcMe(Boolean ccMe) {
        this.ccMe = ccMe;
        return this;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public Share setAccessLevel(AccessLevel accessLevel) {
        this.accessLevel = accessLevel;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public Share setEmail(String email) {
        this.email = email;
        return this;
    }

    public ShareScope getScope() {
        return this.scope;
    }

    public Share setScope(ShareScope scope) {
        this.scope = scope;
        return this;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Share setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public Share setModifiedAt(Date modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    public Long getUserId() {
        return this.userId;
    }

    public Share setUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public Share setGroupId(Long groupId) {
        this.groupId = groupId;
        return this;
    }

    public ShareType getType() {
        return this.type;
    }

    public Share setType(ShareType type) {
        this.type = type;
        return this;
    }

    public static class CreateGroupShareBuilder {
        private Long groupId;

        public CreateGroupShareBuilder setGroupId(Long groupId) {
            this.groupId = groupId;
            return this;
        }

        public Long getGroupId() {
            return this.groupId;
        }

        public Share build() {
            if (this.groupId == null) {
                throw new InstantiationError("You must provide a groupId");
            }
            Share share = new Share();
            share.groupId = this.groupId;
            share.type = ShareType.GROUP;
            return share;
        }
    }

    public static class CreateUserShareBuilder {
        private String email;
        private Long userId;
        private AccessLevel accessLevel;

        public CreateUserShareBuilder setEmailAddress(String emailAddress) {
            this.email = emailAddress;
            return this;
        }

        public String getEmailAddress() {
            return this.email;
        }

        public CreateUserShareBuilder setUserId(Long userId) {
            this.userId = userId;
            return this;
        }

        public Long getUserId() {
            return this.userId;
        }

        public AccessLevel getAccessLevel() {
            return this.accessLevel;
        }

        public CreateUserShareBuilder setAccessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Share build() {
            if (this.email == null && this.userId == null || this.email != null && this.userId != null) {
                throw new InstantiationError("You must provide one and only one of emailAddress and userId");
            }
            Share share = new Share();
            share.userId = this.userId;
            share.email = this.email;
            share.accessLevel = this.accessLevel;
            return share;
        }
    }

    public static class UpdateShareBuilder {
        private AccessLevel accessLevel;
        private String id;

        public String getShareId() {
            return this.id;
        }

        public UpdateShareBuilder setShareId(String shareId) {
            this.id = shareId;
            return this;
        }

        public UpdateShareBuilder setAccessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public AccessLevel getAccessLevel() {
            return this.accessLevel;
        }

        public Share build() {
            if (this.accessLevel == null || this.id == null) {
                throw new InstantiationError("The access level and share id must be specified.");
            }
            Share share = new Share();
            share.accessLevel = this.accessLevel;
            share.setId(this.id);
            return share;
        }
    }

    public static class ShareToOneGroupBuilder {
        private AccessLevel accessLevel;
        private Long groupId;

        public ShareToOneGroupBuilder setAccessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public ShareToOneGroupBuilder setUserId(Long groupId) {
            this.groupId = groupId;
            return this;
        }

        public AccessLevel getAccessLevel() {
            return this.accessLevel;
        }

        public Long getGroupId() {
            return this.groupId;
        }

        public Share build() {
            if (this.accessLevel == null || this.groupId != null) {
                throw new InstantiationError("You must provide a groupId and accessLevel");
            }
            Share share = new Share();
            share.accessLevel = this.accessLevel;
            share.groupId = this.groupId;
            share.type = ShareType.GROUP;
            return share;
        }
    }

    public static class ShareToOneUserBuilder {
        private AccessLevel accessLevel;
        private String email;
        private Long userId;

        public ShareToOneUserBuilder setAccessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public ShareToOneUserBuilder setEmail(String email) {
            this.email = email;
            return this;
        }

        public ShareToOneUserBuilder setUserId(Long userId) {
            this.userId = userId;
            return this;
        }

        public AccessLevel getAccessLevel() {
            return this.accessLevel;
        }

        public String getEmail() {
            return this.email;
        }

        public Long getUserId() {
            return this.userId;
        }

        public Share build() {
            if (this.accessLevel == null || this.email == null && this.userId == null || this.email != null && this.userId != null) {
                throw new InstantiationError("You must provide one and only one of emailAddress and userId, and accessLevel is required");
            }
            Share share = new Share();
            share.accessLevel = this.accessLevel;
            share.email = this.email;
            share.userId = this.userId;
            share.type = ShareType.USER;
            return share;
        }
    }
}

