/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.models.format;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.smartsheet.api.models.format.Bold;
import com.smartsheet.api.models.format.Color;
import com.smartsheet.api.models.format.Currency;
import com.smartsheet.api.models.format.DecimalCount;
import com.smartsheet.api.models.format.FontFamily;
import com.smartsheet.api.models.format.FontSize;
import com.smartsheet.api.models.format.HorizontalAlignment;
import com.smartsheet.api.models.format.Italic;
import com.smartsheet.api.models.format.NumberFormat;
import com.smartsheet.api.models.format.Strikethrough;
import com.smartsheet.api.models.format.TextWrap;
import com.smartsheet.api.models.format.ThousandsSeparator;
import com.smartsheet.api.models.format.Underline;
import com.smartsheet.api.models.format.VerticalAlignment;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=FormatSerializer.class)
public class Format {
    private static final int[] DEFAULT_FORMAT = new int[]{0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final int UNSET = Integer.MIN_VALUE;
    int[] formatArray;

    public Format(String original) {
        this.formatArray = new int[DEFAULT_FORMAT.length];
        FormatTokenizer tokenizer = new FormatTokenizer(original);
        for (int i = 0; tokenizer.next() && i < DEFAULT_FORMAT.length; ++i) {
            this.formatArray[i] = tokenizer.isNextUnset() ? Integer.MIN_VALUE : tokenizer.nextInt();
        }
    }

    public Format() {
        this.formatArray = Arrays.copyOf(DEFAULT_FORMAT, DEFAULT_FORMAT.length);
    }

    protected <T extends Enum<?>> T getFormatValue(FormatAttribute attribute, T[] values) {
        if (this.formatArray[attribute.ordinal()] >= values.length) {
            return values[DEFAULT_FORMAT[attribute.ordinal()]];
        }
        if (this.formatArray[attribute.ordinal()] == Integer.MIN_VALUE) {
            return null;
        }
        return values[this.formatArray[attribute.ordinal()]];
    }

    public FontFamily getFontFamily() {
        return (FontFamily)this.getFormatValue(FormatAttribute.FONT_FAMILY, FontFamily.values());
    }

    public FontSize getFontSize() {
        return (FontSize)this.getFormatValue(FormatAttribute.FONT_SIZE, FontSize.values());
    }

    public Bold getBold() {
        return (Bold)this.getFormatValue(FormatAttribute.BOLD, Bold.values());
    }

    public Italic getItalic() {
        return (Italic)this.getFormatValue(FormatAttribute.ITALIC, Italic.values());
    }

    public Underline getUnderline() {
        return (Underline)this.getFormatValue(FormatAttribute.UNDERLINE, Underline.values());
    }

    public Strikethrough getStrikethrough() {
        return (Strikethrough)this.getFormatValue(FormatAttribute.STRIKETHROUGH, Strikethrough.values());
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return (HorizontalAlignment)this.getFormatValue(FormatAttribute.H_ALIGN, HorizontalAlignment.values());
    }

    public VerticalAlignment getVerticalAlignment() {
        return (VerticalAlignment)this.getFormatValue(FormatAttribute.V_ALIGN, VerticalAlignment.values());
    }

    public Color getTextColor() {
        return (Color)this.getFormatValue(FormatAttribute.TEXT_COLOR, Color.values());
    }

    public Color getBackgroundColor() {
        return (Color)this.getFormatValue(FormatAttribute.BACKGROUND_COLOR, Color.values());
    }

    public Color getTaskbarColor() {
        return (Color)this.getFormatValue(FormatAttribute.TASKBAR_COLOR, Color.values());
    }

    public Currency getCurrency() {
        return (Currency)this.getFormatValue(FormatAttribute.CURRENCY, Currency.values());
    }

    public DecimalCount getDecimalCount() {
        return (DecimalCount)this.getFormatValue(FormatAttribute.DECIMAL_COUNT, DecimalCount.values());
    }

    public ThousandsSeparator getThousandsSeparator() {
        return (ThousandsSeparator)this.getFormatValue(FormatAttribute.THOUSANDS_SEPARATOR, ThousandsSeparator.values());
    }

    public NumberFormat getNumberFormat() {
        return (NumberFormat)this.getFormatValue(FormatAttribute.NUMBER_FORMAT, NumberFormat.values());
    }

    public TextWrap getTextWrap() {
        return (TextWrap)this.getFormatValue(FormatAttribute.TEXT_WRAP, TextWrap.values());
    }

    public static class FormatSerializer
    extends JsonSerializer<Format> {
        public void serialize(Format format, JsonGenerator generator, SerializerProvider provider) throws IOException {
            StringBuilder stringBuilder = new StringBuilder(30);
            String separator = "";
            for (int formatValue : format.formatArray) {
                stringBuilder.append(separator);
                separator = ",";
                if (formatValue == Integer.MIN_VALUE) continue;
                stringBuilder.append(formatValue);
            }
            generator.writeString(stringBuilder.toString());
        }
    }

    public static class FormatBuilder {
        int[] formatArray = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};

        public Format build() {
            String delimiter = "";
            StringBuilder formatStringBuilder = new StringBuilder(30);
            int[] nArray = this.formatArray;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer value = nArray[i];
                formatStringBuilder.append(delimiter);
                delimiter = ",";
                if (value == Integer.MIN_VALUE) continue;
                formatStringBuilder.append(value);
            }
            return new Format(formatStringBuilder.toString());
        }

        public FormatBuilder withFormat(Format value) {
            System.arraycopy(value.formatArray, 0, this.formatArray, 0, this.formatArray.length);
            return this;
        }

        public FormatBuilder withFontFamily(FontFamily value) {
            this.formatArray[0] = this.getOrdinal(value);
            return this;
        }

        public FormatBuilder withFontSize(FontSize value) {
            this.formatArray[1] = this.getOrdinal(value);
            return this;
        }

        public FormatBuilder withBold(Bold value) {
            this.formatArray[2] = this.getOrdinal(value);
            return this;
        }

        public FormatBuilder withItalic(Italic value) {
            this.formatArray[3] = this.getOrdinal(value);
            return this;
        }

        public FormatBuilder withUnderline(Underline value) {
            this.formatArray[4] = this.getOrdinal(value);
            return this;
        }

        public FormatBuilder withStrikethrough(Strikethrough value) {
            this.formatArray[5] = this.getOrdinal(value);
            return this;
        }

        public FormatBuilder withHorizontalAlignment(HorizontalAlignment value) {
            this.formatArray[6] = this.getOrdinal(value);
            return this;
        }

        public FormatBuilder withVerticalAlignment(VerticalAlignment value) {
            this.formatArray[7] = this.getOrdinal(value);
            return this;
        }

        public FormatBuilder withTextColor(Color value) {
            this.formatArray[8] = this.getOrdinal(value);
            return this;
        }

        public FormatBuilder withBackgroundColor(Color value) {
            this.formatArray[9] = this.getOrdinal(value);
            return this;
        }

        public FormatBuilder withTaskbarColor(Color value) {
            this.formatArray[10] = this.getOrdinal(value);
            return this;
        }

        public FormatBuilder withCurrency(Currency value) {
            this.formatArray[11] = this.getOrdinal(value);
            return this;
        }

        public FormatBuilder withDecimalCount(DecimalCount value) {
            this.formatArray[12] = this.getOrdinal(value);
            return this;
        }

        public FormatBuilder withThousandsSeparator(ThousandsSeparator value) {
            this.formatArray[13] = this.getOrdinal(value);
            return this;
        }

        public FormatBuilder withNumberFormat(NumberFormat value) {
            this.formatArray[14] = this.getOrdinal(value);
            return this;
        }

        public FormatBuilder withTextWrap(TextWrap value) {
            this.formatArray[15] = this.getOrdinal(value);
            return this;
        }

        private int getOrdinal(Enum<?> enumValue) {
            return enumValue != null ? enumValue.ordinal() : Integer.MIN_VALUE;
        }
    }

    class FormatTokenizer {
        char[] chars;
        int pos;
        static final char SEPARATOR = ',';

        public FormatTokenizer(String str) {
            this.chars = str.toCharArray();
            this.pos = -1;
        }

        public boolean next() {
            ++this.pos;
            return this.pos < this.chars.length || this.pos == this.chars.length && this.chars[this.pos - 1] == ',';
        }

        public boolean isNextUnset() {
            if (this.pos >= this.chars.length) {
                return true;
            }
            return this.chars[this.pos] == ',';
        }

        public int nextInt() {
            char currentChar;
            int value = 0;
            while (this.pos < this.chars.length && (currentChar = this.chars[this.pos++]) != ',') {
                value = value * 10 + (currentChar - 48);
            }
            --this.pos;
            return value;
        }
    }

    private static enum FormatAttribute {
        FONT_FAMILY,
        FONT_SIZE,
        BOLD,
        ITALIC,
        UNDERLINE,
        STRIKETHROUGH,
        H_ALIGN,
        V_ALIGN,
        TEXT_COLOR,
        BACKGROUND_COLOR,
        TASKBAR_COLOR,
        CURRENCY,
        DECIMAL_COUNT,
        THOUSANDS_SEPARATOR,
        NUMBER_FORMAT,
        TEXT_WRAP;

    }
}

