/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.smartsheet.api.AuthorizationException;
import com.smartsheet.api.InvalidRequestException;
import com.smartsheet.api.ResourceNotFoundException;
import com.smartsheet.api.ServiceUnavailableException;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.SmartsheetRestException;
import com.smartsheet.api.internal.LengthEnforcingInputStream;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.http.HttpEntity;
import com.smartsheet.api.internal.http.HttpMethod;
import com.smartsheet.api.internal.http.HttpRequest;
import com.smartsheet.api.internal.http.HttpResponse;
import com.smartsheet.api.internal.json.JSONSerializerException;
import com.smartsheet.api.internal.util.StreamUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.Attachment;
import com.smartsheet.api.models.CopyOrMoveRowDirective;
import com.smartsheet.api.models.CopyOrMoveRowResult;
import com.smartsheet.api.models.Error;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.Result;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResources {
    public static final String PROPERTY_RESPONSE_LOG_CHARS = "Smartsheet.responseLogChars";
    private static final Logger log = LoggerFactory.getLogger(AbstractResources.class);
    private static final int BUFFER_SIZE = 4098;
    protected final SmartsheetImpl smartsheet;

    protected AbstractResources(SmartsheetImpl smartsheet) {
        Util.throwIfNull(smartsheet);
        this.smartsheet = smartsheet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> T getResource(String path, Class<T> objectClass) throws SmartsheetException {
        Util.throwIfNull((Object)path, objectClass);
        if (path.isEmpty()) {
            Error error = new Error();
            error.setMessage("An empty path was provided.");
            throw new ResourceNotFoundException(error);
        }
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve(path), HttpMethod.GET);
        T obj = null;
        String content = null;
        try {
            HttpResponse response = this.smartsheet.getHttpClient().request(request);
            InputStream inputStream = response.getEntity().getContent();
            switch (response.getStatusCode()) {
                case 200: {
                    try {
                        if (log.isInfoEnabled()) {
                            ByteArrayOutputStream contentCopyStream = new ByteArrayOutputStream();
                            inputStream = StreamUtil.cloneContent(inputStream, response.getEntity().getContentLength(), contentCopyStream);
                            content = StreamUtil.toUtf8StringOrHex(contentCopyStream, this.getResponseLogLength());
                        }
                        obj = this.smartsheet.getJsonSerializer().deserialize(objectClass, inputStream);
                        return obj;
                    }
                    catch (JsonParseException e) {
                        log.info("failure parsing '{}'", content, (Object)e);
                        throw new SmartsheetException((Exception)((Object)e));
                    }
                    catch (JsonMappingException e) {
                        log.info("failure mapping '{}'", content, (Object)e);
                        throw new SmartsheetException((Exception)((Object)e));
                    }
                    catch (IOException e) {
                        log.info("failure loading '{}'", content, (Object)e);
                        throw new SmartsheetException(e);
                    }
                }
                default: {
                    this.handleError(response);
                    return obj;
                }
            }
        }
        catch (JSONSerializerException jsx) {
            log.info("failed to parse '{}'", content, (Object)jsx);
            throw jsx;
        }
        finally {
            this.smartsheet.getHttpClient().releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T, S> T createResource(String path, Class<T> objectClass, S object) throws SmartsheetException {
        Util.throwIfNull(path, object, objectClass);
        Util.throwIfEmpty(path);
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve(path), HttpMethod.POST);
        ByteArrayOutputStream objectBytesStream = new ByteArrayOutputStream();
        this.smartsheet.getJsonSerializer().serialize(object, objectBytesStream);
        HttpEntity entity = new HttpEntity();
        entity.setContentType("application/json");
        entity.setContent(new ByteArrayInputStream(objectBytesStream.toByteArray()));
        entity.setContentLength(objectBytesStream.size());
        request.setEntity(entity);
        T obj = null;
        try {
            HttpResponse response = this.smartsheet.getHttpClient().request(request);
            switch (response.getStatusCode()) {
                case 200: {
                    InputStream inputStream = response.getEntity().getContent();
                    String content = null;
                    try {
                        if (log.isInfoEnabled()) {
                            ByteArrayOutputStream contentCopyStream = new ByteArrayOutputStream();
                            inputStream = StreamUtil.cloneContent(inputStream, response.getEntity().getContentLength(), contentCopyStream);
                            content = StreamUtil.toUtf8StringOrHex(contentCopyStream, this.getResponseLogLength());
                        }
                        obj = this.smartsheet.getJsonSerializer().deserializeResult(objectClass, inputStream).getResult();
                        return obj;
                    }
                    catch (JSONSerializerException e) {
                        log.info("failure parsing '{}'", content, (Object)e);
                        throw new SmartsheetException(e);
                    }
                    catch (IOException e) {
                        log.info("failure cloning content from inputStream '{}'", (Object)inputStream, (Object)e);
                        throw new SmartsheetException(e);
                    }
                }
                default: {
                    this.handleError(response);
                    return obj;
                }
            }
        }
        finally {
            this.smartsheet.getHttpClient().releaseConnection();
        }
    }

    protected <T> T createResourceWithAttachment(String path, Class<T> objectClass, T object, String partName, InputStream inputStream, String contentType, String attachmentName) throws SmartsheetException {
        Util.throwIfNull((Object)path, object);
        Util.throwIfEmpty(path);
        String boundary = "----" + System.currentTimeMillis();
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost uploadFile = this.createHttpPost(this.getSmartsheet().getBaseURI().resolve(path));
        try {
            uploadFile.setHeader("Content-Type", "multipart/form-data; boundary=" + boundary);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setBoundary(boundary);
        builder.addTextBody(partName, this.getSmartsheet().getJsonSerializer().serialize(object), ContentType.APPLICATION_JSON);
        builder.addBinaryBody("file", inputStream, ContentType.create((String)contentType), attachmentName);
        org.apache.http.HttpEntity multipart = builder.build();
        uploadFile.setEntity(multipart);
        T obj = null;
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)uploadFile);
            org.apache.http.HttpEntity responseEntity = response.getEntity();
            obj = this.getSmartsheet().getJsonSerializer().deserializeResult(objectClass, responseEntity.getContent()).getResult();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> T updateResource(String path, Class<T> objectClass, T object) throws SmartsheetException {
        Util.throwIfNull((Object)path, object);
        Util.throwIfEmpty(path);
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve(path), HttpMethod.PUT);
        ByteArrayOutputStream objectBytesStream = new ByteArrayOutputStream();
        this.smartsheet.getJsonSerializer().serialize(object, objectBytesStream);
        HttpEntity entity = new HttpEntity();
        entity.setContentType("application/json");
        entity.setContent(new ByteArrayInputStream(objectBytesStream.toByteArray()));
        entity.setContentLength(objectBytesStream.size());
        request.setEntity(entity);
        T obj = null;
        try {
            HttpResponse response = this.smartsheet.getHttpClient().request(request);
            switch (response.getStatusCode()) {
                case 200: {
                    obj = this.smartsheet.getJsonSerializer().deserializeResult(objectClass, response.getEntity().getContent()).getResult();
                    return obj;
                }
                default: {
                    this.handleError(response);
                    return obj;
                }
            }
        }
        finally {
            this.smartsheet.getHttpClient().releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> List<T> listResources(String path, Class<T> objectClass) throws SmartsheetException {
        Util.throwIfNull((Object)path, objectClass);
        Util.throwIfEmpty(path);
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve(path), HttpMethod.GET);
        List<T> obj = null;
        try {
            HttpResponse response = this.smartsheet.getHttpClient().request(request);
            switch (response.getStatusCode()) {
                case 200: {
                    obj = this.smartsheet.getJsonSerializer().deserializeList(objectClass, response.getEntity().getContent());
                    return obj;
                }
                default: {
                    this.handleError(response);
                    return obj;
                }
            }
        }
        finally {
            this.smartsheet.getHttpClient().releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> PagedResult<T> listResourcesWithWrapper(String path, Class<T> objectClass) throws SmartsheetException {
        Util.throwIfNull((Object)path, objectClass);
        Util.throwIfEmpty(path);
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve(path), HttpMethod.GET);
        PagedResult<T> obj = null;
        try {
            HttpResponse response = this.smartsheet.getHttpClient().request(request);
            switch (response.getStatusCode()) {
                case 200: {
                    obj = this.smartsheet.getJsonSerializer().deserializeDataWrapper(objectClass, response.getEntity().getContent());
                    return obj;
                }
                default: {
                    this.handleError(response);
                    return obj;
                }
            }
        }
        finally {
            this.smartsheet.getHttpClient().releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> void deleteResource(String path, Class<T> objectClass) throws SmartsheetException {
        Util.throwIfNull((Object)path, objectClass);
        Util.throwIfEmpty(path);
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve(path), HttpMethod.DELETE);
        try {
            HttpResponse response = this.smartsheet.getHttpClient().request(request);
            switch (response.getStatusCode()) {
                case 200: {
                    this.smartsheet.getJsonSerializer().deserializeResult(objectClass, response.getEntity().getContent());
                    return;
                }
                default: {
                    this.handleError(response);
                    return;
                }
            }
        }
        finally {
            this.smartsheet.getHttpClient().releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> List<T> deleteListResources(String path, Class<T> objectClass) throws SmartsheetException {
        Util.throwIfNull((Object)path, objectClass);
        Util.throwIfEmpty(path);
        Result<List<T>> obj = null;
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve(path), HttpMethod.DELETE);
        try {
            HttpResponse response = this.smartsheet.getHttpClient().request(request);
            switch (response.getStatusCode()) {
                case 200: {
                    obj = this.smartsheet.getJsonSerializer().deserializeListResult(objectClass, response.getEntity().getContent());
                    return obj.getResult();
                }
                default: {
                    this.handleError(response);
                    return obj.getResult();
                }
            }
        }
        finally {
            this.smartsheet.getHttpClient().releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T, S> List<S> postAndReceiveList(String path, T objectToPost, Class<S> objectClassToReceive) throws SmartsheetException {
        Util.throwIfNull(path, objectToPost, objectClassToReceive);
        Util.throwIfEmpty(path);
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve(path), HttpMethod.POST);
        ByteArrayOutputStream objectBytesStream = new ByteArrayOutputStream();
        this.smartsheet.getJsonSerializer().serialize(objectToPost, objectBytesStream);
        HttpEntity entity = new HttpEntity();
        entity.setContentType("application/json");
        entity.setContent(new ByteArrayInputStream(objectBytesStream.toByteArray()));
        entity.setContentLength(objectBytesStream.size());
        request.setEntity(entity);
        List<S> obj = null;
        try {
            HttpResponse response = this.smartsheet.getHttpClient().request(request);
            switch (response.getStatusCode()) {
                case 200: {
                    obj = this.smartsheet.getJsonSerializer().deserializeListResult(objectClassToReceive, response.getEntity().getContent()).getResult();
                    return obj;
                }
                default: {
                    this.handleError(response);
                    return obj;
                }
            }
        }
        finally {
            this.smartsheet.getHttpClient().releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CopyOrMoveRowResult postAndReceiveRowObject(String path, CopyOrMoveRowDirective objectToPost) throws SmartsheetException {
        Util.throwIfNull((Object)path, (Object)objectToPost);
        Util.throwIfEmpty(path);
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve(path), HttpMethod.POST);
        ByteArrayOutputStream objectBytesStream = new ByteArrayOutputStream();
        this.smartsheet.getJsonSerializer().serialize(objectToPost, objectBytesStream);
        HttpEntity entity = new HttpEntity();
        entity.setContentType("application/json");
        entity.setContent(new ByteArrayInputStream(objectBytesStream.toByteArray()));
        entity.setContentLength(objectBytesStream.size());
        request.setEntity(entity);
        CopyOrMoveRowResult obj = null;
        try {
            HttpResponse response = this.smartsheet.getHttpClient().request(request);
            switch (response.getStatusCode()) {
                case 200: {
                    obj = this.smartsheet.getJsonSerializer().deserializeCopyOrMoveRow(response.getEntity().getContent());
                    return obj;
                }
                default: {
                    this.handleError(response);
                    return obj;
                }
            }
        }
        finally {
            this.smartsheet.getHttpClient().releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T, S> List<S> putAndReceiveList(String path, T objectToPut, Class<S> objectClassToReceive) throws SmartsheetException {
        Util.throwIfNull(path, objectToPut, objectClassToReceive);
        Util.throwIfEmpty(path);
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve(path), HttpMethod.PUT);
        ByteArrayOutputStream objectBytesStream = new ByteArrayOutputStream();
        this.smartsheet.getJsonSerializer().serialize(objectToPut, objectBytesStream);
        HttpEntity entity = new HttpEntity();
        entity.setContentType("application/json");
        entity.setContent(new ByteArrayInputStream(objectBytesStream.toByteArray()));
        entity.setContentLength(objectBytesStream.size());
        request.setEntity(entity);
        List<S> obj = null;
        try {
            HttpResponse response = this.smartsheet.getHttpClient().request(request);
            switch (response.getStatusCode()) {
                case 200: {
                    obj = this.smartsheet.getJsonSerializer().deserializeListResult(objectClassToReceive, response.getEntity().getContent()).getResult();
                    return obj;
                }
                default: {
                    this.handleError(response);
                    return obj;
                }
            }
        }
        finally {
            this.smartsheet.getHttpClient().releaseConnection();
        }
    }

    protected HttpRequest createHttpRequest(URI uri, HttpMethod method) {
        HttpRequest request = new HttpRequest();
        request.setUri(uri);
        request.setMethod(method);
        request.setHeaders(this.createHeaders());
        return request;
    }

    protected HttpPost createHttpPost(URI uri) {
        HttpPost httpPost = new HttpPost(uri);
        Map<String, String> headers = this.createHeaders();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            httpPost.addHeader(entry.getKey(), entry.getValue());
        }
        return httpPost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Attachment attachFile(String url, InputStream inputStream, String contentType, long contentLength, String attachmentName) throws SmartsheetException {
        Util.throwIfNull((Object)inputStream, (Object)contentType);
        HttpRequest request = this.createHttpRequest(this.getSmartsheet().getBaseURI().resolve(url), HttpMethod.POST);
        try {
            request.getHeaders().put("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(attachmentName, "UTF-8") + "\"");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        HttpEntity entity = new HttpEntity();
        entity.setContentType(contentType);
        entity.setContent(new LengthEnforcingInputStream(inputStream, contentLength));
        entity.setContentLength(contentLength);
        request.setEntity(entity);
        Attachment attachment = null;
        try {
            HttpResponse response = this.getSmartsheet().getHttpClient().request(request);
            switch (response.getStatusCode()) {
                case 200: {
                    attachment = this.getSmartsheet().getJsonSerializer().deserializeResult(Attachment.class, response.getEntity().getContent()).getResult();
                    return attachment;
                }
                default: {
                    this.handleError(response);
                    return attachment;
                }
            }
        }
        finally {
            this.getSmartsheet().getHttpClient().releaseConnection();
        }
    }

    public <T> Attachment attachFile(String url, T t, String partName, InputStream inputstream, String contentType, String attachmentName) throws SmartsheetException {
        Util.throwIfNull((Object)inputstream, (Object)contentType);
        Attachment attachment = null;
        String boundary = "----" + System.currentTimeMillis();
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost uploadFile = this.createHttpPost(this.getSmartsheet().getBaseURI().resolve(url));
        try {
            uploadFile.setHeader("Content-Type", "multipart/form-data; boundary=" + boundary);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setBoundary(boundary);
        builder.addTextBody(partName, this.getSmartsheet().getJsonSerializer().serialize(t), ContentType.APPLICATION_JSON);
        builder.addBinaryBody("file", inputstream, ContentType.create((String)contentType), attachmentName);
        org.apache.http.HttpEntity multipart = builder.build();
        uploadFile.setEntity(multipart);
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)uploadFile);
            org.apache.http.HttpEntity responseEntity = response.getEntity();
            attachment = this.getSmartsheet().getJsonSerializer().deserializeResult(Attachment.class, responseEntity.getContent()).getResult();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return attachment;
    }

    protected void handleError(HttpResponse response) throws SmartsheetException {
        Error error;
        try {
            error = this.smartsheet.getJsonSerializer().deserialize(Error.class, response.getEntity().getContent());
        }
        catch (JsonParseException e) {
            throw new SmartsheetException((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new SmartsheetException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SmartsheetException(e);
        }
        ErrorCode code = ErrorCode.getErrorCode(response.getStatusCode());
        if (code == null) {
            throw new SmartsheetRestException(error);
        }
        try {
            throw code.getException(error);
        }
        catch (IllegalArgumentException e) {
            throw new SmartsheetException(e);
        }
        catch (SecurityException e) {
            throw new SmartsheetException(e);
        }
    }

    public SmartsheetImpl getSmartsheet() {
        return this.smartsheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getResourceAsFile(String path, String fileType, OutputStream outputStream) throws SmartsheetException {
        Util.throwIfNull((Object)outputStream, (Object)fileType);
        HttpRequest request = this.createHttpRequest(this.getSmartsheet().getBaseURI().resolve(path), HttpMethod.GET);
        request.getHeaders().put("Accept", fileType);
        try {
            HttpResponse response = this.getSmartsheet().getHttpClient().request(request);
            switch (response.getStatusCode()) {
                case 200: {
                    try {
                        AbstractResources.copyStream(response.getEntity().getContent(), outputStream);
                        return;
                    }
                    catch (IOException e) {
                        throw new SmartsheetException(e);
                    }
                }
                default: {
                    this.handleError(response);
                    return;
                }
            }
        }
        finally {
            this.getSmartsheet().getHttpClient().releaseConnection();
        }
    }

    @Deprecated
    private static void copyStream(InputStream input, OutputStream output) throws IOException {
        int len;
        byte[] buffer = new byte[4098];
        while ((len = input.read(buffer)) != -1) {
            output.write(buffer, 0, len);
        }
    }

    Map<String, String> createHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.smartsheet.getAccessToken());
        headers.put("Content-Type", "application/json");
        if (this.smartsheet.getAssumedUser() != null) {
            try {
                headers.put("Assume-User", URLEncoder.encode(this.smartsheet.getAssumedUser(), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unsupported encode. You must support utf-8 for the Smartsheet Java SDK to work", e);
            }
        }
        if (this.smartsheet.getChangeAgent() != null) {
            try {
                headers.put("Smartsheet-Change-Agent", URLEncoder.encode(this.smartsheet.getChangeAgent(), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unsupported encode. You must support utf-8 for the Smartsheet Java SDK to work", e);
            }
        }
        if (this.smartsheet.getUserAgent() != null) {
            headers.put("User-Agent", this.smartsheet.getUserAgent());
        }
        return headers;
    }

    int getResponseLogLength() {
        return Integer.getInteger(PROPERTY_RESPONSE_LOG_CHARS, 1024);
    }

    public static enum ErrorCode {
        BAD_REQUEST(400, InvalidRequestException.class),
        NOT_AUTHORIZED(401, AuthorizationException.class),
        FORBIDDEN(403, AuthorizationException.class),
        NOT_FOUND(404, ResourceNotFoundException.class),
        METHOD_NOT_SUPPORTED(405, InvalidRequestException.class),
        INTERNAL_SERVER_ERROR(500, InvalidRequestException.class),
        SERVICE_UNAVAILABLE(503, ServiceUnavailableException.class);

        int errorCode;
        Class<? extends SmartsheetRestException> exceptionClass;

        private ErrorCode(int errorCode, Class<? extends SmartsheetRestException> exceptionClass) {
            this.errorCode = errorCode;
            this.exceptionClass = exceptionClass;
        }

        public static ErrorCode getErrorCode(int errorNumber) {
            for (ErrorCode code : ErrorCode.values()) {
                if (code.errorCode != errorNumber) continue;
                return code;
            }
            return null;
        }

        public SmartsheetRestException getException() throws InstantiationException, IllegalAccessException {
            return this.exceptionClass.newInstance();
        }

        public SmartsheetRestException getException(Error error) throws SmartsheetException {
            try {
                return this.exceptionClass.getConstructor(Error.class).newInstance(error);
            }
            catch (IllegalArgumentException e) {
                throw new SmartsheetException(e);
            }
            catch (SecurityException e) {
                throw new SmartsheetException(e);
            }
            catch (InstantiationException e) {
                throw new SmartsheetException(e);
            }
            catch (IllegalAccessException e) {
                throw new SmartsheetException(e);
            }
            catch (InvocationTargetException e) {
                throw new SmartsheetException(e);
            }
            catch (NoSuchMethodException e) {
                throw new SmartsheetException(e);
            }
        }
    }
}

