/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.RowColumnResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.http.HttpEntity;
import com.smartsheet.api.internal.http.HttpMethod;
import com.smartsheet.api.internal.http.HttpRequest;
import com.smartsheet.api.internal.http.HttpResponse;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.CellHistory;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;

public class RowColumnResourcesImpl
extends AbstractResources
implements RowColumnResources {
    public RowColumnResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public PagedResult<CellHistory> getCellHistory(long sheetId, long rowId, long columnId, PaginationParameters parameters) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/rows/" + rowId + "/columns/" + columnId + "/history";
        if (parameters != null) {
            path = path + parameters.toQueryString();
        }
        return this.listResourcesWithWrapper(path, CellHistory.class);
    }

    @Override
    public void addImageToCell(long sheetId, long rowId, long columnId, String file, String fileType) throws FileNotFoundException, SmartsheetException {
        this.addImage("sheets/" + sheetId + "/rows/" + rowId + "/columns/" + columnId + "/cellimages", file, fileType, false, null);
    }

    @Override
    public void addImageToCell(long sheetId, long rowId, long columnId, String file, String fileType, boolean overrideValidation, String altText) throws FileNotFoundException, SmartsheetException {
        this.addImage("sheets/" + sheetId + "/rows/" + rowId + "/columns/" + columnId + "/cellimages", file, fileType, overrideValidation, altText);
    }

    private void addImage(String path, String file, String contentType, boolean overrideValidation, String altText) throws SmartsheetException, FileNotFoundException {
        Util.throwIfNull(file);
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (altText != null) {
            parameters.put("altText", altText);
        }
        if (overrideValidation) {
            parameters.put("overrideValidation", "true");
        }
        path = path + QueryUtil.generateUrl(null, parameters);
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve(path), HttpMethod.POST);
        try {
            request.getHeaders().put("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(file, "UTF-8") + "\"");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        File f = new File(file);
        FileInputStream is = new FileInputStream(f);
        HttpEntity entity = new HttpEntity();
        entity.setContentType(contentType);
        entity.setContent(is);
        entity.setContentLength(f.length());
        request.setEntity(entity);
        HttpResponse response = this.smartsheet.getHttpClient().request(request);
        switch (response.getStatusCode()) {
            case 200: {
                break;
            }
            default: {
                this.handleError(response);
            }
        }
        this.smartsheet.getHttpClient().releaseConnection();
    }
}

