/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.ShareResources;
import com.smartsheet.api.SightResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.ShareResourcesImpl;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.ContainerDestination;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.Sight;
import com.smartsheet.api.models.SightPublish;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class SightResourcesImpl
extends AbstractResources
implements SightResources {
    private ShareResources shares;

    public SightResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
        this.shares = new ShareResourcesImpl(smartsheet, "sights");
    }

    @Override
    public PagedResult<Sight> listSights(PaginationParameters paging, Date modifiedSince) throws SmartsheetException {
        String path = "sights";
        HashMap<String, Object> parameters = new HashMap();
        if (paging != null) {
            parameters = paging.toHashMap();
        }
        if (modifiedSince != null) {
            String isoDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(modifiedSince);
            parameters.put("modifiedSince", isoDate);
        }
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper(path, Sight.class);
    }

    @Override
    public Sight getSight(long sightId) throws SmartsheetException {
        return this.getResource("sights/" + sightId, Sight.class);
    }

    @Override
    public Sight updateSight(Sight sight) throws SmartsheetException {
        Util.throwIfNull(sight);
        return this.updateResource("sights/" + sight.getId(), Sight.class, sight);
    }

    @Override
    public void deleteSight(long sightId) throws SmartsheetException {
        this.deleteResource("sights/" + sightId, Sight.class);
    }

    @Override
    public Sight copySight(long sightId, ContainerDestination destination) throws SmartsheetException {
        return this.createResource("sights/" + sightId + "/copy", Sight.class, destination);
    }

    @Override
    public Sight moveSight(long sightId, ContainerDestination destination) throws SmartsheetException {
        return this.createResource("sights/" + sightId + "/move", Sight.class, destination);
    }

    @Override
    public SightPublish getPublishStatus(long sightId) throws SmartsheetException {
        return this.getResource("sights/" + sightId + "/publish", SightPublish.class);
    }

    @Override
    public SightPublish setPublishStatus(long sightId, SightPublish sightPublish) throws SmartsheetException {
        Util.throwIfNull(sightPublish);
        return this.updateResource("sights/" + sightId + "/publish", SightPublish.class, sightPublish);
    }

    @Override
    public ShareResources shareResources() {
        return this.shares;
    }
}

