/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.ShareResources;
import com.smartsheet.api.SheetAttachmentResources;
import com.smartsheet.api.SheetAutomationRuleResources;
import com.smartsheet.api.SheetColumnResources;
import com.smartsheet.api.SheetCommentResources;
import com.smartsheet.api.SheetCrossSheetReferenceResources;
import com.smartsheet.api.SheetDiscussionResources;
import com.smartsheet.api.SheetFilterResources;
import com.smartsheet.api.SheetResources;
import com.smartsheet.api.SheetRowResources;
import com.smartsheet.api.SheetSummaryResources;
import com.smartsheet.api.SheetUpdateRequestResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.ShareResourcesImpl;
import com.smartsheet.api.internal.SheetAttachmentResourcesImpl;
import com.smartsheet.api.internal.SheetAutomationRuleResourcesImpl;
import com.smartsheet.api.internal.SheetColumnResourcesImpl;
import com.smartsheet.api.internal.SheetCommentResourcesImpl;
import com.smartsheet.api.internal.SheetCrossSheetReferenceResourcesImpl;
import com.smartsheet.api.internal.SheetDiscussionResourcesImpl;
import com.smartsheet.api.internal.SheetFilterResourcesImpl;
import com.smartsheet.api.internal.SheetRowResourcesImpl;
import com.smartsheet.api.internal.SheetSummaryResourcesImpl;
import com.smartsheet.api.internal.SheetUpdateRequestResourcesImpl;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.http.HttpEntity;
import com.smartsheet.api.internal.http.HttpMethod;
import com.smartsheet.api.internal.http.HttpRequest;
import com.smartsheet.api.internal.http.HttpResponse;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.ContainerDestination;
import com.smartsheet.api.models.MultiRowEmail;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.Sheet;
import com.smartsheet.api.models.SheetEmail;
import com.smartsheet.api.models.SheetPublish;
import com.smartsheet.api.models.SortSpecifier;
import com.smartsheet.api.models.UpdateRequest;
import com.smartsheet.api.models.enums.CopyExclusion;
import com.smartsheet.api.models.enums.ObjectExclusion;
import com.smartsheet.api.models.enums.PaperSize;
import com.smartsheet.api.models.enums.SheetCopyInclusion;
import com.smartsheet.api.models.enums.SheetInclusion;
import com.smartsheet.api.models.enums.SheetTemplateInclusion;
import com.smartsheet.api.models.enums.SourceInclusion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;

public class SheetResourcesImpl
extends AbstractResources
implements SheetResources {
    private static final int BUFFER_SIZE = 4098;
    private ShareResources shares;
    private SheetRowResources rows;
    private SheetColumnResources columns;
    private SheetAttachmentResources attachments;
    private SheetDiscussionResources discussions;
    private SheetCommentResources comments;
    private SheetUpdateRequestResources updateRequests;
    private SheetFilterResources filters;
    private SheetAutomationRuleResources automationRules;
    private SheetCrossSheetReferenceResources crossSheetReferences;
    private SheetSummaryResources sheetSummary;

    public SheetResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
        this.shares = new ShareResourcesImpl(smartsheet, "sheets");
        this.rows = new SheetRowResourcesImpl(smartsheet);
        this.columns = new SheetColumnResourcesImpl(smartsheet);
        this.attachments = new SheetAttachmentResourcesImpl(smartsheet);
        this.discussions = new SheetDiscussionResourcesImpl(smartsheet);
        this.comments = new SheetCommentResourcesImpl(smartsheet);
        this.updateRequests = new SheetUpdateRequestResourcesImpl(smartsheet);
        this.filters = new SheetFilterResourcesImpl(smartsheet);
        this.automationRules = new SheetAutomationRuleResourcesImpl(smartsheet);
        this.crossSheetReferences = new SheetCrossSheetReferenceResourcesImpl(smartsheet);
        this.sheetSummary = new SheetSummaryResourcesImpl(smartsheet);
    }

    @Override
    public PagedResult<Sheet> listSheets(EnumSet<SourceInclusion> includes, PaginationParameters pagination) throws SmartsheetException {
        return this.listSheets(includes, pagination, null);
    }

    @Override
    public PagedResult<Sheet> listSheets(EnumSet<SourceInclusion> includes, PaginationParameters pagination, Date modifiedSince) throws SmartsheetException {
        String path = "sheets";
        HashMap<Object, Object> parameters = new HashMap();
        if (pagination != null) {
            parameters = pagination.toHashMap();
        }
        if (modifiedSince != null) {
            String isoDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(modifiedSince);
            parameters.put("modifiedSince", isoDate);
        }
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper(path, Sheet.class);
    }

    @Override
    @Deprecated
    public PagedResult<Sheet> listOrganizationSheets(PaginationParameters parameters) throws SmartsheetException {
        String path = "users/sheets";
        if (parameters != null) {
            path = path + parameters.toQueryString();
        }
        return this.listResourcesWithWrapper(path, Sheet.class);
    }

    @Override
    public Sheet getSheet(long id, EnumSet<SheetInclusion> includes, EnumSet<ObjectExclusion> excludes, Set<Long> rowIds, Set<Integer> rowNumbers, Set<Long> columnIds, Integer pageSize, Integer page) throws SmartsheetException {
        return this.getSheet(id, includes, excludes, rowIds, rowNumbers, columnIds, pageSize, page, null, null);
    }

    @Override
    public Sheet getSheet(long id, EnumSet<SheetInclusion> includes, EnumSet<ObjectExclusion> excludes, Set<Long> rowIds, Set<Integer> rowNumbers, Set<Long> columnIds, Integer pageSize, Integer page, Integer ifVersionAfter) throws SmartsheetException {
        return this.getSheet(id, includes, excludes, rowIds, rowNumbers, columnIds, pageSize, page, ifVersionAfter, null);
    }

    @Override
    public Sheet getSheet(long id, EnumSet<SheetInclusion> includes, EnumSet<ObjectExclusion> excludes, Set<Long> rowIds, Set<Integer> rowNumbers, Set<Long> columnIds, Integer pageSize, Integer page, Integer ifVersionAfter, Integer level) throws SmartsheetException {
        String path = "sheets/" + id;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        parameters.put("exclude", QueryUtil.generateCommaSeparatedList(excludes));
        parameters.put("rowIds", QueryUtil.generateCommaSeparatedList(rowIds));
        parameters.put("rowNumbers", QueryUtil.generateCommaSeparatedList(rowNumbers));
        parameters.put("columnIds", QueryUtil.generateCommaSeparatedList(columnIds));
        parameters.put("pageSize", pageSize);
        parameters.put("page", page);
        parameters.put("ifVersionAfter", ifVersionAfter);
        parameters.put("level", level);
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.getResource(path, Sheet.class);
    }

    @Override
    public void getSheetAsExcel(long id, OutputStream outputStream) throws SmartsheetException {
        this.getSheetAsFile(id, null, outputStream, "application/vnd.ms-excel");
    }

    @Override
    public void getSheetAsPDF(long id, OutputStream outputStream, PaperSize paperSize) throws SmartsheetException {
        this.getSheetAsFile(id, paperSize, outputStream, "application/pdf");
    }

    @Override
    public Sheet createSheet(Sheet sheet) throws SmartsheetException {
        return this.createResource("sheets", Sheet.class, sheet);
    }

    @Override
    public Sheet createSheetFromTemplate(Sheet sheet, EnumSet<SheetTemplateInclusion> includes) throws SmartsheetException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        String path = QueryUtil.generateUrl("sheets", parameters);
        return this.createResource(path, Sheet.class, sheet);
    }

    @Override
    public Sheet importCsv(String file, String sheetName, Integer headerRowIndex, Integer primaryRowIndex) throws SmartsheetException {
        return this.importFile("sheets/import", file, "text/csv", sheetName, headerRowIndex, primaryRowIndex);
    }

    @Override
    public Sheet importXlsx(String file, String sheetName, Integer headerRowIndex, Integer primaryRowIndex) throws SmartsheetException {
        return this.importFile("sheets/import", file, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", sheetName, headerRowIndex, primaryRowIndex);
    }

    @Override
    public Sheet createSheetInFolder(long folderId, Sheet sheet) throws SmartsheetException {
        return this.createResource("folders/" + folderId + "/sheets", Sheet.class, sheet);
    }

    @Override
    public Sheet createSheetInFolderFromTemplate(long folderId, Sheet sheet, EnumSet<SheetTemplateInclusion> includes) throws SmartsheetException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        String path = QueryUtil.generateUrl("folders/" + folderId + "/sheets", parameters);
        return this.createResource(path, Sheet.class, sheet);
    }

    @Override
    public Sheet importCsvInFolder(long folderId, String file, String sheetName, Integer headerRowIndex, Integer primaryRowIndex) throws SmartsheetException {
        return this.importFile("folders/" + folderId + "/sheets/import", file, "text/csv", sheetName, headerRowIndex, primaryRowIndex);
    }

    @Override
    public Sheet importXlsxInFolder(long folderId, String file, String sheetName, Integer headerRowIndex, Integer primaryRowIndex) throws SmartsheetException {
        return this.importFile("folders/" + folderId + "/sheets/import", file, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", sheetName, headerRowIndex, primaryRowIndex);
    }

    @Override
    public Sheet createSheetInWorkspace(long workspaceId, Sheet sheet) throws SmartsheetException {
        return this.createResource("workspaces/" + workspaceId + "/sheets", Sheet.class, sheet);
    }

    @Override
    public Sheet createSheetInWorkspaceFromTemplate(long workspaceId, Sheet sheet, EnumSet<SheetTemplateInclusion> includes) throws SmartsheetException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        String path = QueryUtil.generateUrl("workspaces/" + workspaceId + "/sheets", parameters);
        return this.createResource(path, Sheet.class, sheet);
    }

    @Override
    public Sheet importCsvInWorkspace(long workspaceId, String file, String sheetName, Integer headerRowIndex, Integer primaryRowIndex) throws SmartsheetException {
        return this.importFile("workspaces/" + workspaceId + "/sheets/import", file, "text/csv", sheetName, headerRowIndex, primaryRowIndex);
    }

    @Override
    public Sheet importXlsxInWorkspace(long workspaceId, String file, String sheetName, Integer headerRowIndex, Integer primaryRowIndex) throws SmartsheetException {
        return this.importFile("workspaces/" + workspaceId + "/sheets/import", file, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", sheetName, headerRowIndex, primaryRowIndex);
    }

    @Override
    public void deleteSheet(long id) throws SmartsheetException {
        this.deleteResource("sheets/" + id, Sheet.class);
    }

    @Override
    public Sheet updateSheet(Sheet sheet) throws SmartsheetException {
        return this.updateResource("sheets/" + sheet.getId(), Sheet.class, sheet);
    }

    @Override
    public int getSheetVersion(long id) throws SmartsheetException {
        return this.getResource("sheets/" + id + "/version", Sheet.class).getVersion();
    }

    @Override
    public void sendSheet(long id, SheetEmail email) throws SmartsheetException {
        this.createResource("sheets/" + id + "/emails", SheetEmail.class, email);
    }

    @Override
    public void getSheetAsCSV(long id, OutputStream outputStream) throws SmartsheetException {
        this.getSheetAsFile(id, null, outputStream, "text/csv");
    }

    @Override
    public SheetPublish getPublishStatus(long id) throws SmartsheetException {
        return this.getResource("sheets/" + id + "/publish", SheetPublish.class);
    }

    @Override
    public SheetPublish updatePublishStatus(long id, SheetPublish publish) throws SmartsheetException {
        return this.updateResource("sheets/" + id + "/publish", SheetPublish.class, publish);
    }

    @Override
    public Sheet copySheet(long sheetId, ContainerDestination containerDestination, EnumSet<SheetCopyInclusion> includes) throws SmartsheetException {
        return this.copySheet(sheetId, containerDestination, includes, null);
    }

    @Override
    public Sheet copySheet(long sheetId, ContainerDestination containerDestination, EnumSet<SheetCopyInclusion> includes, EnumSet<CopyExclusion> excludes) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/copy";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        parameters.put("exclude", QueryUtil.generateCommaSeparatedList(excludes));
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.createResource(path, Sheet.class, containerDestination);
    }

    @Override
    public Sheet moveSheet(long sheetId, ContainerDestination containerDestination) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/move";
        return this.createResource(path, Sheet.class, containerDestination);
    }

    @Override
    public UpdateRequest createUpdateRequest(long sheetId, MultiRowEmail email) throws SmartsheetException {
        return this.createResource("sheets/" + sheetId + "/updaterequests", UpdateRequest.class, email);
    }

    @Override
    public Sheet sortSheet(long sheetId, SortSpecifier sortSpecifier) throws SmartsheetException {
        return this.sortSheet(sheetId, sortSpecifier, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Sheet sortSheet(long sheetId, SortSpecifier sortSpecifier, Integer level) throws SmartsheetException {
        Util.throwIfNull(sortSpecifier);
        String path = "sheets/" + sheetId + "/sort";
        if (level != null) {
            path = path + "?level=" + level;
        }
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve(path), HttpMethod.POST);
        ByteArrayOutputStream objectBytesStream = new ByteArrayOutputStream();
        this.smartsheet.getJsonSerializer().serialize(sortSpecifier, objectBytesStream);
        HttpEntity entity = new HttpEntity();
        entity.setContentType("application/json");
        entity.setContent(new ByteArrayInputStream(objectBytesStream.toByteArray()));
        entity.setContentLength(objectBytesStream.size());
        request.setEntity(entity);
        Sheet obj = null;
        try {
            HttpResponse response = this.smartsheet.getHttpClient().request(request);
            switch (response.getStatusCode()) {
                case 200: {
                    InputStream inputStream = response.getEntity().getContent();
                    try {
                        obj = this.smartsheet.getJsonSerializer().deserialize(Sheet.class, inputStream);
                        return obj;
                    }
                    catch (IOException e) {
                        throw new SmartsheetException(e);
                    }
                }
                default: {
                    this.handleError(response);
                    return obj;
                }
            }
        }
        finally {
            this.smartsheet.getHttpClient().releaseConnection();
        }
    }

    @Override
    public ShareResources shareResources() {
        return this.shares;
    }

    @Override
    public SheetRowResources rowResources() {
        return this.rows;
    }

    @Override
    public SheetColumnResources columnResources() {
        return this.columns;
    }

    @Override
    public SheetAttachmentResources attachmentResources() {
        return this.attachments;
    }

    @Override
    public SheetDiscussionResources discussionResources() {
        return this.discussions;
    }

    @Override
    public SheetCommentResources commentResources() {
        return this.comments;
    }

    @Override
    public SheetUpdateRequestResources updateRequestResources() {
        return this.updateRequests;
    }

    @Override
    public SheetFilterResources filterResources() {
        return this.filters;
    }

    @Override
    public SheetAutomationRuleResources automationRuleResources() {
        return this.automationRules;
    }

    @Override
    public SheetCrossSheetReferenceResources crossSheetReferenceResources() {
        return this.crossSheetReferences;
    }

    @Override
    public SheetSummaryResources summaryResources() {
        return this.sheetSummary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Sheet importFile(String path, String file, String contentType, String sheetName, Integer headerRowIndex, Integer primaryRowIndex) throws SmartsheetException {
        Util.throwIfNull(path, file, contentType);
        Util.throwIfEmpty(path, file, contentType);
        File f = new File(file);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (sheetName == null) {
            sheetName = f.getName();
        }
        parameters.put("sheetName", sheetName);
        parameters.put("headerRowIndex", headerRowIndex);
        parameters.put("primaryRowIndex", primaryRowIndex);
        path = QueryUtil.generateUrl(path, parameters);
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve(path), HttpMethod.POST);
        request.getHeaders().put("Content-Disposition", "attachment");
        request.getHeaders().put("Content-Type", contentType);
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new SmartsheetException(e);
        }
        HttpEntity entity = new HttpEntity();
        entity.setContentType(contentType);
        entity.setContent(is);
        entity.setContentLength(f.length());
        request.setEntity(entity);
        Sheet obj = null;
        try {
            HttpResponse response = this.smartsheet.getHttpClient().request(request);
            switch (response.getStatusCode()) {
                case 200: {
                    obj = this.smartsheet.getJsonSerializer().deserializeResult(Sheet.class, response.getEntity().getContent()).getResult();
                    return obj;
                }
                default: {
                    this.handleError(response);
                    return obj;
                }
            }
        }
        finally {
            this.smartsheet.getHttpClient().releaseConnection();
        }
    }

    private void getSheetAsFile(long id, PaperSize paperSize, OutputStream outputStream, String contentType) throws SmartsheetException {
        Util.throwIfNull((Object)outputStream, (Object)contentType);
        String path = "sheets/" + id;
        if (paperSize != null) {
            path = path + "?paperSize=" + (Object)((Object)paperSize);
        }
        HttpRequest request = this.createHttpRequest(this.getSmartsheet().getBaseURI().resolve(path), HttpMethod.GET);
        request.getHeaders().put("Accept", contentType);
        HttpResponse response = this.getSmartsheet().getHttpClient().request(request);
        switch (response.getStatusCode()) {
            case 200: {
                try {
                    SheetResourcesImpl.copyStream(response.getEntity().getContent(), outputStream);
                    break;
                }
                catch (IOException e) {
                    throw new SmartsheetException(e);
                }
            }
            default: {
                this.handleError(response);
            }
        }
        this.getSmartsheet().getHttpClient().releaseConnection();
    }

    private static void copyStream(InputStream input, OutputStream output) throws IOException {
        int len;
        byte[] buffer = new byte[4098];
        while ((len = input.read(buffer)) != -1) {
            output.write(buffer, 0, len);
        }
    }
}

