/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.SheetSummaryResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.http.HttpEntity;
import com.smartsheet.api.internal.http.HttpMethod;
import com.smartsheet.api.internal.http.HttpRequest;
import com.smartsheet.api.internal.http.HttpResponse;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.BulkItemResult;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.Result;
import com.smartsheet.api.models.SheetSummary;
import com.smartsheet.api.models.SummaryField;
import com.smartsheet.api.models.enums.SummaryFieldExclusion;
import com.smartsheet.api.models.enums.SummaryFieldInclusion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class SheetSummaryResourcesImpl
extends AbstractResources
implements SheetSummaryResources {
    public SheetSummaryResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public SheetSummary getSheetSummary(long sheetId, EnumSet<SummaryFieldInclusion> includes, EnumSet<SummaryFieldExclusion> excludes) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/summary";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        parameters.put("exclude", QueryUtil.generateCommaSeparatedList(excludes));
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.getResource(path, SheetSummary.class);
    }

    @Override
    public PagedResult<SummaryField> getSheetSummaryFields(long sheetId, EnumSet<SummaryFieldInclusion> includes, EnumSet<SummaryFieldExclusion> excludes, PaginationParameters pagination) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/summary/fields";
        HashMap<Object, Object> parameters = new HashMap<String, String>();
        if (pagination != null) {
            parameters = pagination.toHashMap();
        }
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        parameters.put("exclude", QueryUtil.generateCommaSeparatedList(excludes));
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper(path, SummaryField.class);
    }

    @Override
    public List<SummaryField> addSheetSummaryFields(long sheetId, List<SummaryField> fields, Boolean renameIfConflict) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/summary/fields";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("renameIfConflict", renameIfConflict);
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.postAndReceiveList(path, fields, SummaryField.class);
    }

    @Override
    public BulkItemResult<SummaryField> addSheetSummaryFieldsWithPartialSuccess(long sheetId, List<SummaryField> fields, Boolean renameIfConflict) throws SmartsheetException {
        return this.doBulkOperation(sheetId, fields, renameIfConflict, HttpMethod.POST);
    }

    @Override
    public List<SummaryField> updateSheetSummaryFields(long sheetId, List<SummaryField> fields, Boolean renameIfConflict) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/summary/fields";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("renameIfConflict", renameIfConflict);
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.putAndReceiveList(path, fields, SummaryField.class);
    }

    @Override
    public BulkItemResult<SummaryField> updateSheetSummaryFieldsWithPartialSuccess(long sheetId, List<SummaryField> fields, Boolean renameIfConflict) throws SmartsheetException {
        return this.doBulkOperation(sheetId, fields, renameIfConflict, HttpMethod.PUT);
    }

    @Override
    public List<Long> deleteSheetSummaryFields(long sheetId, Set<Long> fieldIds, Boolean ignoreSummaryFieldsNotFound) throws SmartsheetException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String path = "sheets/" + sheetId + "/summary/fields";
        parameters.put("ids", QueryUtil.generateCommaSeparatedList(fieldIds));
        parameters.put("ignoreSummaryFieldsNotFound", ignoreSummaryFieldsNotFound);
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.deleteListResources(path, Long.class);
    }

    @Override
    public Result<SummaryField> addSheetSummaryFieldImage(long sheetId, long fieldId, String file, String contentType, String altText) throws SmartsheetException, FileNotFoundException {
        Util.throwIfNull(file);
        String path = "sheets/" + sheetId + "/summary/fields/" + fieldId + "/images";
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (altText != null) {
            parameters.put("altText", altText);
        }
        path = path + QueryUtil.generateUrl(null, parameters);
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve(path), HttpMethod.POST);
        try {
            request.getHeaders().put("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(file, "UTF-8") + "\"");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        File f = new File(file);
        FileInputStream is = new FileInputStream(f);
        HttpEntity entity = new HttpEntity();
        entity.setContentType(contentType);
        entity.setContent(is);
        entity.setContentLength(f.length());
        request.setEntity(entity);
        Result<SummaryField> obj = null;
        HttpResponse response = this.smartsheet.getHttpClient().request(request);
        switch (response.getStatusCode()) {
            case 200: {
                obj = this.smartsheet.getJsonSerializer().deserializeResult(SummaryField.class, response.getEntity().getContent());
                break;
            }
            default: {
                this.handleError(response);
            }
        }
        this.smartsheet.getHttpClient().releaseConnection();
        return obj;
    }

    private BulkItemResult<SummaryField> doBulkOperation(long sheetId, List<SummaryField> fields, Boolean renameIfConflict, HttpMethod method) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/summary/fields";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("allowPartialSuccess", "true");
        parameters.put("renameIfConflict", renameIfConflict);
        path = QueryUtil.generateUrl(path, parameters);
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve(path), method);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.smartsheet.getJsonSerializer().serialize(fields, baos);
        HttpEntity entity = new HttpEntity();
        entity.setContentType("application/json");
        entity.setContent(new ByteArrayInputStream(baos.toByteArray()));
        entity.setContentLength(baos.size());
        request.setEntity(entity);
        HttpResponse response = this.smartsheet.getHttpClient().request(request);
        BulkItemResult<SummaryField> result = null;
        switch (response.getStatusCode()) {
            case 200: {
                result = this.smartsheet.getJsonSerializer().deserializeBulkItemResult(SummaryField.class, response.getEntity().getContent());
                break;
            }
            default: {
                this.handleError(response);
            }
        }
        this.smartsheet.getHttpClient().releaseConnection();
        return result;
    }
}

