/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.AttachmentVersioningResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.Attachment;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class AttachmentVersioningResourcesImpl
extends AbstractResources
implements AttachmentVersioningResources {
    public AttachmentVersioningResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public void deleteAllVersions(long sheetId, long attachentId) throws SmartsheetException {
        this.deleteResource("sheets/" + sheetId + "/attachments/" + attachentId + "/versions", Attachment.class);
    }

    @Override
    public PagedResult<Attachment> listAllVersions(long sheetId, long attachmentId, PaginationParameters parameters) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/attachments/" + attachmentId + "/versions";
        if (parameters != null) {
            path = path + parameters.toQueryString();
        }
        return this.listResourcesWithWrapper(path, Attachment.class);
    }

    @Override
    public Attachment attachNewVersion(long sheetId, long attachmentId, File file, String contentType) throws FileNotFoundException, SmartsheetException {
        Util.throwIfNull(attachmentId, file, contentType);
        Util.throwIfEmpty(contentType);
        return this.attachNewVersion(sheetId, attachmentId, new FileInputStream(file), contentType, file.length(), file.getName());
    }

    private Attachment attachNewVersion(long sheetId, long attachmentId, InputStream inputStream, String contentType, long contentLength, String attachmentName) throws SmartsheetException {
        return super.attachFile("sheets/" + sheetId + "/attachments/" + attachmentId + "/versions", inputStream, contentType, contentLength, attachmentName);
    }
}

