/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.EventResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.http.HttpMethod;
import com.smartsheet.api.internal.http.HttpRequest;
import com.smartsheet.api.internal.http.HttpResponse;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.models.EventResult;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class EventResourcesImpl
extends AbstractResources
implements EventResources {
    public EventResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public EventResult listEvents(Object since, String streamPosition, Integer maxCount, Boolean numericDates) throws SmartsheetException {
        Object path = "events";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (since instanceof Date) {
            String isoDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(since);
            parameters.put("since", isoDate);
        } else {
            parameters.put("since", since);
        }
        parameters.put("streamPosition", streamPosition);
        parameters.put("maxCount", maxCount);
        parameters.put("numericDates", numericDates);
        path = (String)path + QueryUtil.generateUrl(null, parameters);
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve((String)path), HttpMethod.GET);
        EventResult obj = null;
        try {
            HttpResponse response = this.smartsheet.getHttpClient().request(request);
            switch (response.getStatusCode()) {
                case 200: {
                    obj = this.smartsheet.getJsonSerializer().deserializeEventResult(response.getEntity().getContent());
                    return obj;
                }
                default: {
                    this.handleError(response);
                    return obj;
                }
            }
        }
        finally {
            this.smartsheet.getHttpClient().releaseConnection();
        }
    }
}

